/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safekeyservice.jsserverckms;

import android.content.Context;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.http.WebSocket;
import com.koushikdutta.async.http.server.AsyncHttpServer;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.xdja.safekeyservice.jsserverckms.CkmsOperate;
import com.xdja.safekeyservice.jsserverckms.bean.RequestBean;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class CkmsWebSocketServer {
    public static final String KEY_id = "id";
    public static final String KEY_method = "method";
    public static final String KEY_ret_code = "ret_code";
    public static final String KEY_content = "content";
    public static final String WEBSOCKET_METHOD = "/ckmsv2";
    private static final String TAG = CkmsWebSocketServer.class.getSimpleName() + "Tag";
    private static CkmsWebSocketServer instance;
    private Gson gson = new Gson();
    private int portStart = 9988;
    private int portEnd = 9999;
    private Context context;
    private AsyncHttpServer server = new AsyncHttpServer();
    ArrayList<Integer> errorList = new ArrayList();
    private int flag = 0;

    private CkmsWebSocketServer(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CkmsWebSocketServer getInstance(Context context) {
        if (instance != null) return instance;
        Class<CkmsWebSocketServer> clazz = CkmsWebSocketServer.class;
        synchronized (CkmsWebSocketServer.class) {
            if (instance != null) return instance;
            instance = new CkmsWebSocketServer(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public int start() {
        int port;
        if (this.flag == 1) {
            return 0;
        }
        for (port = this.portStart; port <= this.portEnd; ++port) {
            Log.w((String)"CKMS_JS", (String)("server port: " + port));
            this.server.setErrorCallback((CompletedCallback)new ErrorCallback(port));
            this.server.listen(port);
            if (!this.errorList.contains(port)) break;
        }
        if (port > this.portEnd) {
            return -1;
        }
        this.server.websocket(WEBSOCKET_METHOD, new AsyncHttpServer.WebSocketRequestCallback(){

            public void onConnected(final WebSocket webSocket, AsyncHttpServerRequest request) {
                webSocket.setClosedCallback(new CompletedCallback(){

                    public void onCompleted(Exception e) {
                        if (e != null) {
                            Log.e((String)"testPort", (String)e.toString());
                        }
                    }
                });
                webSocket.setStringCallback(new WebSocket.StringCallback(){

                    public void onStringAvailable(String s) {
                        RequestBean requestBean = (RequestBean)CkmsWebSocketServer.this.gson.fromJson(s, RequestBean.class);
                        if (requestBean != null) {
                            CkmsWebSocketServer.this.handleRequest(webSocket, requestBean);
                        }
                    }
                });
            }
        });
        if (this.errorList.contains(port)) {
            return -1;
        }
        this.flag = 1;
        return 0;
    }

    private void handleRequest(WebSocket webSocket, RequestBean requestBean) {
        String result;
        String methodStr = requestBean.getMethod();
        Gson gson = new Gson();
        try {
            Method method = CkmsOperate.class.getDeclaredMethod(methodStr, String.class);
            result = (String)method.invoke((Object)CkmsOperate.getInstance(this.context), gson.toJson(requestBean.getArgs()));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            JsonObject errorJs = new JsonObject();
            errorJs.addProperty(KEY_ret_code, (Number)51000);
            result = errorJs.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonObject errorJs = new JsonObject();
            errorJs.addProperty(KEY_ret_code, (Number)51000);
            result = errorJs.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"");
        sb.append(KEY_id);
        sb.append("\":");
        sb.append("\"");
        sb.append(requestBean.getId());
        sb.append("\"");
        sb.append(",");
        sb.append("\"");
        sb.append(KEY_method);
        sb.append("\":");
        sb.append("\"");
        sb.append(methodStr);
        sb.append("\"");
        sb.append(",");
        sb.append("\"");
        sb.append(KEY_content);
        sb.append("\":");
        sb.append(result);
        sb.append("}");
        webSocket.send(sb.toString());
    }

    public int getStartFlag() {
        return this.flag;
    }

    class ErrorCallback
    implements CompletedCallback {
        private int port;

        public ErrorCallback(int port) {
            this.port = port;
        }

        public void onCompleted(Exception ex) {
            CkmsWebSocketServer.this.errorList.add(this.port);
        }
    }
}

