/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ckms.chip;

import android.content.Context;
import android.util.Log;
import android.util.Pair;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.multi.unitepin.jar.MultiChipUnitePinManager;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiCCManager;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.safekeyjar.Base64.Base64;
import com.xdja.safekeyjar.XDJASafeTF;
import com.xdja.safekeyjar.util.Arithmetic;
import com.xdja.safekeyjar.util.StringResult;
import com.xdja.unitepin.UnitePinManager;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CKMSChip {
    private static CKMSChip instance;
    private Context context;
    public static final int TYPE_COVERKEY = 8;
    public static final int TYPE_BLUEKEY = 4;
    public static final int TYPE_NOT_BLUEKEY = 3;
    public static final int TYPE_NULL = -1;
    private ExecutorService cachedThreadPool = Executors.newSingleThreadExecutor();
    private CardOperate operate = new CardOperate();

    private CKMSChip() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CKMSChip getInstance() {
        if (instance != null) return instance;
        Class<CKMSChip> clazz = CKMSChip.class;
        synchronized (CKMSChip.class) {
            if (instance != null) return instance;
            instance = new CKMSChip();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int setContext(Context context) {
        if (context == null) {
            return -10000;
        }
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
        return 0;
    }

    public int getType(Context context) {
        if (this.context == null) {
            if (context == null) {
                return -10000;
            }
            this.init(context, new Boolean[0]);
        }
        if (this.operate.getXdjaSafeTF() != null) {
            return 3;
        }
        if (this.operate.getProxy() != null) {
            XDJA_DEVINFO devInfo = new XDJA_DEVINFO();
            int ret = this.operate.getProxy().GetDevInfo(devInfo);
            if (ret != 0) {
                return -1;
            }
            if (devInfo.cardtype == 1536) {
                return 8;
            }
            if (devInfo.cardtype == 1792) {
                return 4;
            }
            if (devInfo.cardtype == 512 || devInfo.cardtype == 531 || devInfo.cardtype == 535) {
                return 3;
            }
            return -1;
        }
        return -1;
    }

    public int init(Context context, Boolean ... isSync) {
        if (context == null) {
            return -10000;
        }
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
        XDJASafeTF.getInstance().init(this.context);
        UnitePinManager.getInstance().init(this.context);
        int ret = XDJASafeTF.getInstance().detectSafeCard();
        Log.w((String)"GetAll", (String)("ckms detect tf,chip ret: " + ret));
        if (ret != 0) {
            ret = -1;
            if (isSync != null && isSync.length > 0 && !isSync[0].booleanValue()) {
                this.StartInitOtherChipThread();
                ret = 0;
            } else {
                ret = this.initOtherChipManager();
                Log.w((String)"GetAll", (String)("ckms initOper ret: " + ret));
            }
        } else {
            this.operate.setXdjaSafeTF(XDJASafeTF.getInstance());
        }
        Log.w((String)"GetAll", (String)"ckms init end: ");
        return ret;
    }

    void StartInitOtherChipThread() {
        this.cachedThreadPool.execute(new InitOtherChipRunnable());
    }

    private int initOtherChipManager() {
        int ret = -1;
        Log.w((String)"GetAll", (String)"CKMS getMultiJniApi start: ");
        Pair pair = JarMultiJniApiManager.getInstance().getAll(this.context);
        if ((Integer)pair.first == 0) {
            for (JniApiParam param : (List)pair.second) {
                Pair makePair;
                if (param.chipType == 4) {
                    makePair = JarMultiJniApiManager.getInstance().make(this.context, param.cardId);
                    if ((Integer)makePair.first != 0) continue;
                    this.operate.setProxy((JarJniApiProxy)makePair.second);
                    ret = 0;
                    continue;
                }
                if (param.chipType != 8) continue;
                makePair = JarMultiJniApiManager.getInstance().make(this.context, param.cardId);
                if ((Integer)makePair.first != 0) break;
                this.operate.setProxy((JarJniApiProxy)makePair.second);
                ret = 0;
                break;
            }
        }
        return ret;
    }

    public int GetPinTryCount(int pinRole) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        return this.operate.GetPinTryCount(pinRole);
    }

    @Deprecated
    public StringResult getSafeCardID() {
        if (!this.judgeIsInit()) {
            return new StringResult(-10000, "");
        }
        XDJA_DEVINFO devInfo = new XDJA_DEVINFO();
        String cardId = "";
        int ret = this.operate.GetDevInfo(devInfo);
        if (ret == 0) {
            cardId = new String(devInfo.cardid, 0, 32);
        }
        StringResult result = new StringResult(ret, cardId);
        return result;
    }

    @Deprecated
    public StringResult getSafeCardSn(int containNo, int certType) {
        if (!this.judgeIsInit()) {
            return new StringResult(-10000, "");
        }
        if (certType == 1) {
            certType = 2;
        } else if (certType == 2) {
            certType = 5;
        } else {
            return new StringResult(-10005, "");
        }
        byte[] certId = Arithmetic.convertToFid((int)containNo, (int)certType);
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[2];
        int ret = this.operate.ReadCert(certId, certBuf, certLen);
        if (ret != 0) {
            StringResult result = new StringResult(ret, "");
            return result;
        }
        X509Certificate x509Cert = Arithmetic.getX509Certificate((byte[])certBuf, (int)certLen[0]);
        if (x509Cert == null) {
            StringResult result = new StringResult(-10004, "");
            return result;
        }
        byte[] certSn = x509Cert.getSerialNumber().toByteArray();
        System.arraycopy(certSn, 0, certBuf, 0, certSn.length);
        certLen[0] = certSn.length;
        String stringCertSn = "";
        for (int i = 0; i < certLen[0]; ++i) {
            stringCertSn = stringCertSn + String.format("%02x", certBuf[i]);
        }
        StringResult result = new StringResult(ret, stringCertSn);
        return result;
    }

    public int SM2Sign(int role, String pin, int containNo, int certType, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        byte[] pubfid = new byte[2];
        byte[] prifid = new byte[2];
        if (certType == 1) {
            certType = 2;
        } else if (certType == 2) {
            certType = 5;
        } else {
            return -10005;
        }
        byte[] certId = Arithmetic.convertToFid((int)containNo, (int)certType);
        pubfid[0] = 0;
        pubfid[1] = (byte)(certId[1] + 1);
        prifid[0] = 0;
        prifid[1] = (byte)(certId[1] + 2);
        int ret = this.operate.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
        if (ret == -15 && (ret = this.operate.VerifyPIN(role, pin.getBytes(), pin.length())) == 0) {
            ret = this.operate.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public int SM2SignVerify(int role, String pin, int containNo, int certType, int dataType, byte[] dataIn, int inLen, byte[] signatureData) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        byte[] pubfid = new byte[2];
        if (certType == 1) {
            certType = 2;
        } else if (certType == 2) {
            certType = 5;
        } else {
            return -10005;
        }
        byte[] certId = Arithmetic.convertToFid((int)containNo, (int)certType);
        pubfid[0] = 0;
        pubfid[1] = (byte)(certId[1] + 1);
        int ret = this.operate.SM2SignVerify(pubfid, dataType, null, dataIn, inLen, signatureData);
        if (ret == -15 && (ret = this.operate.VerifyPIN(role, pin.getBytes(), pin.length())) == 0) {
            ret = this.operate.SM2SignVerify(pubfid, dataType, null, dataIn, inLen, signatureData);
        }
        return ret;
    }

    public int SM3(byte[] dataIn, int inLen, byte[] dataOut) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        return this.operate.SM3(dataIn, inLen, dataOut);
    }

    public int SM1KEY(byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        return this.operate.SM1KEY(tmpKey, dataIn, inLen, flag, dataOut, IV);
    }

    public int SM1(byte[] dataIn, int inLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        return this.operate.SM1(dataIn, inLen, flag, dataOut, kID, IV);
    }

    public int GetActivateState() {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        return this.operate.GetActivateState();
    }

    public int ActivateCardByURL(String url) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        return this.operate.ActivateCardByURL(url);
    }

    public int GenSM2KeyPair(byte[] pubfid, byte[] prifid, XDJA_SM2_PUBKEY pubkey, XDJA_SM2_PRIKEY prikey) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        return this.operate.GenSM2KeyPair(pubfid, prifid, pubkey, prikey);
    }

    public StringResult getSafeCardCertification(int containNo, int certType) {
        if (!this.judgeIsInit()) {
            return new StringResult(-10000, "");
        }
        if (certType == 1) {
            certType = 2;
        } else if (certType == 2) {
            certType = 5;
        } else {
            return new StringResult(-10005, "");
        }
        byte[] certId = Arithmetic.convertToFid((int)containNo, (int)certType);
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[2];
        int ret = this.operate.ReadCert(certId, certBuf, certLen);
        if (ret != 0) {
            StringResult result = new StringResult(ret, "");
            return result;
        }
        String stringCertContent = Base64.encodeBytes((byte[])certBuf, (int)0, (int)certLen[0], (int)8);
        StringResult result = new StringResult(ret, stringCertContent);
        return result;
    }

    public int GetDevInfo(XDJA_DEVINFO devInfo) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        return this.operate.GetDevInfo(devInfo);
    }

    public int detectSafeCard() {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        XDJA_DEVINFO devInfo = new XDJA_DEVINFO();
        int result = this.GetDevInfo(devInfo);
        return result;
    }

    public int VerifyPIN(int pinRole, byte[] pin, int pinLen) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        return this.operate.VerifyPIN(pinRole, pin, pinLen);
    }

    public int ChangePIN(int pinRole, byte[] oldPin, int oldLen, byte[] newPin, int newLen) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        return this.operate.ChangePIN(pinRole, oldPin, oldLen, newPin, newLen);
    }

    public int uniteGetPin(int role, String[] pin) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        return this.operate.uniteGetPin(role, pin);
    }

    public int SM4ForCoverKey(byte[] dataIn, int dataLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        if (!this.judgeIsInit()) {
            return -10000;
        }
        return this.operate.SM4ForCoverKey(dataIn, dataLen, flag, dataOut, kID, IV);
    }

    private boolean judgeIsInit() {
        if (this.context == null) {
            return false;
        }
        if (this.operate.getProxy() == null && this.operate.getXdjaSafeTF() == null) {
            return this.reInit(this.context);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reInit(Context context) {
        Class<CKMSChip> clazz = CKMSChip.class;
        synchronized (CKMSChip.class) {
            if (this.operate.getProxy() == null && this.operate.getXdjaSafeTF() == null) {
                this.init(context, true);
                if (this.operate.getProxy() != null || this.operate.getXdjaSafeTF() != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    class CardOperate {
        private XDJASafeTF xdjaSafeTF;
        private JarJniApiProxy proxy;

        CardOperate() {
        }

        public JarJniApiProxy getProxy() {
            return this.proxy;
        }

        public void setProxy(JarJniApiProxy proxy) {
            this.proxy = proxy;
        }

        public XDJASafeTF getXdjaSafeTF() {
            return this.xdjaSafeTF;
        }

        public void setXdjaSafeTF(XDJASafeTF xdjaSafeTF) {
            this.xdjaSafeTF = xdjaSafeTF;
        }

        public int GetPinTryCount(int pinRole) {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return this.xdjaSafeTF.GetPinTryCount(pinRole);
            }
            if (this.proxy != null) {
                return this.proxy.GetPinTryCount(pinRole);
            }
            return -97;
        }

        public int GetDevInfo(XDJA_DEVINFO devInfo) {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return this.xdjaSafeTF.GetDevInfo(devInfo);
            }
            if (this.proxy != null) {
                return this.proxy.GetDevInfo(devInfo);
            }
            return -97;
        }

        public int ReadCert(byte[] fid, byte[] certBuf, int[] certLen) {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return this.xdjaSafeTF.ReadCert(fid, certBuf, certLen);
            }
            if (this.proxy != null) {
                return this.proxy.ReadCert(fid, certBuf, certLen);
            }
            return -97;
        }

        public int SM2Sign(byte[] pubfid, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return this.xdjaSafeTF.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
            }
            if (this.proxy != null) {
                return this.proxy.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
            }
            return -97;
        }

        public int SM2SignVerify(byte[] pubfid, int dataType, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return this.xdjaSafeTF.SM2SignVerify(pubfid, dataType, pubkey, dataIn, inLen, signatureData);
            }
            if (this.proxy != null) {
                return this.proxy.SM2SignVerify(pubfid, dataType, pubkey, dataIn, inLen, signatureData);
            }
            return -97;
        }

        public int VerifyPIN(int pinRole, byte[] pin, int pinLen) {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return UnitePinManager.getInstance().uniteVerifyPin(pinRole, new String(pin));
            }
            if (this.proxy != null) {
                return this.proxy.VerifyPIN(pinRole, pin, pinLen);
            }
            return -97;
        }

        public int ChangePIN(int pinRole, byte[] oldPin, int oldLen, byte[] newPin, int newLen) {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return UnitePinManager.getInstance().uniteChangePin(pinRole, new String(oldPin), new String(newPin));
            }
            if (this.proxy != null) {
                return this.proxy.ChangePIN(pinRole, oldPin, oldLen, newPin, newLen);
            }
            return -97;
        }

        public int SM3(byte[] dataIn, int inLen, byte[] dataOut) {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return this.xdjaSafeTF.SM3(dataIn, inLen, dataOut);
            }
            if (this.proxy != null) {
                return this.proxy.SM3(dataIn, inLen, dataOut);
            }
            return -97;
        }

        public int SM1KEY(byte[] tmpKey, byte[] datain, int inLen, int flag, byte[] dataOut, byte[] IV) {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return this.xdjaSafeTF.SM1KEY(tmpKey, datain, inLen, flag, dataOut, IV);
            }
            if (this.proxy != null) {
                return this.proxy.SM1KEY(tmpKey, datain, inLen, flag, dataOut, IV);
            }
            return -97;
        }

        public int SM1(byte[] dataIn, int inLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return this.xdjaSafeTF.SM1(dataIn, inLen, flag, dataOut, kID, IV);
            }
            if (this.proxy != null) {
                return this.proxy.SM1(dataIn, inLen, flag, dataOut, kID, IV);
            }
            return -97;
        }

        public int GetActivateState() {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return this.xdjaSafeTF.GetActivateState();
            }
            if (this.proxy != null) {
                return this.proxy.GetActivateState();
            }
            return -97;
        }

        public int ActivateCardByURL(String url) {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return this.xdjaSafeTF.ActivateCardByURL(url);
            }
            if (this.proxy != null) {
                return 0;
            }
            return -97;
        }

        public int GenSM2KeyPair(byte[] pubfid, byte[] prifid, XDJA_SM2_PUBKEY pubkey, XDJA_SM2_PRIKEY prikey) {
            if (!this.judge()) {
                return -97;
            }
            if (this.xdjaSafeTF != null) {
                return this.xdjaSafeTF.GenSM2KeyPair(pubfid, prifid, pubkey, prikey);
            }
            if (this.proxy != null) {
                return this.proxy.GenSM2KeyPair(pubfid, prifid, pubkey, prikey);
            }
            return -97;
        }

        public int SM4ForCoverKey(byte[] dataIn, int dataLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
            return JarMultiJniApiCCManager.getInstance().SM4(this.proxy, dataIn, dataLen, flag, dataOut, kID, IV);
        }

        public int uniteGetPin(int role, String[] pin) {
            if (pin == null || pin.length < 1) {
                return -20003;
            }
            if (!this.judge()) {
                return -20006;
            }
            if (this.xdjaSafeTF != null) {
                return UnitePinManager.getInstance().uniteGetPin(role, pin);
            }
            if (this.proxy != null) {
                Pair cardIdPair = this.proxy.getCardId();
                if ((Integer)cardIdPair.first != 0) {
                    return -20006;
                }
                Pair pinPair = MultiChipUnitePinManager.getInstance().getPin(CKMSChip.this.context, (String)cardIdPair.second, role);
                if ((Integer)pinPair.first != 0) {
                    return -20006;
                }
                pin[0] = (String)pinPair.second;
                return 0;
            }
            return -20006;
        }

        private boolean judge() {
            int ret;
            return this.xdjaSafeTF != null || this.proxy != null || (ret = CKMSChip.this.init(CKMSChip.this.context, new Boolean[0])) == 0;
        }
    }

    class InitOtherChipRunnable
    implements Runnable {
        InitOtherChipRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<CKMSChip> clazz = CKMSChip.class;
            synchronized (CKMSChip.class) {
                if (CKMSChip.this.operate.getProxy() == null && CKMSChip.this.operate.getXdjaSafeTF() == null) {
                    CKMSChip.this.initOtherChipManager();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

