/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ckms.chip;

import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.safekeyjar.util.Arithmetic;

public class MultiJniApiExtra {
    public int rsaPriKeyCalc(JarJniApiProxy proxy, String pin, int role, byte[] pDataIn, byte[] pDataOut, int[] outLen, int containNo, int certType) {
        byte[] prikeyId = new byte[2];
        if (certType == 1) {
            certType = 4;
        } else if (certType == 2) {
            certType = 7;
        } else {
            return -10008;
        }
        prikeyId = Arithmetic.convertToFid((int)containNo, (int)certType);
        byte[] tempDataIn = new byte[128];
        byte[] tempDataOut = new byte[128];
        int[] tempOutLen = new int[1];
        int ret = proxy.VerifyPIN(role, pin.getBytes(), pin.length());
        if (ret != 0) {
            return ret;
        }
        int inLen = pDataIn.length;
        if (inLen < 128) {
            int padLen = 125 - inLen;
            tempDataIn[0] = 0;
            tempDataIn[1] = 1;
            for (int i = 2; i < 2 + padLen; ++i) {
                tempDataIn[i] = -1;
            }
            tempDataIn[2 + padLen] = 0;
            System.arraycopy(pDataIn, 0, tempDataIn, 3 + padLen, inLen);
            ret = proxy.RSAPriKeyCalc(prikeyId, tempDataIn, tempDataIn.length, tempDataOut, tempOutLen);
        } else {
            ret = proxy.RSAPriKeyCalc(prikeyId, pDataIn, pDataIn.length, tempDataOut, tempOutLen);
        }
        if (ret == 0) {
            boolean pkcs1padding = false;
            if (tempOutLen[0] == 128 && tempDataOut[0] == 0 && tempDataOut[1] == 2) {
                int i = 0;
                for (i = 2; i < 128 && 0 != tempDataOut[i]; ++i) {
                }
                if (128 != i) {
                    outLen[0] = tempOutLen[0] - (i + 1);
                    System.arraycopy(tempDataOut, i + 1, pDataOut, 0, outLen[0]);
                }
            }
            if (!pkcs1padding) {
                outLen[0] = tempOutLen[0];
                System.arraycopy(tempDataOut, 0, pDataOut, 0, outLen[0]);
            }
        }
        return ret;
    }

    public int rsaPubKeyCalc(JarJniApiProxy proxy, byte[] pDataIn, byte[] pDataOut, int[] outLen, int containNo, int certType) {
        byte[] pubkeyId = new byte[2];
        if (certType == 1) {
            certType = 3;
        } else if (certType == 2) {
            certType = 6;
        } else {
            return -10008;
        }
        pubkeyId = Arithmetic.convertToFid((int)containNo, (int)certType);
        byte[] tempDataIn = new byte[128];
        byte[] tempDataOut = new byte[128];
        int[] tempOutLen = new int[1];
        int ret = -1;
        int inLen = 0;
        int padLen = 0;
        inLen = pDataIn.length;
        if (inLen < 128) {
            padLen = 125 - inLen;
            tempDataIn[0] = 0;
            tempDataIn[1] = 2;
            for (int i = 2; i < 2 + padLen; ++i) {
                tempDataIn[i] = (byte)(Math.random() * 254.0 + 1.0);
            }
            tempDataIn[2 + padLen] = 0;
            System.arraycopy(pDataIn, 0, tempDataIn, 3 + padLen, inLen);
            ret = proxy.RSAPubKeyCalc(pubkeyId, null, tempDataIn, 128, tempDataOut, tempOutLen);
        } else {
            ret = proxy.RSAPubKeyCalc(pubkeyId, null, pDataIn, pDataIn.length, tempDataOut, tempOutLen);
        }
        if (ret == 0) {
            boolean pkcs1padding = false;
            if (tempOutLen[0] == 128 && tempDataOut[0] == 0 && tempDataOut[1] == 1) {
                int i = 0;
                for (i = 2; i < 128; ++i) {
                    if (0 != tempDataOut[i]) continue;
                    pkcs1padding = true;
                    break;
                }
                if (128 != i) {
                    outLen[0] = tempOutLen[0] - (i + 1);
                    System.arraycopy(tempDataOut, i + 1, pDataOut, 0, outLen[0]);
                }
            }
            if (!pkcs1padding) {
                outLen[0] = tempOutLen[0];
                System.arraycopy(tempDataOut, 0, pDataOut, 0, outLen[0]);
            }
        }
        return ret;
    }

    private int sm2Encrypt(JarJniApiProxy proxy, int role, String pin, int containNo, int certType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        byte[] pubfid = new byte[2];
        if (certType == 1) {
            certType = 2;
        } else if (certType == 2) {
            certType = 5;
        } else {
            return -10005;
        }
        byte[] certId = Arithmetic.convertToFid((int)containNo, (int)certType);
        pubfid[0] = 0;
        pubfid[1] = (byte)(certId[1] + 1);
        int ret = proxy.VerifyPIN(role, pin.getBytes(), pin.length());
        if (ret == 0) {
            ret = proxy.SM2Encrypt(pubfid, null, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public int sm2Decrypt(JarJniApiProxy proxy, int role, String pin, int containNo, int certType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        byte[] prifid = new byte[2];
        if (certType == 1) {
            certType = 2;
        } else if (certType == 2) {
            certType = 5;
        } else {
            return -10005;
        }
        byte[] certId = Arithmetic.convertToFid((int)containNo, (int)certType);
        prifid[0] = 0;
        prifid[1] = (byte)(certId[1] + 2);
        int ret = proxy.VerifyPIN(role, pin.getBytes(), pin.length());
        if (ret == 0) {
            ret = proxy.SM2Decrypt(prifid, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public int sm2SignVerify(JarJniApiProxy proxy, int role, String pin, int containNo, int certType, int dataType, byte[] dataIn, int inLen, byte[] signatureData) {
        byte[] pubfid = new byte[2];
        if (certType == 1) {
            certType = 2;
        } else if (certType == 2) {
            certType = 5;
        } else {
            return -10005;
        }
        byte[] certId = Arithmetic.convertToFid((int)containNo, (int)certType);
        pubfid[0] = 0;
        pubfid[1] = (byte)(certId[1] + 1);
        int ret = proxy.VerifyPIN(role, pin.getBytes(), pin.length());
        if (ret == 0) {
            ret = proxy.SM2SignVerify(pubfid, dataType, null, dataIn, inLen, signatureData);
        }
        return ret;
    }

    public int sm2Sign(JarJniApiProxy proxy, int role, String pin, int containNo, int certType, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        byte[] pubfid = new byte[2];
        byte[] prifid = new byte[2];
        if (certType == 1) {
            certType = 2;
        } else if (certType == 2) {
            certType = 5;
        } else {
            return -10005;
        }
        byte[] certId = Arithmetic.convertToFid((int)containNo, (int)certType);
        pubfid[0] = 0;
        pubfid[1] = (byte)(certId[1] + 1);
        prifid[0] = 0;
        prifid[1] = (byte)(certId[1] + 2);
        int ret = proxy.VerifyPIN(role, pin.getBytes(), pin.length());
        if (ret == 0) {
            ret = proxy.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }
}

