package com.xdja.multichip;

import com.xdja.skfapi.EccPublicKeyBlob;
import com.xdja.skfapi.RsaPublicKeyBlob;

/**
 * Created by xwy on 2017/7/25.
 */

public class PublicKeyUtils {

    /**
     * 根据传入输入的ECC公钥数组转换成ECC公钥结构
     * @param blob ECC公钥数组
     * @return ECC公钥结构
     */
    public static EccPublicKeyBlob byteToEccPublicKeyBlob(byte[] blob) {
        if (blob == null || blob.length != 132) {
            return null;
        }
        byte[] bitLenB = new byte[4];
        System.arraycopy(blob, 0, bitLenB, 0, 4);

        EccPublicKeyBlob eccPublicKeyBlob = new EccPublicKeyBlob();
        eccPublicKeyBlob.bitLen = hexByteToInteger(bitLenB);
        System.arraycopy(blob, 4, eccPublicKeyBlob.xCoordinate, 0, 64);
        System.arraycopy(blob, 68, eccPublicKeyBlob.yCoordinate, 0, 64);
        return eccPublicKeyBlob;
    }


    /**
     * 根据传入输入的RSA公钥数组转换成RSA公钥结构
     * @param blob RSA公钥数组
     * @return RSA公钥结构
     */
    public static RsaPublicKeyBlob byteToRsaPublicKeyBlob(byte[] blob) {
        if (blob == null || blob.length != 268) {
            return null;
        }
        byte[] algIDB = new byte[4];
        System.arraycopy(blob, 0, algIDB, 0, 4);

        byte[] bitLenB = new byte[4];
        System.arraycopy(blob, 4, bitLenB, 0, 4);

        RsaPublicKeyBlob rsaPublicKeyBlob = new RsaPublicKeyBlob();
        rsaPublicKeyBlob.algID = hexByteToInteger(algIDB);
        rsaPublicKeyBlob.bitLen = hexByteToInteger(bitLenB);
        System.arraycopy(blob, 8, rsaPublicKeyBlob.modulus, 0, 256);
        System.arraycopy(blob, 264, rsaPublicKeyBlob.publicExponent, 0, 4);
        return rsaPublicKeyBlob;
    }

    /**
     * 二进制数组转换成10进制数字
     * @param a
     * @return
     */
    private static int hexByteToInteger(byte[] a){
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < a.length; i++) {
            b.append(a[i]);
        }
        return Integer.parseInt(b.toString(),16);
    }
}
