package com.xdja.multichip;

import android.content.Context;
import android.util.Pair;

import com.xdja.multichip.jar.MultiChipJar;
import com.xdja.multichip.param.ChipParam;
import com.xdja.multichip.param.ResultBean;
import com.xdja.multichip.param.SuperChip;

import java.util.List;

/**
 * Created by xwy on 2017/6/23.
 */

public class XDJAMultiChipUtils {

    /**
     * 根据卡号获取对应的卡操作Binder
     *
     * @param context
     * @param cardId
     * @return
     */
    public static Pair<Integer, SuperChip> getChipBinderByCardId(Context context, String cardId) {
        Pair<Integer, List<ChipParam>> listPair = MultiChipJar.getAllChip(context);
        if (listPair.first != 0) {
            return Pair.create(-1, null);
        }
        List<ChipParam> paramList = listPair.second;
        for (ChipParam c : paramList) {
            if (c.uniqueID.equals(cardId)) {
                return MultiChipJar.getSuperChip(context, c);
            }
        }
        return Pair.create(-1, null);
    }

    /**
     * 根据卡号获取对应的卡信息
     *
     * @param context
     * @param cardId
     * @return
     */
    public static ChipParam getChipParamByCardId(Context context, String cardId) {
        Pair<Integer, List<ChipParam>> listPair = MultiChipJar.getAllChip(context);
        if (listPair.first != 0) {
            return null;
        }
        List<ChipParam> paramList = listPair.second;
        for (ChipParam c : paramList) {
            if (c.uniqueID.equals(cardId)) {
                return c;
            }
        }
        return null;
    }

    /**
     * 判断PIN码是否重试测试是否为最大重试次数
     *
     * PIN码剩余次数 和 角色，作为是否返回PIN码的条件<p>
     * 当返回为false时，不返回PIN码<p>
     * 当返回为true时，接着流程判断.<p>
     * <p>
     * 当PIN码剩余次数等于10，返回true<p>
     * 当PIN码剩余次数等于5，同时角色为0x01时，返回true<p>
     * 其他返回false<p>
     *
     * @param context
     * @param cardId 卡ID
     * @param role 角色
     * @return Pair.first错误码，为0是second有效
     * Pair.second为当前PIN码是否重试测试是否为最大重试次数
     */
    public static Pair<Integer, Boolean> judgePinEnable(Context context, String cardId, int role) {
        Pair<Integer, SuperChip> pair = getChipBinderByCardId(context, cardId);
        if (pair.first != 0) {
            return Pair.create(pair.first, null);
        }
        Pair<Integer, Long> longPair = getFirstApplicationHandle(context,cardId);
        if (longPair.first !=0){
            return Pair.create(longPair.first, null);
        }

        ChipParam chipParam = getChipParamByCardId(context, cardId);
        if (chipParam == null){
            return Pair.create(-1, null);
        }
        long happlicationHandle = longPair.second;
        Pair<Integer, ResultBean<Integer[]>> beanPair = pair.second.GetPINInfo(happlicationHandle, role);
        if (beanPair.first !=0){
            return Pair.create(beanPair.first, null);
        }
        //boolean isEnable = beanPair.second.result[1] == beanPair.second.result[0];
        boolean isEnable = false;

        String manufacturer = "xdja";
        //xdja的卡
        if (chipParam.manufacturer.equals(manufacturer)){
            int pinTryCount = beanPair.second.result[1];
            if (pinTryCount == 10){
                isEnable = true;
            }else if (pinTryCount == 5 && role == 0x01) {
                isEnable = true;
            }
        }else{//其他公司的卡

            isEnable = beanPair.second.result[1] == beanPair.second.result[0];
        }
        return Pair.create(0,isEnable);
    }

    /**
     * 根据卡号获取卡内第一个应用的句柄
     *
     * @param context
     * @param cardId
     * @return
     */
    private static Pair<Integer, Long> getFirstApplicationHandle(Context context, String cardId) {
        Pair<Integer, SuperChip> pair = getChipBinderByCardId(context, cardId);
        if (pair.first != 0) {
            return Pair.create(-1, null);
        }
        Pair<Integer, byte[]> bytePair = pair.second.EnumApplication();
        if (bytePair.first != 0) {
            return Pair.create(bytePair.first, null);
        }
        Pair<Integer, Long> longPair = pair.second.OpenApplication(bytePair.second);
        if (longPair.first != 0) {
            return Pair.create(longPair.first, null);
        }
        return Pair.create(0, longPair.second);
    }
}
