package com.xdja.multichip.jar;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by xwy on 2017/6/12.
 */

public class KeyBroadcastReceiver extends BroadcastReceiver {

    private static final String TF_MOUNTED = "com_xdja_safekeyservice_tf_mounted";
    private final static String TF_REMOVE = "com_xdja_safekeyservice_tf_removed";

    private static String[] receviers = {TF_MOUNTED, TF_MOUNTED};

    List<MultiChipListener.KeyChangeListener> listeners = new ArrayList<>();

    void registerKeyReceiver(Context context, MultiChipListener.KeyChangeListener changeListener) {
        if (context != null || changeListener != null) {
            if (!listeners.contains(changeListener)) {
                listeners.add(changeListener);
            }
        }
    }

    void unregisterKeyReceiver(Context context, MultiChipListener.KeyChangeListener changeListener) {
        if (context != null || changeListener != null) {
            if (listeners.contains(changeListener)) {
                listeners.remove(changeListener);
            }
        }
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        String key = intent.getAction();
        if (TF_MOUNTED.equals(key)) {
            for (MultiChipListener.KeyChangeListener listener : listeners) {
                if (listener instanceof MultiChipListener.TFListener) {
                    ((MultiChipListener.TFListener) listener).mountTF();
                }
            }

        } else if (TF_REMOVE.equals(key)) {
            for (MultiChipListener.KeyChangeListener listener : listeners) {
                if (listener instanceof MultiChipListener.TFListener) {
                    ((MultiChipListener.TFListener) listener).removeTF();
                }
            }
        }
    }

    private static KeyBroadcastReceiver broadcastReceiver = null;

    static KeyBroadcastReceiver getInstance(Context context) {
        if (broadcastReceiver == null) {
            synchronized (KeyBroadcastReceiver.class) {
                if (broadcastReceiver == null) {
                    broadcastReceiver = new KeyBroadcastReceiver();
                    Context context1 = context.getApplicationContext();
                    if (context1 == null) {
                        context1 = context;
                    }
                    IntentFilter intentFilter = new IntentFilter();
                    for (String receiver : receviers) {
                        intentFilter.addAction(receiver);
                    }
                    context1.registerReceiver(broadcastReceiver, intentFilter);
                }
            }
        }
        return broadcastReceiver;
    }
}
