package com.xdja.multichip.param;

import android.os.Parcel;
import android.os.Parcelable;


/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/5/26 <br/>
 */

public class ChipParam implements Parcelable {
    /**
     * 芯片
     */
    public static final int TYPE_ONBOARD = 1;
    /**
     * TF卡类型
     */
    public static final int TYPE_TF = 2;

    /**
     * 蓝牙Key
     */
    public static final int TYPE_BLUETOOTH = 4;

    /**
     * 芯片所属厂商 -- 信大捷安
     */
    public static final String MANUFACTURER_XDJA = "xdja";

    /**
     * 类型
     */
    public int chipType;
    /**
     * 芯片的唯一标识
     */
    public String uniqueID;

    /**
     * 哪个公司的芯片
     */
    public String manufacturer;

    public ChipParam() {

    }

    protected ChipParam(Parcel in) {
        chipType = in.readInt();
        uniqueID = in.readString();
        manufacturer = in.readString();
    }

    public static final Creator<ChipParam> CREATOR = new Creator<ChipParam>() {
        @Override
        public ChipParam createFromParcel(Parcel in) {
            return new ChipParam(in);
        }

        @Override
        public ChipParam[] newArray(int size) {
            return new ChipParam[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(chipType);
        parcel.writeString(uniqueID);
        parcel.writeString(manufacturer);
    }
}
