/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.jniapi;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Pair;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_DIR;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_KEY_ATTR;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.multichip.IMultiJniApi;
import com.xdja.multichip.jniapi.Arithmetic;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import java.security.cert.X509Certificate;

public class JarJniApiProxy {
    private Context context;
    protected IMultiJniApi binder;
    private String cardId;
    private long handle = 0L;
    protected int cardType;
    Handler handler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 1) {
                JarJniApiProxy.this.cardId = new String(((XDJA_DEVINFO)msg.obj).cardid);
            }
        }
    };

    protected JarJniApiProxy(Context context, IMultiJniApi binder, int cardType) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
        this.binder = binder;
        this.cardType = cardType;
    }

    public JarJniApiProxy(Context context, IMultiJniApi binder, String cardId, int cardType) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
        this.binder = binder;
        this.cardId = cardId;
        this.cardType = cardType;
        this.binderDeathLink();
    }

    public Pair<Integer, String> getCardId() {
        XDJA_DEVINFO devInfo = new XDJA_DEVINFO();
        int ret = this.GetDevInfo(devInfo);
        if (ret == 0) {
            String cardId = new String(devInfo.cardid, 0, 32);
            return Pair.create((Object)ret, (Object)cardId);
        }
        return Pair.create((Object)ret, (Object)"");
    }

    public int getCardType() {
        return this.cardType;
    }

    public Pair<Integer, String> getSn(int containNo, int certType) {
        int ret = 0;
        if (certType == 1) {
            certType = 2;
        } else if (certType == 2) {
            certType = 5;
        } else {
            return Pair.create((Object)-10000, (Object)"");
        }
        byte[] certId = Arithmetic.convertToFid(containNo, certType);
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[2];
        ret = this.ReadCert(certId, certBuf, certLen);
        if (ret != 0) {
            return Pair.create((Object)ret, (Object)"");
        }
        X509Certificate x509Cert = Arithmetic.getX509Certificate(certBuf, certLen[0]);
        if (x509Cert == null) {
            return Pair.create((Object)-10004, (Object)"");
        }
        byte[] certSn = x509Cert.getSerialNumber().toByteArray();
        System.arraycopy(certSn, 0, certBuf, 0, certSn.length);
        certLen[0] = certSn.length;
        String stringCertSn = "";
        for (int i = 0; i < certLen[0]; ++i) {
            stringCertSn = stringCertSn + String.format("%02x", certBuf[i]);
        }
        return Pair.create((Object)ret, (Object)stringCertSn);
    }

    public int GetVersion(byte[] verion, int[] ver_len) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.GetVersion(verion, ver_len);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int LockDev() {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.LockDev(this.handle);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int UnlockDev() {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.UnlockDev(this.handle);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int CloseDev() {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.CloseDev(this.handle);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int Transmit(byte[] cmd, int cmdLen, byte[] dataOut, int[] outLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.Transmit(this.handle, cmd, cmdLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int GetDevInfo(XDJA_DEVINFO devInfo) {
        if (devInfo == null) {
            return -10000;
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.GetDevInfo(this.handle, devInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int ActivateCard(byte[] param, int paramLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.ActivateCard(this.handle, param, paramLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int GetActivateState() {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.GetActivateState(this.handle);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int ChangePIN(int pinRole, byte[] oldPin, int oldLen, byte[] newPin, int newLen) {
        if (oldPin == null || oldPin.length < oldLen || newPin == null || newPin.length < newLen) {
            return -10000;
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.ChangePIN(this.handle, pinRole, oldPin, oldLen, newPin, newLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int GetPinTryCount(int pinRole) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.GetPinTryCount(this.handle, pinRole);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int VerifyPIN(int pinRole, byte[] pin, int pinLen) {
        if (pin == null || pin.length < pinLen) {
            return -10000;
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.VerifyPIN(this.handle, pinRole, pin, pinLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int UnlockPIN(int id, byte[] key, int keyLen, byte[] newPin, int newLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.UnlockPIN(this.handle, id, key, keyLen, newPin, newLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int ReloadPIN(int pinRole, byte[] key, int keyLen, byte[] newPin, int newLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.ReloadPIN(this.handle, pinRole, key, keyLen, newPin, newLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int CardReset() {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.CardReset(this.handle);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int CreateDir(XDJA_DIR dir) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.CreateDir(this.handle, dir);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SelectFile(byte[] fid) {
        if (fid == null) {
            return -10000;
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SelectFile(this.handle, fid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int GetDirSize(int[] size) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.GetDirSize(this.handle, size);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int DeleteFile(byte[] fid) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.DeleteFile(this.handle, fid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int CreateFile(XDJA_FILE file) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.CreateFile(this.handle, file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int GetFileInfo(byte[] fid, XDJA_FILE file) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.GetFileInfo(this.handle, fid, file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int ReadFile(byte[] fid, int readPos, int readLen, byte[] dataOut) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.ReadFile(this.handle, fid, readPos, readLen, dataOut);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int WriteFile(byte[] fid, int writePos, int writeLen, byte[] dataIn) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.WriteFile(this.handle, fid, writePos, writeLen, dataIn);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int ReadRsaPubKey(byte[] pubfid, XDJA_RSA_PUBKEY pubKey) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.ReadRsaPubKey(this.handle, pubfid, pubKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int WriteRsaPubKey(byte[] pubfid, XDJA_RSA_PUBKEY pubKey) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.WriteRsaPubKey(this.handle, pubfid, pubKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int WriteRsaPriKey(byte[] prifid, XDJA_RSA_PRIKEY priKey) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.WriteRsaPriKey(this.handle, prifid, priKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int ReadSm2PubKey(byte[] pubfid, XDJA_SM2_PUBKEY pubKey) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.ReadSm2PubKey(this.handle, pubfid, pubKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int WriteSm2PubKey(byte[] pubfid, XDJA_SM2_PUBKEY pubKey) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.WriteSm2PubKey(this.handle, pubfid, pubKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int WriteSm2PriKey(byte[] prifid, XDJA_SM2_PRIKEY priKey) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.WriteSm2PriKey(this.handle, prifid, priKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int ReadCert(byte[] fid, byte[] certBuf, int[] certLen) {
        if (fid == null || certBuf == null || certBuf.length < 2048) {
            return -10000;
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.ReadCert(this.handle, fid, certBuf, certLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int WriteCert(byte[] fid, byte[] certBuf, int certLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.WriteCert(this.handle, fid, certBuf, certLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int GenRandom(int len, byte[] random) {
        if (random == null) {
            return -10000;
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.GenRandom(this.handle, len, random);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int DESKEY(byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            if (IV == null) {
                IV = new byte[]{};
            }
            return this.binder.DESKEY(this.handle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int DES3KEY(byte[] tmpKey, int tmpkeyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            if (IV == null) {
                IV = new byte[]{};
            }
            return this.binder.DES3KEY(this.handle, tmpKey, tmpkeyLen, dataIn, inLen, flag, dataOut, IV);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int AESKEY(byte[] tmpKey, int keyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            if (IV == null) {
                IV = new byte[]{};
            }
            return this.binder.AESKEY(this.handle, tmpKey, keyLen, dataIn, inLen, flag, dataOut, IV);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int CreateKey(XDJA_KEY_ATTR keyAttr) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.CreateKey(this.handle, keyAttr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int ImportKey(int type, byte[] dataIn, byte kID) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.ImportKey(this.handle, type, dataIn, kID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM1(byte[] dataIn, int inLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        if (dataIn == null || dataIn.length < inLen || dataOut == null || dataOut.length < inLen) {
            return -10000;
        }
        if (!(flag != 16 && flag != 17 && flag != 16 || IV != null && IV.length == 16)) {
            return -10000;
        }
        if (IV == null) {
            IV = new byte[]{};
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SM1(this.handle, dataIn, inLen, flag, dataOut, kID, IV);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int ImportTmpKey(byte[] tmpKey) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.ImportTmpKey(this.handle, tmpKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int TmpSM1(byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            if (IV == null) {
                IV = new byte[]{};
            }
            return this.binder.TmpSM1(this.handle, dataIn, inLen, flag, dataOut, IV);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM1KEY(byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        if (dataIn == null || dataIn.length < inLen || dataOut == null || dataOut.length < inLen) {
            return -10000;
        }
        if (!(flag != 16 && flag != 17 && flag != 16 || IV != null && IV.length == 16)) {
            return -10000;
        }
        if (IV == null) {
            IV = new byte[]{};
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SM1KEY(this.handle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SSF33(byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            if (IV == null) {
                IV = new byte[]{};
            }
            return this.binder.SSF33(this.handle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM4KEY(byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            if (IV == null) {
                IV = new byte[]{};
            }
            return this.binder.SM4KEY(this.handle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM4KEYEx(byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            if (IV == null) {
                IV = new byte[]{};
            }
            return this.binder.SM4KEYEx(this.handle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM6KEY(byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            if (IV == null) {
                IV = new byte[]{};
            }
            return this.binder.SM6KEY(this.handle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int GenRSAKeyPair(int bits, byte[] pubfid, byte[] prifid, XDJA_RSA_PUBKEY pubkey, XDJA_RSA_PRIKEY prikey) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.GenRSAKeyPair(this.handle, bits, pubfid, prifid, pubkey, prikey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int RSAPubKeyCalc(byte[] pubfid, XDJA_RSA_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        if (pubfid == null || dataIn == null || dataIn.length < inLen || dataOut == null || outLen == null) {
            return -10000;
        }
        if (pubfid[0] == 0 && pubfid[1] == 0) {
            if (pubkey == null) {
                return -10000;
            }
        } else if (pubkey == null) {
            pubkey = new XDJA_RSA_PUBKEY();
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.RSAPubKeyCalc(this.handle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int RSAPriKeyCalc(byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        if (prifid == null || dataIn == null || dataIn.length < inLen || dataOut == null || outLen == null) {
            return -10000;
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.RSAPriKeyCalc(this.handle, prifid, dataIn, inLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int RSAPriKeyCalcEx(byte[] pin, int pinLen, int pinRole, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.RSAPriKeyCalcEx(this.handle, pin, pinLen, pinRole, prifid, dataIn, inLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int RSASign(int bits, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.RSASign(this.handle, bits, prifid, dataType, dataIn, inLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int RSASignVerify(int bits, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int dataType, byte[] dataIn, int inLen, byte[] signatureData) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.RSASignVerify(this.handle, bits, pubfid, pubkey, dataType, dataIn, inLen, signatureData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int PackEnvelope(byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int alg, byte[] dataOut, int[] outLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.PackEnvelope(this.handle, pubfid, pubkey, alg, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int UnpackEnvelope(byte[] prifid, int alg, byte[] dataIn, int inLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.UnpackEnvelope(this.handle, prifid, alg, dataIn, inLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int KeyDisperse(int keyId, byte[] keyParam, int keyParamLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.KeyDisperse(this.handle, keyId, keyParam, keyParamLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SetSM2Id(byte[] sm2Id, int inLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SetSM2Id(this.handle, sm2Id, inLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int GetSM2Id(byte[] sm2Id, int[] outLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.GetSM2Id(this.handle, sm2Id, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SetSM2Param(XDJA_SM2_PARAM param) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SetSM2Param(this.handle, param);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int GetSM2Param(XDJA_SM2_PARAM param) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.GetSM2Param(this.handle, param);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int GenSM2KeyPair(byte[] pubfid, byte[] prifid, XDJA_SM2_PUBKEY pubkey, XDJA_SM2_PRIKEY prikey) {
        if (pubfid[0] == 0 && pubfid[1] == 0) {
            if (pubkey == null) {
                return -10000;
            }
        } else if (pubkey == null) {
            pubkey = new XDJA_SM2_PUBKEY();
        }
        if (prifid[0] == 0 && prifid[1] == 0) {
            if (prikey == null) {
                return -10000;
            }
        } else if (prikey == null) {
            prikey = new XDJA_SM2_PRIKEY();
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.GenSM2KeyPair(this.handle, pubfid, prifid, pubkey, prikey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM2Encrypt(byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        if (pubfid == null || dataIn == null || dataIn.length < inLen || inLen > 155 || dataOut == null || dataOut.length < inLen + 97 || outLen == null) {
            return -10000;
        }
        if (pubfid[0] == 0 && pubfid[1] == 0) {
            if (pubkey == null) {
                return -10000;
            }
        } else if (pubkey == null) {
            pubkey = new XDJA_SM2_PUBKEY();
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SM2Encrypt(this.handle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM2EncryptGM(byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SM2EncryptGM(this.handle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM2Decrypt(byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SM2Decrypt(this.handle, prifid, dataIn, inLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM2DecryptGM(byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SM2DecryptGM(this.handle, prifid, dataIn, inLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM2Sign(byte[] pubfid, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        if (dataType == 1 && pubfid == null) {
            return -10000;
        }
        if (pubfid == null) {
            pubfid = new byte[]{};
        }
        if (prifid == null || dataIn == null || dataIn.length < inLen || dataOut == null || dataOut.length < 64 || outLen == null) {
            return -10000;
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SM2Sign(this.handle, pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM2SignVerify(byte[] pubfid, int dataType, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) {
        if (pubfid == null || dataIn == null || dataIn.length < inLen || signatureData == null) {
            return -10000;
        }
        if (pubfid[0] == 0 && pubfid[1] == 0) {
            if (pubkey == null) {
                return -10000;
            }
        } else if (pubkey == null) {
            pubkey = new XDJA_SM2_PUBKEY();
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SM2SignVerify(this.handle, pubfid, dataType, pubkey, dataIn, inLen, signatureData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SHA1(byte[] dataIn, int inLen, byte[] dataOut) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SHA1(this.handle, dataIn, inLen, dataOut);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM3(byte[] dataIn, int inLen, byte[] dataOut) {
        if (dataIn == null || dataIn.length < inLen || dataOut == null || dataOut.length < 32) {
            return -10000;
        }
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SM3(this.handle, dataIn, inLen, dataOut);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM2KeyGenInit(byte[] pubfid, byte[] dataOut, int[] outLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SM2KeyGenInit(this.handle, pubfid, dataOut, outLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM2KeyGenCompute(byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, byte dictFlag, byte keyFlag) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SM2KeyGenCompute(this.handle, pubfid, prifid, dataIn, inLen, dataOut, outLen, dictFlag, keyFlag);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int SM2KeyGenVerify(byte[] dataIn, int inLen) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.SM2KeyGenVerify(this.handle, dataIn, inLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public int ActivateCardByURL(String url) {
        try {
            if (this.getBinder() == null) {
                return -97;
            }
            return this.binder.ActivateCardByURL(this.handle, url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.handleException(e);
        }
    }

    public Bundle callMethod(Bundle bundle) {
        try {
            if (this.getBinder() == null) {
                Bundle result = new Bundle();
                result.putInt("ret", -97);
                return result;
            }
            return this.binder.callMethod(bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
            Bundle result = new Bundle();
            result.putInt("ret", -10001);
            return result;
        }
    }

    private int handleException(Exception e) {
        e.printStackTrace();
        return -10001;
    }

    protected IMultiJniApi getBinder() {
        Pair<Integer, JarJniApiProxy> pair;
        if (this.binder == null && (pair = JarMultiJniApiManager.getInstance().make(this.context, this.cardId)) != null && (Integer)pair.first == 0) {
            this.binder = ((JarJniApiProxy)pair.second).binder;
            this.binderDeathLink();
        }
        return this.binder;
    }

    private void binderDeathLink() {
        try {
            this.binder.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                public void binderDied() {
                    JarJniApiProxy.this.binder = null;
                }
            }, 1);
            Messenger messenger = new Messenger(this.handler);
            Bundle bundle = new Bundle();
            bundle.putString("method", "SetCardChangeListener");
            bundle.putBinder("Binder", messenger.getBinder());
            this.binder.callMethod(bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

