package com.xdja.multichip;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.widget.Toast;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/1/24 <br/>
 */
public class Utils {
    private static Context context = null;

    public static void init(Context context) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Utils.context = context.getApplicationContext();
        if (Utils.context == null) {
            Utils.context = context;
        }

    }

    public static Context getContext() {
        return context;
    }

    public static void toast(String msg) {
        Message message = Message.obtain();
        message.what = CODE_SHOW_TOAST;
        message.obj = msg;
        getHandler().sendMessage(message);
    }

    private synchronized static Handler getHandler() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper()) {
                @Override
                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    if (msg.what == CODE_SHOW_TOAST) {
                        Toast.makeText(getContext(), (String) msg.obj, Toast.LENGTH_LONG).show();
                    }
                }
            };
        }
        return handler;
    }
    public static String Byte2Str(byte[] arr, int pos, int len) {
        StringBuilder builder = new StringBuilder("");

        for (int i = pos; i < pos + len; ++i) {
            builder.append(String.format("%02X", arr[i]));
        }

        return builder.toString();
    }

    public static String Byte2Str(byte[] arr, int len) {
        return Byte2Str(arr, 0, len);
    }
    public static byte[] Str2Byte(String data) {
        int size = data.length() / 2;
        byte[] arr = new byte[size];
        Str2Byte(data, arr, (int[]) null);
        return arr;
    }
    public static void Str2Byte(String data, byte[] arr, int[] len) {
        int i;
        for (i = 0; i < arr.length && 2 * (i + 1) <= data.length(); ++i) {
            arr[i] = (byte) Integer.parseInt(data.substring(i * 2, 2 * (i + 1)), 16);
        }

        if (len != null) {
            len[0] = i;
        }

    }

    private static final int CODE_SHOW_TOAST = 1;
    private static Handler handler = null;
}
