package com.xdja.multichip.jniapi;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;

import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;

/**
 * Created by hyh on 2020/11/13
 */
public class JarMultiJniApiBoardManager {
    private static final String TAG = "BoardManager";

    private JarMultiJniApiBoardManager() {

    }

    public static JarMultiJniApiBoardManager getInstance() {
        return JarMultiJniApiBoardManagerHolder.HOLDER;
    }

    private static class JarMultiJniApiBoardManagerHolder {
        private static final JarMultiJniApiBoardManager HOLDER = new JarMultiJniApiBoardManager();
    }

    /**
     * SpiConfig函数是6线SPI类型时需要，即枚举时devType=CT_XDJA_SPI6（0x218）时必须调用。
     *
     * @return
     */
    public int spiConfig(Context context, int int0, int int1, int por, int power, int qwk, int speed) {
        IGetMultiJniApi getMultiJniApiBinder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (getMultiJniApiBinder != null) {
            Bundle bundle = new Bundle();
            bundle.putString(ParamKeywords.KEY_String_method, ParamKeywords.KEY_METHOD_SPICONFIG);
            bundle.putInt(ParamKeywords.SPICONFIG_SUPPORT_CHIPTYPE, JniApiParam.TYPE_ONBOARD);
            bundle.putInt(ParamKeywords.SPICONFIG_INT0, int0);
            bundle.putInt(ParamKeywords.SPICONFIG_INT1, int1);
            bundle.putInt(ParamKeywords.SPICONFIG_POR, por);
            bundle.putInt(ParamKeywords.SPICONFIG_POWER, power);
            bundle.putInt(ParamKeywords.SPICONFIG_QWK, qwk);
            bundle.putInt(ParamKeywords.SPICONFIG_SPEED, speed);
            try {
                Bundle result = getMultiJniApiBinder.callMethod(bundle);
                if (result == null) {
                    Log.e(TAG, "spi config result bundle is empty");
                    return JarMultiJniApiErrorCode.RET_EXCEPTION;
                }
                return result.getInt(ParamKeywords.KEY_SPICONFIG_RET);
            } catch (Exception e) {
                e.printStackTrace();
                Log.e(TAG, "spi config exception "+e.getMessage());
            }
        }
        return JarMultiJniApiErrorCode.RET_GET_BINDER_FAIL;
    }
}
