package com.xdja.multichip.jniapi;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.Utils;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;

/**
 * author: xwy<br/>
 * date:   2017/9/21 <br/>
 */

public class JarMultiJniApiCCManager {
    private static JarMultiJniApiCCManager instance;

    private JarMultiJniApiCCManager() {
    }

    public static JarMultiJniApiCCManager getInstance() {
        if (instance == null) {
            synchronized (JarMultiJniApiCCManager.class) {
                if (instance == null) {
                    instance = new JarMultiJniApiCCManager();
                }
            }
        }
        return instance;
    }
    /**
     * 贴膜卡SM4,目前接口不支持CBC模式
     *
     * @param context
     * @param dataIn  要加密或解密的数据（填充过的且长度是16的倍数）
     * @param flag    加密模式
     * @param kID     加密用0x08，解密用0x09
     * @param IV      初始向量，当CBC_MODE时需要
     * @return
     */
    public int SM4(Context context, byte[] dataIn, int dataLen, int flag, byte[] dataOut,
                   byte kID, byte[] IV) {
        final Pair<Integer, JarJniApiProxy> make = JarMultiJniApiManager.getInstance().make(context, JniApiParam.TYPE_COVERED);
        if (make.first != 0 || make.second == null) {
            Log.e("JarCC", "cc make fail ret=" + make.first);
            return make.first;
        }
        JarJniApiProxy proxy = make.second;
        return SM4(proxy, dataIn, dataLen, flag, dataOut, kID, IV);
    }
    /**
     * 贴膜卡SM4,目前接口不支持CBC模式
     *
     * @param proxy
     * @param dataIn 要加密或解密的数据（填充过的且长度是16的倍数）
     * @param flag   加密模式
     * @param kID    加密用0x08，解密用0x09
     * @param IV     初始向量，当CBC_MODE时需要
     * @return
     */
    public int SM4(JarJniApiProxy proxy, byte[] dataIn, int dataLen, int flag, byte[] dataOut,
                   byte kID, byte[] IV) {
        if (proxy == null || dataIn == null || dataIn.length < dataLen || dataOut == null ||
                dataOut.length < dataLen) {
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }
        if (IV != null && IV.length != 16) {
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }

        Bundle extras = new Bundle();
        extras.putString(ParamKeywords.KEY_String_method, ParamKeywords.KEY_METHOD_SM4);
        extras.putByteArray(ParamKeywords.KEY_byteArray_dataIn, dataIn);
        extras.putInt(ParamKeywords.KEY_int_dataLen, dataLen);
        extras.putInt(ParamKeywords.KEY_int_flag, flag);
        extras.putByte(ParamKeywords.KEY_byte_kID, kID);
        extras.putByteArray(ParamKeywords.KEY_byteArray_IV, IV);

        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }
        int ret = bundle.getInt(ParamKeywords.KEY_int_ret);
        byte[] dataOutTmp = null;
        if (ret == JNIAPI.XKR_OK) {
            dataOutTmp = bundle.getByteArray(ParamKeywords.KEY_byteArray_dataOut);
            System.arraycopy(dataOutTmp, 0, dataOut, 0, dataOutTmp.length);
            byte[] IVTmp = bundle.getByteArray(ParamKeywords.KEY_byteArray_IV);
            if (IVTmp != null && IV != null) {
                System.arraycopy(IVTmp, 0, IV, 0, IVTmp.length);
            }
        }
        return ret;
    }

    /**
     * 设置日志打印
     *
     * @param printLogFlag      是否打印log的标志
     * @param isPersistenceFlag 是否printLogFlag持久化的标志
     */
    public int setLogFlag(Context context, boolean printLogFlag, boolean isPersistenceFlag) {
        if (context == null) {
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }
        IGetMultiJniApi binder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (binder == null) {
            return JarMultiJniApiErrorCode.RET_GET_BINDER_FAIL;
        }
        Bundle bundle = new Bundle();
        bundle.putString(ParamKeywords.KEY_String_method, ParamKeywords.KEY_METHOD_CcSetLogFlag);
        bundle.putBoolean(ParamKeywords.KEY_boolean_flag, printLogFlag);
        bundle.putBoolean(ParamKeywords.KEY_boolean_isPersistence, isPersistenceFlag);
        try {
            Bundle result = binder.callMethod(bundle);
            if (result == null) {
                return JarMultiJniApiErrorCode.NO_SUCH_METHOD;
            }
            return result.getInt(ParamKeywords.KEY_int_ret);
        } catch (RemoteException e) {
            e.printStackTrace();
            return JarMultiJniApiErrorCode.RET_EXCEPTION;
        }
    }

    /**
     * 写入签名SHA1值，仅支持V1卡
     *
     * @param hashArrays 大小只能小于或者等于3
     * @return
     */
    public int WriteSHA1(Context context, String[] hashArrays) {
        int ret = -1;
        String hash0 = "4216CEC0D2C5F0C29D23C4F832242E639D5846A8";// 正式
        String hash = "";// 签名1

        if (hashArrays.length == 0 || hashArrays.length > 3) {
            Log.e("JarCC", "hashArrays is empty length than 3");
            return -1;
        }
        boolean isError = false;

        for (int i = 0; i < hashArrays.length; i++) {
            if (!TextUtils.isEmpty(hashArrays[i]) && hashArrays[i].length() == 40) {
                hash = hash + hashArrays[i];// 签名
            } else {
                isError = true;
                break;
            }
        }
        if (isError) {
            Log.e("JarCC", "hashArrays is error ");
            return -1;
        }

        byte[] dataOut = new byte[128];
        int[] len = new int[2];

        String cmd1 = "B01C0000";
        String cmd2 = hash0 + hash + "000000000000000000000000";
        int datalen = cmd2.length() / 2;
        byte[] lens = new byte[]{(byte) datalen};
        String lenHexStr = Utils.Byte2Str(lens, lens.length);
        String cmds = cmd1 + lenHexStr + cmd2;
        byte[] apduByte = Utils.Str2Byte(cmds);
        final Pair<Integer, JarJniApiProxy> make = JarMultiJniApiManager.getInstance().make(context, JniApiParam.TYPE_COVERED);
        if (make.first != 0 || make.second == null) {
            Log.e("JarCC", "cc make fail ret="+make.first);
            return make.first;
        }
        ret = make.second.Transmit(apduByte, apduByte.length, dataOut, len);// 发送指令
        return ret;
    }


}
