package com.xdja.multichip.jniapi;

import android.content.ComponentName;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;

import com.xdja.multichip.IRelateStart;
import com.xdja.multichip.param.ParamKeywords;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/3/31 <br/>
 */
public class RelateStart extends IRelateStart.Stub {


    /**
     * 目标应用没有安装
     */
    public static final int RET_PKG_NOT_INSTALL = -1;

    /**
     * 不能关联启动，也没有发现有目标Activity
     */
    public static final int RET_ACTIVITY_NOT_FIND = -2;

    /**
     * 异常
     */
    public static final int RET_EXCEPTION = -3;

    static final String RELATE_START_ACTIVITY_NAME = "com.xdja.multichip.process.RelateStartActivity";

    private RelateStart() {
    }

    /**
     * @param context
     * @param pkgName
     * @param uri
     * @return
     */
    public static int confirm(final Context context,
                              final String pkgName,
                              final Uri uri) {
        RelateStart relateStart = new RelateStart();
        return relateStart.confirmPri(context, pkgName, uri);
    }

    CountDownLatch latch = new CountDownLatch(1);

    private int confirmPri(final Context context,
                           final String pkgName,
                           final Uri uri) {
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(pkgName, PackageManager.GET_ACTIVITIES);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return RET_PKG_NOT_INSTALL;
        }

        ContentResolver contentResolver = context.getContentResolver();
        ContentProviderClient client = contentResolver.acquireContentProviderClient(uri);
        if (client != null) {
            client.release();
            try {
                client.getClass().getMethod("close");
                client.close();
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            return 0;
        }

        String activityName = RELATE_START_ACTIVITY_NAME;
        try {
            ComponentName cn = new ComponentName(pkgName, activityName);
            pm.getActivityInfo(cn, PackageManager.GET_META_DATA);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return RET_ACTIVITY_NOT_FIND;
        }

        Bundle bundle = new Bundle();
        bundle.putBinder(ParamKeywords.KEY_Binder_Binder, this);

        final Intent intent = new Intent();
        intent.setClassName(pkgName, activityName);
        intent.putExtra(ParamKeywords.KEY_String_stop, "stop");
        intent.putExtra(ParamKeywords.KEY_Bundle_bundle, bundle);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
        try {
            boolean await = latch.await(1500, TimeUnit.MILLISECONDS);
            if (await) {
                return 0;
            }
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        return RET_EXCEPTION;
    }

    @Override
    public void callback(String msg) {
        latch.countDown();
    }
}
