package com.xdja.multichip.param;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @Author: hyh
 * @CreateDate: 2023/10/18
 * @Describe:
 */
public class VhsmInitParam implements Parcelable {
    public int state;
    public int initType;
    public byte[] name = new byte[32];
    public byte[] phone = new byte[32];
    public byte[] dept = new byte[256];
    public byte[] signature = new byte[64];
    public byte[] certSN = new byte[64];

    public VhsmInitParam() {

    }

    protected VhsmInitParam(Parcel in) {
        state = in.readInt();
        initType = in.readInt();
        name = in.createByteArray();
        phone = in.createByteArray();
        dept = in.createByteArray();
        signature = in.createByteArray();
        certSN = in.createByteArray();
    }

    public static final Creator<VhsmInitParam> CREATOR = new Creator<VhsmInitParam>() {
        @Override
        public VhsmInitParam createFromParcel(Parcel in) {
            return new VhsmInitParam(in);
        }

        @Override
        public VhsmInitParam[] newArray(int size) {
            return new VhsmInitParam[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(state);
        parcel.writeInt(initType);
        parcel.writeByteArray(name);
        parcel.writeByteArray(phone);
        parcel.writeByteArray(dept);
        parcel.writeByteArray(signature);
        parcel.writeByteArray(certSN);
    }
}