/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.jniapi;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;

public class JarMultiJniApiBoardManager {
    private static final String TAG = "BoardManager";

    private JarMultiJniApiBoardManager() {
    }

    public static JarMultiJniApiBoardManager getInstance() {
        return JarMultiJniApiBoardManagerHolder.HOLDER;
    }

    public int spiConfig(Context context, int int0, int int1, int por, int power, int qwk, int speed) {
        IGetMultiJniApi getMultiJniApiBinder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (getMultiJniApiBinder != null) {
            Bundle bundle = new Bundle();
            bundle.putString("method", "SpiConfig");
            bundle.putInt("spiconfig_support_chiptype", 1);
            bundle.putInt("int0", int0);
            bundle.putInt("int1", int1);
            bundle.putInt("por", por);
            bundle.putInt("power", power);
            bundle.putInt("qwk", qwk);
            bundle.putInt("speed", speed);
            try {
                Bundle result = getMultiJniApiBinder.callMethod(bundle);
                if (result == null) {
                    Log.e((String)TAG, (String)"spi config result bundle is empty");
                    return -10001;
                }
                return result.getInt("spiconfig_ret");
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)("spi config exception " + e.getMessage()));
            }
        }
        return -10002;
    }

    private static class JarMultiJniApiBoardManagerHolder {
        private static final JarMultiJniApiBoardManager HOLDER = new JarMultiJniApiBoardManager();

        private JarMultiJniApiBoardManagerHolder() {
        }
    }
}

