/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.jniapi;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.Utils;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;

public class JarMultiJniApiCCManager {
    private static JarMultiJniApiCCManager instance;

    private JarMultiJniApiCCManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JarMultiJniApiCCManager getInstance() {
        if (instance != null) return instance;
        Class<JarMultiJniApiCCManager> clazz = JarMultiJniApiCCManager.class;
        synchronized (JarMultiJniApiCCManager.class) {
            if (instance != null) return instance;
            instance = new JarMultiJniApiCCManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int SM4(Context context, byte[] dataIn, int dataLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        Pair<Integer, JarJniApiProxy> make = JarMultiJniApiManager.getInstance().make(context, 8);
        if ((Integer)make.first != 0 || make.second == null) {
            Log.e((String)"JarCC", (String)("cc make fail ret=" + make.first));
            return (Integer)make.first;
        }
        JarJniApiProxy proxy = (JarJniApiProxy)make.second;
        return this.SM4(proxy, dataIn, dataLen, flag, dataOut, kID, IV);
    }

    public int SM4(JarJniApiProxy proxy, byte[] dataIn, int dataLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        if (proxy == null || dataIn == null || dataIn.length < dataLen || dataOut == null || dataOut.length < dataLen) {
            return -10000;
        }
        if (IV != null && IV.length != 16) {
            return -10000;
        }
        Bundle extras = new Bundle();
        extras.putString("method", "SM4");
        extras.putByteArray("dataIn", dataIn);
        extras.putInt("dataLen", dataLen);
        extras.putInt("flag", flag);
        extras.putByte("kID", kID);
        extras.putByteArray("IV", IV);
        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return -10000;
        }
        int ret = bundle.getInt("ret");
        byte[] dataOutTmp = null;
        if (ret == 0) {
            dataOutTmp = bundle.getByteArray("dataOut");
            System.arraycopy(dataOutTmp, 0, dataOut, 0, dataOutTmp.length);
            byte[] IVTmp = bundle.getByteArray("IV");
            if (IVTmp != null && IV != null) {
                System.arraycopy(IVTmp, 0, IV, 0, IVTmp.length);
            }
        }
        return ret;
    }

    public int setLogFlag(Context context, boolean printLogFlag, boolean isPersistenceFlag) {
        if (context == null) {
            return -10000;
        }
        IGetMultiJniApi binder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (binder == null) {
            return -10002;
        }
        Bundle bundle = new Bundle();
        bundle.putString("method", "CcSetLogFlag");
        bundle.putBoolean("flag", printLogFlag);
        bundle.putBoolean("isPersistence", isPersistenceFlag);
        try {
            Bundle result = binder.callMethod(bundle);
            if (result == null) {
                return -10027;
            }
            return result.getInt("ret");
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -10001;
        }
    }

    public int WriteSHA1(Context context, String[] hashArrays) {
        int ret = -1;
        String hash0 = "4216CEC0D2C5F0C29D23C4F832242E639D5846A8";
        String hash = "";
        if (hashArrays.length == 0 || hashArrays.length > 3) {
            Log.e((String)"JarCC", (String)"hashArrays is empty length than 3");
            return -1;
        }
        boolean isError = false;
        for (int i = 0; i < hashArrays.length; ++i) {
            if (TextUtils.isEmpty((CharSequence)hashArrays[i]) || hashArrays[i].length() != 40) {
                isError = true;
                break;
            }
            hash = hash + hashArrays[i];
        }
        if (isError) {
            Log.e((String)"JarCC", (String)"hashArrays is error ");
            return -1;
        }
        byte[] dataOut = new byte[128];
        int[] len = new int[2];
        String cmd1 = "B01C0000";
        String cmd2 = hash0 + hash + "000000000000000000000000";
        int datalen = cmd2.length() / 2;
        byte[] lens = new byte[]{(byte)datalen};
        String lenHexStr = Utils.Byte2Str(lens, lens.length);
        String cmds = cmd1 + lenHexStr + cmd2;
        byte[] apduByte = Utils.Str2Byte(cmds);
        Pair<Integer, JarJniApiProxy> make = JarMultiJniApiManager.getInstance().make(context, 8);
        if ((Integer)make.first != 0 || make.second == null) {
            Log.e((String)"JarCC", (String)("cc make fail ret=" + make.first));
            return (Integer)make.first;
        }
        ret = ((JarJniApiProxy)make.second).Transmit(apduByte, apduByte.length, dataOut, len);
        return ret;
    }
}

