/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.jniapi;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.jar.forcallprovider.ForCallProvider;
import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.IMultiJniApi;
import com.xdja.multichip.jniapi.CardTypeUtil;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarJniApiTypeProxy;
import com.xdja.multichip.jniapi.RelateStart;
import com.xdja.multichip.param.IResultCallback;
import com.xdja.multichip.param.JniApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JarMultiJniApiManager {
    private static final String TAG = "JarMultiJniApiManager";
    public static final int RET_OK = 0;
    private static JarMultiJniApiManager instance;
    private IGetMultiJniApi getMultiJniApiBinder = null;
    private HashMap<String, IBinder> cardIdBinderMap = new HashMap();
    private HashMap<IBinder, JarJniApiProxy> binderProxyMap = new HashMap();
    private HashMap<Integer, JarJniApiProxy> typeProxyMap = new HashMap();
    private HashMap<String, Integer> cardIdTypeMap = new HashMap();
    private HashMap<String, ProxyToDeathBean> proxyToDeathBeanMap = new HashMap();
    ArrayList<ProxyToDeathBean> linkToDeathBeans = new ArrayList();
    private HandlerThread asyncThread;

    private JarMultiJniApiManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JarMultiJniApiManager getInstance() {
        if (instance != null) return instance;
        Class<JarMultiJniApiManager> clazz = JarMultiJniApiManager.class;
        synchronized (JarMultiJniApiManager.class) {
            if (instance != null) return instance;
            instance = new JarMultiJniApiManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Pair<Integer, List<JniApiParam>> getAll(Context context) {
        if (context == null) {
            return Pair.create((Object)-10000, null);
        }
        IGetMultiJniApi multiBinder = this.getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            return Pair.create((Object)-10002, null);
        }
        boolean flagException = false;
        List<Bundle> result = null;
        for (int i = 0; i < 3; ++i) {
            try {
                result = multiBinder.getMultiJniApi();
                flagException = false;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                flagException = true;
                SystemClock.sleep((long)30L);
            }
            if (!flagException) break;
        }
        if (flagException) {
            return Pair.create((Object)-10001, null);
        }
        ArrayList<JniApiParam> list = new ArrayList<JniApiParam>();
        if (result == null || result.size() == 0) {
            return Pair.create((Object)0, list);
        }
        for (Bundle bundle : result) {
            bundle.setClassLoader(JniApiParam.class.getClassLoader());
            JniApiParam jniApiParam = (JniApiParam)bundle.getParcelable("JniApiParam");
            IBinder binder = bundle.getBinder("Binder");
            String cardId = jniApiParam.cardId.trim();
            this.cardIdBinderMap.put(cardId, binder);
            this.cardIdTypeMap.put(cardId, jniApiParam.chipType);
            CardTypeUtil.saveCardIdAndType(context, cardId, jniApiParam.chipType);
            this.binderLinkToDeath(binder, cardId, jniApiParam.chipType);
            list.add(jniApiParam);
        }
        return Pair.create((Object)0, list);
    }

    public void getAllAsync(final Context context, final IResultCallback callback) {
        if (callback == null) {
            return;
        }
        if (context == null) {
            callback.onEnd(-10000);
            return;
        }
        IGetMultiJniApi multiBinder = this.getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            callback.onEnd(-10002);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("method", "GetAllAsync");
        Messenger messenger = new Messenger(new Handler(this.getAsyncLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (msg == null) {
                    return;
                }
                if (msg.what == 1) {
                    Bundle result = (Bundle)msg.obj;
                    result.setClassLoader(JniApiParam.class.getClassLoader());
                    JniApiParam jniApiParam = (JniApiParam)result.getParcelable("JniApiParam");
                    IBinder binder = result.getBinder("Binder");
                    JarJniApiTypeProxy proxy = new JarJniApiTypeProxy(context, IMultiJniApi.Stub.asInterface(binder), jniApiParam.chipType);
                    callback.onResult(jniApiParam, proxy);
                } else if (msg.what == 2) {
                    callback.onEnd(0);
                }
            }
        });
        bundle.putBinder("Binder", messenger.getBinder());
        try {
            Bundle result = multiBinder.callMethod(bundle);
            int ret = result.getInt("ret");
            if (ret != 0) {
                callback.onEnd(ret);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            callback.onEnd(-10001);
        }
    }

    public Pair<Integer, JarJniApiProxy> make(Context context, int cardType) {
        if (context == null) {
            return Pair.create((Object)-10000, null);
        }
        if (cardType != 1 && cardType != 2 && cardType != 8 && cardType != 4 && cardType != 16 && cardType != 32) {
            return Pair.create((Object)-10000, null);
        }
        if (this.typeProxyMap.containsKey(cardType)) {
            return Pair.create((Object)0, (Object)this.typeProxyMap.get(cardType));
        }
        Bundle bundle = new Bundle();
        bundle.putString("method", "makeByType");
        bundle.putInt("cardType", cardType);
        IGetMultiJniApi multiBinder = this.getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            return Pair.create((Object)-10002, null);
        }
        try {
            Bundle result = multiBinder.callMethod(bundle);
            if (result != null) {
                int ret = result.getInt("ret");
                if (ret != 0) {
                    return Pair.create((Object)ret, null);
                }
                ArrayList bundleList = result.getParcelableArrayList("BundleList");
                if (bundleList == null || bundleList.size() == 0) {
                    return Pair.create((Object)-10003, null);
                }
                Bundle typeBundle = (Bundle)bundleList.get(0);
                typeBundle.setClassLoader(JniApiParam.class.getClassLoader());
                JniApiParam jniApiParam = (JniApiParam)typeBundle.getParcelable("JniApiParam");
                IBinder binder = typeBundle.getBinder("Binder");
                JarJniApiTypeProxy proxy = new JarJniApiTypeProxy(context, IMultiJniApi.Stub.asInterface(binder), jniApiParam.chipType);
                this.typeProxyMap.put(cardType, proxy);
                String cardId = jniApiParam.cardId.trim();
                this.cardIdBinderMap.put(cardId, binder);
                this.cardIdTypeMap.put(cardId, jniApiParam.chipType);
                CardTypeUtil.saveCardIdAndType(context, jniApiParam.cardId.trim(), jniApiParam.chipType);
                this.binderLinkToDeath(binder, cardId, cardType);
                return Pair.create((Object)0, (Object)proxy);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return Pair.create((Object)-10001, null);
    }

    public Pair<Integer, JarJniApiProxy> make(Context context, String cardId) {
        if (context == null || TextUtils.isEmpty((CharSequence)cardId)) {
            return Pair.create((Object)-10000, null);
        }
        IBinder binder = this.cardIdBinderMap.get(cardId = cardId.trim());
        if (binder == null) {
            int cardType = CardTypeUtil.getCardType(context, cardId);
            if (cardType == -1) {
                this.getAll(context);
            } else {
                this.make(context, cardType);
            }
            binder = this.cardIdBinderMap.get(cardId);
        }
        if (binder != null) {
            XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
            try {
                int ret = IMultiJniApi.Stub.asInterface(binder).GetDevInfo(0L, devinfo);
                if (ret == 0) {
                    String getCardId = new String(devinfo.cardid).trim();
                    if (cardId.equals(getCardId)) {
                        if (this.binderProxyMap.containsKey(binder)) {
                            return Pair.create((Object)0, (Object)this.binderProxyMap.get(binder));
                        }
                        int cardType = this.cardIdTypeMap.get(getCardId);
                        JarJniApiProxy jniApiJarProxy = new JarJniApiProxy(context, IMultiJniApi.Stub.asInterface(binder), getCardId, cardType);
                        this.binderProxyMap.put(binder, jniApiJarProxy);
                        return Pair.create((Object)0, (Object)jniApiJarProxy);
                    }
                    this.cardIdBinderMap.remove(cardId);
                    this.binderProxyMap.remove(binder);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return Pair.create((Object)-10001, null);
            }
            return Pair.create((Object)-10003, null);
        }
        return Pair.create((Object)-10002, null);
    }

    HashMap<String, IBinder> getCardIdBinderMap() {
        return this.cardIdBinderMap;
    }

    HashMap<IBinder, JarJniApiProxy> getBinderProxyMap() {
        return this.binderProxyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    IGetMultiJniApi getGetMultiJniApiBinder(Context context) {
        if (this.getMultiJniApiBinder != null) return this.getMultiJniApiBinder;
        Class<JarMultiJniApiManager> clazz = JarMultiJniApiManager.class;
        synchronized (JarMultiJniApiManager.class) {
            IBinder binder;
            int ret;
            if (this.getMultiJniApiBinder != null) return this.getMultiJniApiBinder;
            String callPkg = ForCallProvider.getCallPkg((Context)context);
            Log.d((String)TAG, (String)("call pkg " + callPkg));
            Uri uri = ForCallProvider.onlyGetProxyProviderUri((Context)context);
            int confirm = RelateStart.confirm(context, callPkg, uri);
            if (confirm != 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            String method = "GetBinder";
            String arg = "GetMultiJniApiBinder";
            ContentResolver resolver = context.getContentResolver();
            Bundle bundle = resolver.call(uri, method, arg, null);
            if (bundle == null || (ret = bundle.getInt("ret")) != 0 || (binder = bundle.getBinder("Binder")) == null) return this.getMultiJniApiBinder;
            this.getMultiJniApiBinder = IGetMultiJniApi.Stub.asInterface(binder);
            try {
                binder.linkToDeath(new IBinder.DeathRecipient(){

                    public void binderDied() {
                        JarMultiJniApiManager.this.getMultiJniApiBinder = null;
                    }
                }, 0);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return this.getMultiJniApiBinder;
        }
    }

    private void binderLinkToDeath(IBinder binder, String cardId, int cardType) {
        ProxyToDeathBean linkToDeathBean = this.obtain(binder, cardId, cardType);
        if (!this.linkToDeathBeans.contains(linkToDeathBean)) {
            this.linkToDeathBeans.add(linkToDeathBean);
        }
    }

    private ProxyToDeathBean obtain(IBinder binder, String cardId, int cardType) {
        String key = binder.toString() + cardId;
        if (this.proxyToDeathBeanMap.containsKey(key)) {
            return this.proxyToDeathBeanMap.get(key);
        }
        ProxyToDeathBean linkToDeathBean = new ProxyToDeathBean(binder, cardId, cardType);
        this.proxyToDeathBeanMap.put(key, linkToDeathBean);
        return linkToDeathBean;
    }

    private void remove(IBinder binder, String cardId, int cardType) {
        this.cardIdBinderMap.remove(cardId);
        this.typeProxyMap.remove(cardType);
        this.binderProxyMap.remove(binder);
        String key = binder.toString() + cardId;
        this.proxyToDeathBeanMap.remove(key);
    }

    private Looper getAsyncLooper() {
        return this.getAsyncThread().getLooper();
    }

    private synchronized HandlerThread getAsyncThread() {
        if (this.asyncThread == null) {
            this.asyncThread = new HandlerThread("Async");
            this.asyncThread.start();
        }
        return this.asyncThread;
    }

    class ProxyToDeathBean {
        IBinder binder;
        String cardId;
        int cardType;
        Messenger messenger;

        ProxyToDeathBean(final IBinder binder, final String cardId, final int cardType) {
            this.binder = binder;
            try {
                this.binder.linkToDeath(new IBinder.DeathRecipient(){

                    public void binderDied() {
                        JarMultiJniApiManager.this.remove(binder, cardId, cardType);
                        JarMultiJniApiManager.this.linkToDeathBeans.remove(ProxyToDeathBean.this);
                    }
                }, 0);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            this.cardId = cardId;
            this.cardType = cardType;
            this.messenger = new Messenger(new Handler(Looper.getMainLooper()){

                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    Log.d((String)"clientProxy", (String)("Client handleMessage what = " + msg.what));
                    if (msg.what == 1) {
                        JarMultiJniApiManager.this.remove(binder, cardId, cardType);
                        JarMultiJniApiManager.this.linkToDeathBeans.remove(ProxyToDeathBean.this);
                    }
                }
            });
            Bundle bundle = new Bundle();
            bundle.putString("method", "SendClientProxy");
            bundle.putBinder("messenger", this.messenger.getBinder());
            try {
                IMultiJniApi.Stub.asInterface(binder).callMethod(bundle);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface ConnectBluetoothKeyCallBack {
        public void callBack(int var1, JarJniApiProxy var2);
    }
}

