/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.jniapi;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.IMultiJniApi;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarJniApiTypeProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.VhsmInitParam;
import com.xdja.multichip.param.VhsmServerInfo;

public class JarMultiJniApiVhsmManager {
    private static JarMultiJniApiVhsmManager instance;
    private static final String TAG = "JarMultiJniApiVhsm";
    private static final String KEY_RET = "ret";

    private JarMultiJniApiVhsmManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JarMultiJniApiVhsmManager getInstance() {
        if (instance != null) return instance;
        Class<JarMultiJniApiVhsmManager> clazz = JarMultiJniApiVhsmManager.class;
        synchronized (JarMultiJniApiVhsmManager.class) {
            if (instance != null) return instance;
            instance = new JarMultiJniApiVhsmManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int setVhsmPriPath(Context context) {
        IGetMultiJniApi multiBinder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            return -10002;
        }
        Bundle bundle = new Bundle();
        bundle.putString("method", "SetvhsmCustomPath");
        bundle.putString("vhsmPath", "vhsmPriPath");
        try {
            Bundle result = multiBinder.callMethod(bundle);
            Log.e((String)TAG, (String)("set custom vhsm pri path result" + result));
            if (result == null) {
                return -10001;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int setVhsmCustomPath(Context context, String path) {
        IGetMultiJniApi multiBinder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            return -10002;
        }
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = "";
        }
        Bundle bundle = new Bundle();
        bundle.putString("method", "SetvhsmCustomPath");
        bundle.putString("vhsmPath", path);
        try {
            Bundle result = multiBinder.callMethod(bundle);
            Log.e((String)TAG, (String)("set custom vhsm path result" + result));
            if (result == null) {
                return -10001;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int initVhsm(Context context, int type, VhsmInitParam param) {
        IGetMultiJniApi multiBinder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            return -10002;
        }
        Bundle bundle = new Bundle();
        bundle.putString("method", "initVhsm");
        bundle.putInt("initVhsmType", type);
        bundle.putParcelable("initVhsmParam", (Parcelable)param);
        try {
            Bundle result = multiBinder.callMethod(bundle);
            Log.e((String)TAG, (String)("vhsm init callmethod=" + result));
            if (result == null) {
                return -10001;
            }
            int ret = result.getInt(KEY_RET);
            Log.e((String)TAG, (String)("vhsm init ret=" + ret));
            return ret;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int setVhsmServerInfo(Context context, VhsmServerInfo serverInfo) {
        IGetMultiJniApi multiBinder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            return -10002;
        }
        Bundle bundle = new Bundle();
        bundle.putString("method", "setServerInfo");
        bundle.putParcelable("serverInfo", (Parcelable)serverInfo);
        try {
            Bundle result = multiBinder.callMethod(bundle);
            Log.e((String)TAG, (String)("vhsm set server info  callMethod=" + result));
            if (result == null) {
                return -10001;
            }
            return result.getInt(KEY_RET);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -10001;
        }
    }

    public String getVhsmVirtuallyId(Context context) {
        IGetMultiJniApi multiBinder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            return "";
        }
        Bundle bundle = new Bundle();
        bundle.putString("method", "getVhsmVirtuallyId");
        try {
            Bundle result = multiBinder.callMethod(bundle);
            Log.e((String)TAG, (String)("vhsm getVhsmVirtuallyId  callMethod=" + result));
            if (result == null) {
                return "";
            }
            int ret = result.getInt(KEY_RET);
            if (ret != 0) {
                Log.e((String)TAG, (String)("vhsm getVhsmVirtuallyId  result=" + ret));
                return "";
            }
            return result.getString("cardId");
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public VhsmServerInfo getServerInfo(Context context) {
        Pair<Integer, JarJniApiProxy> make = JarMultiJniApiManager.getInstance().make(context, 32);
        if ((Integer)make.first != 0 || make.second == null) {
            Log.e((String)TAG, (String)("get vhsm  serverinfo: proxy is empty ret=" + make.first));
            return null;
        }
        JarJniApiProxy proxy = (JarJniApiProxy)make.second;
        Bundle extras = new Bundle();
        extras.putString("method", "getExistVhsmServerInfo");
        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return null;
        }
        int ret = bundle.getInt(KEY_RET);
        if (ret == 0) {
            Log.e((String)TAG, (String)("get vhsm server info success:serverType=" + bundle.getInt("serverType")));
            VhsmServerInfo vhsmServerInfo = new VhsmServerInfo();
            vhsmServerInfo.setServerType(bundle.getInt("serverType"));
            vhsmServerInfo.setAddrType(bundle.getInt("addrType"));
            vhsmServerInfo.setPort(bundle.getInt("port"));
            vhsmServerInfo.setIp(bundle.getString("addr"));
            vhsmServerInfo.setDn(bundle.getString("addr"));
            return vhsmServerInfo;
        }
        Log.e((String)TAG, (String)("get vhsm  serverinfo ret=" + make.first));
        return null;
    }

    public int updateServerInfo(Context context, boolean isIP, String ip, int port) {
        Pair<Integer, JarJniApiProxy> make = JarMultiJniApiManager.getInstance().make(context, 32);
        if ((Integer)make.first != 0 || make.second == null) {
            Log.e((String)TAG, (String)("update serverinfo: proxy is empty ret=" + make.first));
            return -10002;
        }
        JarJniApiProxy proxy = (JarJniApiProxy)make.second;
        Bundle extras = new Bundle();
        extras.putString("method", "updateServerInfo");
        extras.putString("ip", ip);
        extras.putBoolean("isIP", isIP);
        extras.putInt("port", port);
        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return -10001;
        }
        int ret = bundle.getInt(KEY_RET);
        if (ret == 0) {
            Log.e((String)TAG, (String)("update serverinfo success ip=" + ip + " isIP=" + isIP + " port=" + port));
            return 0;
        }
        Log.e((String)TAG, (String)("pdate serverinfo ret=" + ret));
        return ret;
    }

    public Pair<Integer, Pair<JniApiParam, JarJniApiProxy>> createDefaultVhsm(Context context) {
        IGetMultiJniApi multiBinder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            return Pair.create((Object)-10002, null);
        }
        Bundle bundle = new Bundle();
        bundle.putString("method", "CreateDefaultVhsm");
        try {
            Bundle result = multiBinder.callMethod(bundle);
            if (result == null) {
                return Pair.create((Object)-10001, null);
            }
            result.setClassLoader(JniApiParam.class.getClassLoader());
            int ret = result.getInt(KEY_RET);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            JniApiParam jniApiParam = (JniApiParam)result.getParcelable("JniApiParam");
            IBinder binder = result.getBinder("Binder");
            JarJniApiTypeProxy proxy = new JarJniApiTypeProxy(context, IMultiJniApi.Stub.asInterface(binder), jniApiParam.chipType);
            return Pair.create((Object)ret, (Object)Pair.create((Object)jniApiParam, (Object)proxy));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return Pair.create((Object)-10001, null);
        }
    }

    public int SM4(JarJniApiProxy proxy, byte[] dataIn, int dataLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        if (proxy == null || dataIn == null || dataIn.length < dataLen || dataOut == null || dataOut.length < dataLen) {
            return -10000;
        }
        if (IV != null && IV.length != 16) {
            return -10000;
        }
        Bundle extras = new Bundle();
        extras.putString("method", "SM4");
        extras.putByteArray("dataIn", dataIn);
        extras.putInt("dataLen", dataLen);
        extras.putInt("flag", flag);
        extras.putByte("kID", kID);
        extras.putByteArray("IV", IV);
        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return -10000;
        }
        int ret = bundle.getInt(KEY_RET);
        byte[] dataOutTmp = null;
        if (ret == 0) {
            dataOutTmp = bundle.getByteArray("dataOut");
            System.arraycopy(dataOutTmp, 0, dataOut, 0, dataOutTmp.length);
            byte[] IVTmp = bundle.getByteArray("IV");
            if (IVTmp != null && IV != null) {
                System.arraycopy(IVTmp, 0, IV, 0, IVTmp.length);
            }
        }
        return ret;
    }
}

