/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.jniapi;

import android.os.Bundle;
import android.os.Parcelable;
import android.util.Pair;
import com.xdja.multichip.jniapi.Arithmetic;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.param.ImportCertBean;
import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class JarJniApiProxyExtra {
    public static int SM2Sign(JarJniApiProxy proxy, int role, String pin, int containNo, int certType, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        if (proxy == null) {
            throw new NullPointerException("Proxy is null!");
        }
        byte[] pubfid = new byte[2];
        byte[] prifid = new byte[2];
        if (certType == 1) {
            certType = 2;
        } else if (certType == 2) {
            certType = 5;
        } else {
            throw new ArithmeticException("certType is error!");
        }
        byte[] certId = Arithmetic.convertToFid(containNo, certType);
        pubfid[0] = 0;
        pubfid[1] = (byte)(certId[1] + 1);
        prifid[0] = 0;
        prifid[1] = (byte)(certId[1] + 2);
        int ret = proxy.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
        if (ret == -15 && (ret = proxy.VerifyPIN(role, pin.getBytes(), pin.length())) == 0) {
            ret = proxy.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public Pair<Integer, String> getSn(JarJniApiProxy proxy, int containNo, int certType) {
        if (certType == 1) {
            certType = 2;
        } else if (certType == 2) {
            certType = 5;
        } else {
            return Pair.create((Object)-10000, (Object)"");
        }
        byte[] certId = Arithmetic.convertToFid(containNo, certType);
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[2];
        int ret = proxy.ReadCert(certId, certBuf, certLen);
        if (ret != 0) {
            return Pair.create((Object)ret, (Object)"");
        }
        X509Certificate x509Cert = Arithmetic.getX509Certificate(certBuf, certLen[0]);
        if (x509Cert == null) {
            return Pair.create((Object)-10004, (Object)"");
        }
        byte[] certSn = x509Cert.getSerialNumber().toByteArray();
        System.arraycopy(certSn, 0, certBuf, 0, certSn.length);
        certLen[0] = certSn.length;
        String stringCertSn = "";
        for (int i = 0; i < certLen[0]; ++i) {
            stringCertSn = stringCertSn + String.format("%02x", certBuf[i]);
        }
        return Pair.create((Object)ret, (Object)stringCertSn);
    }

    public static Pair<Integer, byte[]> getPubKey(JarJniApiProxy proxy, int containNo, int certType) {
        if (certType == 1) {
            certType = 2;
        } else if (certType == 2) {
            certType = 5;
        } else {
            return Pair.create((Object)-10000, null);
        }
        byte[] certId = Arithmetic.convertToFid(containNo, certType);
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        int ret = proxy.ReadCert(certId, certBuf, certLen);
        if (ret != 0) {
            return Pair.create((Object)ret, null);
        }
        byte[] pubKeyBytes = JarJniApiProxyExtra.getPubKey(certBuf, certLen[0]);
        if (pubKeyBytes == null) {
            return Pair.create((Object)-1, null);
        }
        return Pair.create((Object)0, (Object)pubKeyBytes);
    }

    public static int importCert(JarJniApiProxy proxy, ImportCertBean bean) {
        Bundle bundle = new Bundle();
        bundle.putString("method", "ImportCert");
        bundle.putParcelable(ImportCertBean.class.getSimpleName(), (Parcelable)bean);
        Bundle result = proxy.callMethod(bundle);
        if (result != null) {
            int ret = result.getInt("ret");
            return ret;
        }
        return -1;
    }

    private static byte[] getPubKey(byte[] certByte, int certLen) {
        byte[] pubKeyBytes;
        block9: {
            pubKeyBytes = null;
            try {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certByte, 0, certLen));
                try {
                    PublicKey publicKey = cert.getPublicKey();
                    String alg = publicKey.getAlgorithm();
                    byte[] encoded = publicKey.getEncoded();
                    if ("RSA".equals(alg)) {
                        pubKeyBytes = Arrays.copyOfRange(encoded, 22, encoded.length);
                        break block9;
                    }
                    if ("1.2.840.10045.2.1".equals(alg)) {
                        pubKeyBytes = Arrays.copyOfRange(encoded, 26, encoded.length);
                        break block9;
                    }
                    pubKeyBytes = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    byte[] rsaHeader = new byte[]{48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0};
                    int start = JarJniApiProxyExtra.indexOf(certByte, rsaHeader, 0);
                    if (start > 0) {
                        pubKeyBytes = Arrays.copyOfRange(certByte, start += rsaHeader.length, start + 140);
                    } else {
                        byte[] sm2Header = new byte[]{48, 89, 48, 19, 6, 7, 42, -122, 72, -50, 61, 2, 1, 6, 8, 42, -127, 28, -49, 85, 1, -126, 45, 3, 66, 0};
                        start = JarJniApiProxyExtra.indexOf(certByte, sm2Header, 0);
                        if (start > 0) {
                            pubKeyBytes = Arrays.copyOfRange(certByte, start += sm2Header.length, start + 65);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pubKeyBytes;
    }

    private static int indexOf(byte[] origin, byte[] search, int start) {
        if (origin == null || origin.length == 0 || search == null || search.length == 0) {
            return -10;
        }
        int originLen = origin.length;
        int searchLen = search.length;
        if (originLen < searchLen) {
            return -1;
        }
        if (start + searchLen > originLen) {
            return -1;
        }
        int searchStart = start;
        int result = -1;
        for (int i = searchStart; i <= originLen - searchLen; ++i) {
            int j;
            for (j = 0; j < searchLen && origin[i + j] == search[j]; ++j) {
            }
            if (j != searchLen) continue;
            result = i;
            break;
        }
        return result;
    }
}

