/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.jniapi;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Pair;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.jar.forcallprovider.ForCallProvider;
import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.IMultiJniApi;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.param.JniApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JarMultiJniApiManager {
    public static final int RET_OK = 0;
    private static final String KEY_BINDER_BINDER = "Binder";
    private static final String KEY_PARCELABLE_CHIPPARAM = "JniApiParam";
    private static JarMultiJniApiManager instance;
    private IGetMultiJniApi getMultiJniApiBinder = null;
    private HashMap<String, IBinder> cardIdBinderMap = new HashMap();
    private HashMap<IBinder, JarJniApiProxy> binderProxyMap = new HashMap();
    private static ArrayList<String> findList;

    private JarMultiJniApiManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JarMultiJniApiManager getInstance() {
        if (instance != null) return instance;
        Class<JarMultiJniApiManager> clazz = JarMultiJniApiManager.class;
        synchronized (JarMultiJniApiManager.class) {
            if (instance != null) return instance;
            instance = new JarMultiJniApiManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Pair<Integer, List<JniApiParam>> getAll(Context context) {
        if (context == null) {
            return Pair.create((Object)-10000, null);
        }
        IGetMultiJniApi multiBinder = this.getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            return Pair.create((Object)-10002, null);
        }
        try {
            List<Bundle> result = multiBinder.getMultiJniApi();
            ArrayList<JniApiParam> list = new ArrayList<JniApiParam>();
            if (result == null || result.size() == 0) {
                return Pair.create((Object)0, list);
            }
            for (Bundle bundle : result) {
                bundle.setClassLoader(JniApiParam.class.getClassLoader());
                JniApiParam jniApiParam = (JniApiParam)bundle.getParcelable(KEY_PARCELABLE_CHIPPARAM);
                final IBinder binder = bundle.getBinder(KEY_BINDER_BINDER);
                final String cardId = jniApiParam.cardId;
                this.cardIdBinderMap.put(cardId, binder);
                binder.linkToDeath(new IBinder.DeathRecipient(){

                    public void binderDied() {
                        JarMultiJniApiManager.this.cardIdBinderMap.remove(cardId);
                        JarMultiJniApiManager.this.binderProxyMap.remove(binder);
                    }
                }, 0);
                list.add(jniApiParam);
            }
            return Pair.create((Object)0, list);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return Pair.create((Object)-10001, null);
        }
    }

    public Pair<Integer, JarJniApiProxy> make(Context context, String cardId) {
        if (context == null || TextUtils.isEmpty((CharSequence)cardId)) {
            return Pair.create((Object)-10000, null);
        }
        IBinder binder = this.cardIdBinderMap.get(cardId);
        if (binder == null) {
            this.getAll(context);
            binder = this.cardIdBinderMap.get(cardId);
        }
        if (binder != null) {
            XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
            try {
                int ret = IMultiJniApi.Stub.asInterface(binder).GetDevInfo(0L, devinfo);
                if (ret == 0) {
                    String getCardId = new String(devinfo.cardid, 0, 32);
                    if (cardId.equals(getCardId)) {
                        if (this.binderProxyMap.containsKey(binder)) {
                            return Pair.create((Object)0, (Object)this.binderProxyMap.get(binder));
                        }
                        JarJniApiProxy jniApiJarProxy = new JarJniApiProxy(context, IMultiJniApi.Stub.asInterface(binder), getCardId);
                        this.binderProxyMap.put(binder, jniApiJarProxy);
                        return Pair.create((Object)0, (Object)jniApiJarProxy);
                    }
                    this.cardIdBinderMap.remove(cardId);
                    this.binderProxyMap.remove(binder);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return Pair.create((Object)-10001, null);
            }
            return Pair.create((Object)-10003, null);
        }
        return Pair.create((Object)-10002, null);
    }

    HashMap<String, IBinder> getCardIdBinderMap() {
        return this.cardIdBinderMap;
    }

    HashMap<IBinder, JarJniApiProxy> getBinderProxyMap() {
        return this.binderProxyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IGetMultiJniApi getGetMultiJniApiBinder(Context context) {
        if (this.getMultiJniApiBinder != null) return this.getMultiJniApiBinder;
        Class<JarMultiJniApiManager> clazz = JarMultiJniApiManager.class;
        synchronized (JarMultiJniApiManager.class) {
            IBinder binder;
            int ret;
            if (this.getMultiJniApiBinder != null) return this.getMultiJniApiBinder;
            ContentResolver resolver = context.getContentResolver();
            Uri uri = this.getUri(context);
            if (uri == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            String method = "GetBinder";
            String arg = "GetMultiJniApiBinder";
            Bundle bundle = resolver.call(uri, method, arg, null);
            if (bundle == null || (ret = bundle.getInt("ret")) != 0 || (binder = bundle.getBinder(KEY_BINDER_BINDER)) == null) return this.getMultiJniApiBinder;
            this.getMultiJniApiBinder = IGetMultiJniApi.Stub.asInterface(binder);
            try {
                binder.linkToDeath(new IBinder.DeathRecipient(){

                    public void binderDied() {
                        JarMultiJniApiManager.this.getMultiJniApiBinder = null;
                    }
                }, 0);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return this.getMultiJniApiBinder;
        }
    }

    private Uri getUri(Context context) {
        return ForCallProvider.getGetProxyProviderUri((Context)context);
    }

    static {
        findList = new ArrayList();
    }

    public static interface ConnectBluetoothKeyCallBack {
        public void callBack(int var1, JarJniApiProxy var2);
    }
}

