/**
 * ErrorCode.java
 *
 * @author zhangxiaolong@xdja.com
 * 2015-7-8
 */
package com.xdja.multichip.jniapi;

import android.content.Context;

import com.xdja.SafeKey.JNIAPI;

public class JarMultiJniApiErrorCode {

    /**
     * 卡口令还有1次重试机会
     */
    public final static int XKR_PWD_1 = JNIAPI.XKR_BASE + 1;
    /**
     * 卡口令还有2次重试机会
     */
    public final static int XKR_PWD_2 = JNIAPI.XKR_BASE + 2;
    /**
     * 卡口令还有3次重试机会
     */
    public final static int XKR_PWD_3 = JNIAPI.XKR_BASE + 3;
    /**
     * 卡口令还有4次重试机会
     */
    public final static int XKR_PWD_4 = JNIAPI.XKR_BASE + 4;
    /**
     * 卡口令还有5次重试机会
     */
    public final static int XKR_PWD_5 = JNIAPI.XKR_BASE + 5;
    /**
     * 卡口令还有6次重试机会
     */
    public final static int XKR_PWD_6 = JNIAPI.XKR_BASE + 6;
    /**
     * 卡口令还有7次重试机会
     */
    public final static int XKR_PWD_7 = JNIAPI.XKR_BASE + 7;
    /**
     * 卡口令还有8次重试机会
     */
    public final static int XKR_PWD_8 = JNIAPI.XKR_BASE + 8;
    /**
     * 卡口令还有9次重试机会
     */
    public final static int XKR_PWD_9 = JNIAPI.XKR_BASE + 9;


    /**
     * -10000：参数错误
     */
    public final static int RET_PARAM_ERROR = -10000;

    /**
     * -10001：异常
     */
    public static final int RET_EXCEPTION = -10001;

    /**
     * -10002：获取远程服务代理失败
     */
    public static final int RET_GET_BINDER_FAIL = -10002;

    /**
     * -10004：未能成功创建对象。
     * 注：{@link JarMultiJniApiManager#make(Context, String)},
     * {@link JarMultiJniApiManager#make(Context, int)}接口专用错误，
     */
    public static final int RET_MAKE_FAILE = -10003;

    /**
     * -10004:getSafeCardSn 的计算返回错误
     */
    public final static int GET_SAFE_CARD_SN_ERROR = -10004;

    /**
     * -10006: signData 的计算返回错误
     */
    public final static int SIGN_DATA_ERROR = -10006;

    /**
     * -10007: genBusinessKey 的计算返回错误
     */
    public final static int GEN_BUSINESS_KEY_ERROR = -10007;

    /**
     * -10008: PubKeyCalculate 的参数错误
     */
    public final static int PUB_KEY_CALCULATE_PARAM_ERROR = -10008;

    /**
     * -10009: 出参的长度有误
     */
    public final static int OUT_PARAM_LEN_ERROR = -10009;

    /**
     * -10010：芯片获取设备信息失败或芯片获取随机数失败
     */
    public final static int GET_SAFE_KEY_INFO_ERROR = -10010;

    /**
     * -10011：激活安全芯片失败
     */
    public final static int ACTIVATE_SAFE_KEY_FAIL = -10011;

    /**
     * -10012：激活安全芯片时，Json编码有误
     */
    public final static int ACTIVATE_ERROR_BY_JSON_ENCODE = -10012;

    /**
     * -10013：激活安全芯片时，云服务平台URL解析错误
     */
    public final static int ACTIVATE_ERROR_BY_URL = -10013;

    /**
     * -10014：激活安全芯片时，SSL相关错误
     */
    public final static int ACTIVATE_ERROR_BY_SSL = -10014;

    /**
     * -10015：激活安全芯片时，JSON解码失败
     */
    public final static int ACTIVATE_ERROR_BY_JSON_DECODE = -10015;

    /**
     * -10016：激活安全芯片时，传递的URL解析ip时为空
     */
    public final static int ACTIVATE_URL_ERROR = -10016;

    /**
     * -10017：调用方法时，安全芯片驱动服务 死亡;
     * 遇到此返回值,使用此接口的程序，可做如下处理：
     * 1.重新调用接口<br>
     * 2.重新调用init接口初始化
     * 3.重启程序<br>
     */
    public final static int SAFE_KEY_SERVICE_DIE = -10017;

    /**
     * -10018:服务器内部异常
     * 如：数据库异常、内存问题
     */
    public final static int ACTIVATE_ERROR_BY_SERVER = -10018;

    /**
     * -10019:请求参数错误
     * 请求的参数与服务器发布的不一致，如：参数数量、参数类型、参数长度等错误
     */
    public final static int ACTIVATE_ERROR_BY_PARAMETER = -10019;
    /**
     * -10020:没有权限
     */
    public final static int ACTIVATE_ERROR_BY_NO_PERMISSION = -10020;
    /**
     * -10021:调用卡库异常,卡库返回错误码
     */
    public final static int ACTIVATE_ERROR_BY_KAKU = -10021;
    /**
     * -10022:服务器没有提供此操作
     */
    public final static int NO_THIS_OPERATE_IN_SERVER = -10022;
    /**
     * -10023:服务器没有提供此操作
     */
    public final static int ACTIVATE_ERROR_BY_TIME = -10023;
    /**
     * -10024:服务器没有提供此操作
     */
    public final static int ACTIVATE_ERROR_BY_CONNECT_TIME_OUT = -10024;
    /**
     * -10025:芯片未出厂
     */
    public final static int ACTIVATE_ERROR_BY_NO_EX_FACTORY = -10025;
    /**
     * -10026:无可用License
     */
    public final static int ACTIVATE_ERROR_BY_NO_AVAILABLE_LICENSE = -10026;

    /**
     * -10027: 没有此方法<br>
     * RET_NOT_SUPPORT_METHOD 和 NO_SUCH_METHOD 要表达的意思不太一样。<br>
     * RET_NOT_SUPPORT_METHOD：表示调用的接口存在，但是此接口的功能不能实现，此返回值多表现在芯片类型不支持某些接口，
     * 比如：贴膜卡的一些接口就是没有实现芯片类型的某些接口；<br>
     * NO_SUCH_METHOD：表示调用的接口或者方法就没有，此返回值多表现在jar包调用了芯片管家的低版本，而低版本还没有实现此接口。
     */
    public final static int NO_SUCH_METHOD = -10027;

    /**
     * -1001： 不支持此方法<br>
     * RET_NOT_SUPPORT_METHOD 和 NO_SUCH_METHOD 要表达的意思不太一样。<br>
     * RET_NOT_SUPPORT_METHOD：表示调用的接口存在，但是此接口的功能不能实现，此返回值多表现在芯片类型不支持某些接口，
     * 比如：贴膜卡的一些接口就是没有实现芯片类型的某些接口；<br>
     * NO_SUCH_METHOD：表示调用的接口或者方法就没有，此返回值多表现在jar包调用了芯片管家的低版本，而低版本还没有实现此接口。
     */
    public final static int RET_NOT_SUPPORT_METHOD = -1001;

    /**
     * -10028: 没有权限
     */
    public final static int RET_NO_POWER = -10028;
}