package com.xdja.multichip.jniapi;

import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.util.Pair;

import com.xdja.multichip.IMultiJniApi;


/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/24 <br/>
 */
public class JarJniApiTypeProxy extends JarJniApiProxy{

    private Context context;
    private int cardType;

    public JarJniApiTypeProxy(Context context, IMultiJniApi binder,int cardType) {
        super( context, binder);
        this.context = context.getApplicationContext();
        this.cardType = cardType;
        if (this.context == null){
            this.context = context;
        }
        this.binder = binder;
        binderDeathLink();
    }

    @Override
    protected IMultiJniApi getBinder() {
        if (binder == null) {
            Pair<Integer, JarJniApiProxy> pair = JarMultiJniApiManager.getInstance().make(context, cardType);
            if (pair != null && pair.first == 0) {
                this.binder = pair.second.binder;
                binderDeathLink();
            }
        }
        return binder;
    }

    /**
     * binder死亡监听
     */
    private void binderDeathLink() {
        try {
            binder.asBinder().linkToDeath(new IBinder.DeathRecipient() {
                @Override
                public void binderDied() {
                    binder = null;
                }
            }, Binder.FLAG_ONEWAY);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
