package com.xdja.multichip.jniapi;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import android.util.Pair;

import com.xdja.blesafekey.BleCallback;
import com.xdja.multichip.IMultiJniApi;
import com.xdja.multichip.param.JniApiParam;

import static com.xdja.multichip.jniapi.JarMultiJniApiErrorCode.RET_EXCEPTION;
import static com.xdja.multichip.jniapi.JarMultiJniApiErrorCode.RET_MAKE_FAILE;
import static com.xdja.multichip.jniapi.JarMultiJniApiErrorCode.RET_PARAM_ERROR;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/8/9 <br/>
 */

public class JarMultiJniApiBleManager {
    private static JarMultiJniApiBleManager instance;
    private static final Uri uri = Uri.parse("content://com.xdja.multichip.process.bluetooth.BluetoothKeyProcessProvider");

    public static final String KEY_RET = "ret";
    public static final String KEY_BINDER = "Binder";
    public static final String KEY_JNIAPIPARAM = "JniApiParam";
    public static final String KEY_DEVADDRESS = "devAddress";
    public static final String KEY_DEVNAME = "devName";
    public static final String KEY_MESSENGER = "Messenger";
    public static final String KEY_METHOD = "method";

    private JarMultiJniApiBleManager() {

    }

    public static JarMultiJniApiBleManager getInstance() {
        if (instance == null) {
            synchronized (JarMultiJniApiBleManager.class) {
                if (instance == null) {
                    instance = new JarMultiJniApiBleManager();
                }
            }
        }
        return instance;
    }

    /**
     * 连接蓝牙key
     *
     * @param context
     * @param devAddress
     * @param devName
     * @return
     */
    public Pair<Integer, JarJniApiProxy> connectBluetoohKey(Context context, String devAddress, String devName) {
        if (context == null || TextUtils.isEmpty(devAddress) || TextUtils.isEmpty(devName)) {
            return Pair.create(RET_PARAM_ERROR, null);
        }
        ContentResolver resolver = context.getContentResolver();
        Bundle extras = new Bundle();
        extras.putString(KEY_DEVADDRESS, devAddress);
        extras.putString(KEY_DEVNAME, devName);
        Bundle bundle = resolver.call(uri, "ConnectBluetoothKey", "", extras);
        if (bundle != null) {
            bundle.setClassLoader(JniApiParam.class.getClassLoader());
            int ret = bundle.getInt(KEY_RET);
            if (ret == 0) {
                IBinder binder = bundle.getBinder(KEY_BINDER);
                JniApiParam jniApiParam = bundle.getParcelable(KEY_JNIAPIPARAM);
                if (jniApiParam != null && !TextUtils.isEmpty(jniApiParam.cardId)) {
                    JarMultiJniApiManager.getInstance().getCardIdBinderMap().put(jniApiParam.cardId, binder);
                    JarJniApiProxy proxy = JarMultiJniApiManager.getInstance().getBinderProxyMap().get(binder);
                    if (proxy == null) {
                        proxy = new JarJniApiProxy(context, IMultiJniApi.Stub.asInterface(binder),jniApiParam.cardId);
                        JarMultiJniApiManager.getInstance().getBinderProxyMap().put(binder, proxy);
                    }
                    return Pair.create(0, proxy);
                }
            }
        }
        return Pair.create(RET_MAKE_FAILE, null);
    }

    public int connectBluetoothKey(final Context context, String devAddress, String devName, final JarMultiJniApiManager.ConnectBluetoothKeyCallBack callBack) {
        if (context == null || TextUtils.isEmpty(devAddress) || TextUtils.isEmpty(devName)) {
            return RET_PARAM_ERROR;
        }
        ContentResolver resolver = context.getContentResolver();
        Bundle extras = new Bundle();
        extras.putString(KEY_DEVADDRESS, devAddress);
        extras.putString(KEY_DEVNAME, devName);
        Messenger messenger = new Messenger(new Handler(Looper.myLooper()) {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 0:
                        Bundle bundle = (Bundle) msg.obj;
                        if (bundle != null) {
                            bundle.setClassLoader(JniApiParam.class.getClassLoader());
                            int ret = bundle.getInt(KEY_RET);
                            if (ret == 0) {
                                IBinder binder = bundle.getBinder(KEY_BINDER);
                                JniApiParam jniApiParam = bundle.getParcelable(KEY_JNIAPIPARAM);
                                if (jniApiParam != null && !TextUtils.isEmpty(jniApiParam.cardId)) {
                                    JarMultiJniApiManager.getInstance().getCardIdBinderMap().put(jniApiParam.cardId, binder);
                                    JarJniApiProxy proxy = JarMultiJniApiManager.getInstance().getBinderProxyMap().get(binder);
                                    if (proxy == null) {
                                        proxy = new JarJniApiProxy(context.getApplicationContext(), IMultiJniApi.Stub.asInterface(binder),jniApiParam.cardId);
                                        JarMultiJniApiManager.getInstance().getBinderProxyMap().put(binder, proxy);
                                    }
                                    callBack.callBack(0, proxy);
                                    break;
                                }
                            }
                        }
                        callBack.callBack(-1, null);
                        break;
                }
            }
        });
        extras.putBinder(KEY_MESSENGER, messenger.getBinder());
        Bundle bundle = resolver.call(uri, "ConnectBluetoothKeyCallBack", "", extras);
        if (bundle != null) {
            int ret = bundle.getInt(KEY_RET);
            return ret;
        }

        return RET_EXCEPTION;
    }

    /**
     * 断开蓝牙连接
     *
     * @param context
     * @param devAddress
     * @param devName
     * @return
     */
    public int disConnectBluetoothKey(Context context, String devAddress, String devName) {
        int ret;
        if (context == null || TextUtils.isEmpty(devAddress) || TextUtils.isEmpty(devName)) {
            return RET_PARAM_ERROR;
        }
        ContentResolver resolver = context.getContentResolver();
        Bundle extras = new Bundle();
        extras.putString(KEY_DEVADDRESS, devAddress);
        extras.putString(KEY_DEVNAME, devName);
        Bundle bundle = resolver.call(uri, "DisconnectBluetoothKey", "", extras);
        if (bundle == null) {
            ret = RET_EXCEPTION;
        } else {
            ret = bundle.getInt(KEY_RET);
        }
        return ret;
    }

    public int GetBleState(JarJniApiProxy proxy) {
        if (proxy == null) {
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }

        Bundle extras = new Bundle();
        extras.putString(KEY_METHOD, "GetBleState");
        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return JarMultiJniApiErrorCode.RET_EXCEPTION;
        }
        int ret = bundle.getInt(KEY_RET);
        return ret;
    }

    public int GetBleBattery(JarJniApiProxy proxy) {
        if (proxy == null) {
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }

        Bundle extras = new Bundle();
        extras.putString(KEY_METHOD, "GetBleBattery");
        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return JarMultiJniApiErrorCode.RET_EXCEPTION;
        }
        int ret = bundle.getInt(KEY_RET);
        return ret;
    }

    /**
     * 设置回调
     *
     * @param proxy
     * @param bleCallback
     * @return
     */
    public int setCallBack(JarJniApiProxy proxy, final BleCallback bleCallback) {
        if (proxy == null) {
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }

        Bundle extras = new Bundle();
        extras.putString(KEY_METHOD, "SetCallBack");
        Messenger messenger = new Messenger(new Handler() {
            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1:
                        int newStatus = msg.arg1;
                        bleCallback.OnBleStateChange(newStatus);
                        break;
                }
            }
        });
        extras.putBinder(KEY_MESSENGER, messenger.getBinder());
        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return JarMultiJniApiErrorCode.RET_EXCEPTION;
        }
        return bundle.getInt(KEY_RET);
    }

}
