package com.xdja.multichip.param;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/24 <br/>
 */

public class JniApiParam implements Parcelable {
    /**
     * 芯片
     */
    public static final int TYPE_ONBOARD = 1;
    /**
     * TF卡类型
     */
    public static final int TYPE_TF = 2;

    /**
     * 蓝牙Key
     */
    public static final int TYPE_BLUETOOTH = 4;

    /**
     * 贴膜卡
     */
    public static final int TYPE_COVERED = 8;


    /**
     * 类型
     */
    public int chipType;
    /**
     * 芯片的唯一标识
     */
    public String cardId;

    /**
     * 其他参数
     */
    public String other;

    public JniApiParam() {

    }

    protected JniApiParam(Parcel in) {
        chipType = in.readInt();
        cardId = in.readString();
        other = in.readString();
    }

    public static final Creator<JniApiParam> CREATOR = new Creator<JniApiParam>() {
        @Override
        public JniApiParam createFromParcel(Parcel in) {
            return new JniApiParam(in);
        }

        @Override
        public JniApiParam[] newArray(int size) {
            return new JniApiParam[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(chipType);
        parcel.writeString(cardId);
        parcel.writeString(other);
    }
}
