/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.jniapi;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import android.util.Pair;
import com.xdja.blesafekey.BleCallback;
import com.xdja.multichip.IMultiJniApi;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.param.JniApiParam;

public class JarMultiJniApiBleManager {
    private static JarMultiJniApiBleManager instance;
    private static final Uri uri;
    public static final String KEY_RET = "ret";
    public static final String KEY_BINDER = "Binder";
    public static final String KEY_JNIAPIPARAM = "JniApiParam";
    public static final String KEY_DEVADDRESS = "devAddress";
    public static final String KEY_DEVNAME = "devName";
    public static final String KEY_MESSENGER = "Messenger";
    public static final String KEY_METHOD = "method";

    private JarMultiJniApiBleManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JarMultiJniApiBleManager getInstance() {
        if (instance != null) return instance;
        Class<JarMultiJniApiBleManager> clazz = JarMultiJniApiBleManager.class;
        synchronized (JarMultiJniApiBleManager.class) {
            if (instance != null) return instance;
            instance = new JarMultiJniApiBleManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Pair<Integer, JarJniApiProxy> connectBluetoohKey(Context context, String devAddress, String devName) {
        if (context == null || TextUtils.isEmpty((CharSequence)devAddress) || TextUtils.isEmpty((CharSequence)devName)) {
            return Pair.create((Object)-10000, null);
        }
        ContentResolver resolver = context.getContentResolver();
        Bundle extras = new Bundle();
        extras.putString(KEY_DEVADDRESS, devAddress);
        extras.putString(KEY_DEVNAME, devName);
        Bundle bundle = resolver.call(uri, "ConnectBluetoothKey", "", extras);
        if (bundle != null) {
            bundle.setClassLoader(JniApiParam.class.getClassLoader());
            int ret = bundle.getInt(KEY_RET);
            if (ret == 0) {
                IBinder binder = bundle.getBinder(KEY_BINDER);
                JniApiParam jniApiParam = (JniApiParam)bundle.getParcelable(KEY_JNIAPIPARAM);
                if (jniApiParam != null && !TextUtils.isEmpty((CharSequence)jniApiParam.cardId)) {
                    JarMultiJniApiManager.getInstance().getCardIdBinderMap().put(jniApiParam.cardId, binder);
                    JarJniApiProxy proxy = JarMultiJniApiManager.getInstance().getBinderProxyMap().get(binder);
                    if (proxy == null) {
                        proxy = new JarJniApiProxy(context, IMultiJniApi.Stub.asInterface(binder), jniApiParam.cardId, jniApiParam.chipType);
                        JarMultiJniApiManager.getInstance().getBinderProxyMap().put(binder, proxy);
                    }
                    return Pair.create((Object)0, (Object)proxy);
                }
            }
        }
        return Pair.create((Object)-10003, null);
    }

    public int connectBluetoothKey(final Context context, String devAddress, String devName, final JarMultiJniApiManager.ConnectBluetoothKeyCallBack callBack) {
        if (context == null || TextUtils.isEmpty((CharSequence)devAddress) || TextUtils.isEmpty((CharSequence)devName)) {
            return -10000;
        }
        ContentResolver resolver = context.getContentResolver();
        Bundle extras = new Bundle();
        extras.putString(KEY_DEVADDRESS, devAddress);
        extras.putString(KEY_DEVNAME, devName);
        Messenger messenger = new Messenger(new Handler(Looper.myLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 0: {
                        Bundle bundle = (Bundle)msg.obj;
                        if (bundle != null) {
                            bundle.setClassLoader(JniApiParam.class.getClassLoader());
                            int ret = bundle.getInt(JarMultiJniApiBleManager.KEY_RET);
                            if (ret == 0) {
                                IBinder binder = bundle.getBinder(JarMultiJniApiBleManager.KEY_BINDER);
                                JniApiParam jniApiParam = (JniApiParam)bundle.getParcelable(JarMultiJniApiBleManager.KEY_JNIAPIPARAM);
                                if (jniApiParam != null && !TextUtils.isEmpty((CharSequence)jniApiParam.cardId)) {
                                    JarMultiJniApiManager.getInstance().getCardIdBinderMap().put(jniApiParam.cardId, binder);
                                    JarJniApiProxy proxy = JarMultiJniApiManager.getInstance().getBinderProxyMap().get(binder);
                                    if (proxy == null) {
                                        proxy = new JarJniApiProxy(context.getApplicationContext(), IMultiJniApi.Stub.asInterface(binder), jniApiParam.cardId, jniApiParam.chipType);
                                        JarMultiJniApiManager.getInstance().getBinderProxyMap().put(binder, proxy);
                                    }
                                    callBack.callBack(0, proxy);
                                    break;
                                }
                            }
                        }
                        callBack.callBack(-1, null);
                    }
                }
            }
        });
        extras.putBinder(KEY_MESSENGER, messenger.getBinder());
        Bundle bundle = resolver.call(uri, "ConnectBluetoothKeyCallBack", "", extras);
        if (bundle != null) {
            int ret = bundle.getInt(KEY_RET);
            return ret;
        }
        return -10001;
    }

    public int disConnectBluetoothKey(Context context, String devAddress, String devName) {
        if (context == null || TextUtils.isEmpty((CharSequence)devAddress) || TextUtils.isEmpty((CharSequence)devName)) {
            return -10000;
        }
        ContentResolver resolver = context.getContentResolver();
        Bundle extras = new Bundle();
        extras.putString(KEY_DEVADDRESS, devAddress);
        extras.putString(KEY_DEVNAME, devName);
        Bundle bundle = resolver.call(uri, "DisconnectBluetoothKey", "", extras);
        int ret = bundle == null ? -10001 : bundle.getInt(KEY_RET);
        return ret;
    }

    public int GetBleState(JarJniApiProxy proxy) {
        if (proxy == null) {
            return -10000;
        }
        Bundle extras = new Bundle();
        extras.putString(KEY_METHOD, "GetBleState");
        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return -10001;
        }
        int ret = bundle.getInt(KEY_RET);
        return ret;
    }

    public int GetBleBattery(JarJniApiProxy proxy) {
        if (proxy == null) {
            return -10000;
        }
        Bundle extras = new Bundle();
        extras.putString(KEY_METHOD, "GetBleBattery");
        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return -10001;
        }
        int ret = bundle.getInt(KEY_RET);
        return ret;
    }

    public int setCallBack(JarJniApiProxy proxy, final BleCallback bleCallback) {
        if (proxy == null) {
            return -10000;
        }
        Bundle extras = new Bundle();
        extras.putString(KEY_METHOD, "SetCallBack");
        Messenger messenger = new Messenger(new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        int newStatus = msg.arg1;
                        bleCallback.OnBleStateChange(newStatus);
                    }
                }
            }
        });
        extras.putBinder(KEY_MESSENGER, messenger.getBinder());
        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return -10001;
        }
        return bundle.getInt(KEY_RET);
    }

    static {
        uri = Uri.parse((String)"content://com.xdja.multichip.process.bluetooth.BluetoothKeyProcessProvider");
    }
}

