/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.param;

import android.os.Bundle;

public class CertBean {
    public static final int PARAM_LACK = -2001;
    public static final int NOT_SUPPORT_VERSION = -2002;
    public static final int PARAM_ERROR = -2003;
    public static final int PIN_ERROR = -2004;
    public static final int CREATE_CONTAINER_ERROR = -2005;
    public static final int NOT_SUPPORT_ALG = -2006;
    public static final int UPDATE_CONTAINER_ERROR = -2007;
    public static final int WRITE_EXCHANGE_PUBKEY_ERROR = -2008;
    public static final int WRITE_EXCHANGE_PRIKEY_ERROR = -2009;
    public static final int WRITE_EXCHANGE_CERT_ERROR = -2010;
    public static final int WRITE_SIGN_CERT_ERROR = -2011;
    public static final int ANALYSIS_DATA_ERROR = -2012;
    public static final int EXCEPTION = -2013;
    public static final String KEY_VERSION_INT = "version";
    public static final String KEY_ROLE_INT = "role";
    public static final String KEY_PIN_STRING = "pin";
    public static final String KEY_CONTAINERNO_INT = "containerNo";
    public static final String KEY_SIGNCERT_BYTEARRAY = "signCert";
    public static final String KEY_EXCHANGECERT_BYTEARRAY = "exchangeCert";
    public static final String KEY_ENVELOPEDKEY_BYTEARRAY = "envelopedKey";
    public static final String KEY_EXCHANGEPUBKEY_BYTEARRAY = "exchangePubKey";
    public static final String KEY_EXCHANGEPRIKEY_BYTEARRAY = "exchangePriKey";
    public static final String KEY_RET_INT = "ret";
    public static final String KEY_INFO_STRING = "info";
    public static final String KEY_CERTTYPE_INT = "certType";
    public static final String KEY_CERTALG_INT = "certAlg";
    public static final String KEY_DATATYPE_INT = "dataType";
    public static final int ALG_RSA = 1;
    public static final int ALG_SM2 = 2;
    public static final int TYPE_SINGLE = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int DATA_TYPE_SKF = 1;
    public static final int DATA_TYPE_NORMAL = 2;
    public static final int VERSION_CUR = 1;
    private final int version = 1;
    private int certAlg;
    private int certType;
    private int dataType;
    private int role;
    private String pin;
    private int containerNo;
    private byte[] signCert;
    private byte[] exchangeCert;
    private byte[] envelopedKey;
    private byte[] exchangePubKey;
    private byte[] exchangePriKey;

    public int getVersion() {
        return 1;
    }

    public int getCertAlg() {
        return this.certAlg;
    }

    public int getCertType() {
        return this.certType;
    }

    public int getRole() {
        return this.role;
    }

    public String getPin() {
        return this.pin;
    }

    public int getContainerNo() {
        return this.containerNo;
    }

    public byte[] getSignCert() {
        return this.signCert;
    }

    public byte[] getExchangeCert() {
        return this.exchangeCert;
    }

    public byte[] getEnvelopedKey() {
        return this.envelopedKey;
    }

    public byte[] getExchangePubKey() {
        return this.exchangePubKey;
    }

    public byte[] getExchangePriKey() {
        return this.exchangePriKey;
    }

    private CertBean() {
    }

    public static CertBean createDoubleSM2CertSkf(int role, String pin, int containerNo, byte[] signCert, byte[] exchangeCert, byte[] envelopedKey) {
        CertBean bean = new CertBean();
        bean.role = role;
        bean.pin = pin;
        bean.containerNo = containerNo;
        bean.signCert = signCert;
        bean.exchangeCert = exchangeCert;
        bean.envelopedKey = envelopedKey;
        bean.certAlg = 2;
        bean.certType = 2;
        bean.dataType = 1;
        return bean;
    }

    public static CertBean createDoubleSM2Cert(int role, String pin, int containerNo, byte[] signCert, byte[] exchangeCert, byte[] exchangePubKey, byte[] exchangePriKey) {
        CertBean bean = new CertBean();
        bean.role = role;
        bean.pin = pin;
        bean.containerNo = containerNo;
        bean.signCert = signCert;
        bean.exchangeCert = exchangeCert;
        bean.exchangePubKey = exchangePubKey;
        bean.exchangePriKey = exchangePriKey;
        bean.certAlg = 2;
        bean.certType = 2;
        bean.dataType = 2;
        return bean;
    }

    public static CertBean createSingleSM2Cert(int role, String pin, int containerNo, byte[] signCert) {
        CertBean bean = new CertBean();
        bean.role = role;
        bean.pin = pin;
        bean.containerNo = containerNo;
        bean.signCert = signCert;
        bean.certAlg = 2;
        bean.certType = 1;
        bean.dataType = 2;
        return bean;
    }

    public static CertBean createSingleRSACert(int role, String pin, int containerNo, byte[] signCert) {
        CertBean bean = new CertBean();
        bean.role = role;
        bean.pin = pin;
        bean.containerNo = containerNo;
        bean.signCert = signCert;
        bean.certAlg = 1;
        bean.certType = 1;
        bean.dataType = 2;
        return bean;
    }

    public Bundle getBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_VERSION_INT, 1);
        bundle.putInt(KEY_CERTALG_INT, this.certAlg);
        bundle.putInt(KEY_CERTTYPE_INT, this.certType);
        bundle.putInt(KEY_ROLE_INT, this.role);
        bundle.putString(KEY_PIN_STRING, this.pin);
        bundle.putInt(KEY_CONTAINERNO_INT, this.containerNo);
        bundle.putInt(KEY_DATATYPE_INT, this.dataType);
        if (this.signCert != null) {
            bundle.putByteArray(KEY_SIGNCERT_BYTEARRAY, this.signCert);
        }
        if (this.exchangeCert != null) {
            bundle.putByteArray(KEY_EXCHANGECERT_BYTEARRAY, this.exchangeCert);
        }
        if (this.envelopedKey != null) {
            bundle.putByteArray(KEY_ENVELOPEDKEY_BYTEARRAY, this.envelopedKey);
        }
        if (this.exchangePriKey != null) {
            bundle.putByteArray(KEY_EXCHANGEPUBKEY_BYTEARRAY, this.exchangePubKey);
        }
        if (this.exchangePriKey != null) {
            bundle.putByteArray(KEY_EXCHANGEPRIKEY_BYTEARRAY, this.exchangePriKey);
        }
        return bundle;
    }

    public int getDataType() {
        return this.dataType;
    }
}

