package com.xdja.multichip;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.widget.Toast;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/1/24 <br/>
 */
public class Utils {
    private static Context context = null;

    public static void init(Context context) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Utils.context = context.getApplicationContext();
        if (Utils.context == null) {
            Utils.context = context;
        }

    }

    public static Context getContext() {
        return context;
    }

    public static void toast(String msg) {
        Message message = Message.obtain();
        message.what = CODE_SHOW_TOAST;
        message.obj = msg;
        getHandler().sendMessage(message);
    }

    private synchronized static Handler getHandler() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper()) {
                @Override
                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    if (msg.what == CODE_SHOW_TOAST) {
                        Toast.makeText(getContext(), (String) msg.obj, Toast.LENGTH_LONG).show();
                    }
                }
            };
        }
        return handler;
    }

    private static final int CODE_SHOW_TOAST = 1;
    private static Handler handler = null;
}
