package com.xdja.multichip.jniapi;

import android.content.Context;
import android.content.SharedPreferences;


class CardTypeUtil {

    private static final String FILE_NAME_CARDID_TYPE = "safekeyservice_cardid_type";


    /**
     * 存储卡号和类型
     *
     * @param context
     * @param cardId
     * @param type
     */
    public static void saveCardIdAndType(Context context, String cardId, int type) {
        SharedPreferences preferences = context.getSharedPreferences(FILE_NAME_CARDID_TYPE,Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(cardId,type);
        editor.apply();
    }

    /**
     * 获取卡类型
     * @param context
     * @param cardId
     * @return
     */
    public static int getCardType(Context context, String cardId){
        SharedPreferences preferences = context.getSharedPreferences(FILE_NAME_CARDID_TYPE,Context.MODE_PRIVATE);
        return preferences.getInt(cardId,-1);
    }

}
