package com.xdja.multichip.jniapi;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import android.util.Pair;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.blesafekey.BleCallback;
import com.xdja.multichip.IMultiJniApi;
import com.xdja.multichip.param.JniApiParam;

import static com.xdja.multichip.jniapi.JarMultiJniApiErrorCode.RET_EXCEPTION;
import static com.xdja.multichip.jniapi.JarMultiJniApiErrorCode.RET_MAKE_FAILE;
import static com.xdja.multichip.jniapi.JarMultiJniApiErrorCode.RET_PARAM_ERROR;

/**
 * author: xwy<br/>
 * date:   2017/9/21 <br/>
 */

public class JarMultiJniApiCCManager {
    private static JarMultiJniApiCCManager instance;

    public static final String KEY_RET = "ret";
    public static final String KEY_METHOD = "method";

    private JarMultiJniApiCCManager() {

    }

    public static JarMultiJniApiCCManager getInstance() {
        if (instance == null) {
            synchronized (JarMultiJniApiCCManager.class) {
                if (instance == null) {
                    instance = new JarMultiJniApiCCManager();
                }
            }
        }
        return instance;
    }

    /**
     * 贴膜卡SM4,目前接口不支持CBC模式
     *
     * @param proxy
     * @param dataIn 要加密或解密的数据（填充过的且长度是16的倍数）
     * @param flag   加密模式
     * @param kID    加密用0x08，解密用0x09
     * @param IV     初始向量，当CBC_MODE时需要
     * @return
     */
    public int SM4(JarJniApiProxy proxy, byte[] dataIn, int dataLen, int flag, byte[] dataOut,
                   byte kID, byte[] IV) {
        if (proxy == null || dataIn == null || dataIn.length < dataLen || dataOut == null ||
                dataOut.length < dataLen) {
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }
        if (IV != null && IV.length != 16){
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }

        Bundle extras = new Bundle();
        extras.putString(KEY_METHOD, "SM4");
        extras.putByteArray("dataIn", dataIn);
        extras.putInt("dataLen", dataLen);
        extras.putInt("flag", flag);
        extras.putByte("kID", kID);
        extras.putByteArray("IV", IV);

        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }
        int ret = bundle.getInt(KEY_RET);
        byte[] dataOutTmp = null;
        if (ret == JNIAPI.XKR_OK) {
            dataOutTmp = bundle.getByteArray("dataOut");
            System.arraycopy(dataOutTmp,0,dataOut,0,dataOutTmp.length);
            byte [] IVTmp = bundle.getByteArray("IV");
            if (IVTmp != null && IV != null){
                System.arraycopy(IVTmp,0,IV,0,IVTmp.length);
            }
        }
        return ret;
    }


}
