/**
 * ErrorCode.java
 *
 * @author zhangxiaolong@xdja.com
 * 2015-7-8
 */
package com.xdja.multichip.jniapi;

import android.content.Context;

import com.xdja.SafeKey.JNIAPI;

public class JarMultiJniApiErrorCode {

    /**
     * 卡口令还有1次重试机会
     */
    public final static int XKR_PWD_1 = JNIAPI.XKR_BASE + 1;
    /**
     * 卡口令还有2次重试机会
     */
    public final static int XKR_PWD_2 = JNIAPI.XKR_BASE + 2;
    /**
     * 卡口令还有3次重试机会
     */
    public final static int XKR_PWD_3 = JNIAPI.XKR_BASE + 3;
    /**
     * 卡口令还有4次重试机会
     */
    public final static int XKR_PWD_4 = JNIAPI.XKR_BASE + 4;
    /**
     * 卡口令还有5次重试机会
     */
    public final static int XKR_PWD_5 = JNIAPI.XKR_BASE + 5;
    /**
     * 卡口令还有6次重试机会
     */
    public final static int XKR_PWD_6 = JNIAPI.XKR_BASE + 6;
    /**
     * 卡口令还有7次重试机会
     */
    public final static int XKR_PWD_7 = JNIAPI.XKR_BASE + 7;
    /**
     * 卡口令还有8次重试机会
     */
    public final static int XKR_PWD_8 = JNIAPI.XKR_BASE + 8;
    /**
     * 卡口令还有9次重试机会
     */
    public final static int XKR_PWD_9 = JNIAPI.XKR_BASE + 9;


    /**
     * -10000：参数错误
     */
    public final static int RET_PARAM_ERROR = -10000;

    /**
     * -10001：异常
     */
    public static final int RET_EXCEPTION = -10001;

    /**
     * -10002：获取远程服务代理失败
     */
    public static final int RET_GET_BINDER_FAIL = -10002;

    /**
     * -10003：未能成功创建对象。
     * 注：{@link JarMultiJniApiManager#make(Context, String)},
     * {@link JarMultiJniApiManager#make(Context, int)}接口专用错误，
     */
    public static final int RET_MAKE_FAILE = -10003;

    /**
     * -10004:getSafeCardSn 的计算返回错误
     */
    public final static int GET_SAFE_CARD_SN_ERROR = -10004;

    /**
     * -10006: signData 的计算返回错误
     */
    public final static int SIGN_DATA_ERROR = -10006;

    /**
     * -10007: genBusinessKey 的计算返回错误
     */
    public final static int GEN_BUSINESS_KEY_ERROR = -10007;

    /**
     * -10008: PubKeyCalculate 的参数错误
     */
    public final static int PUB_KEY_CALCULATE_PARAM_ERROR = -10008;

    /**
     * -10009: 出参的长度有误
     */
    public final static int OUT_PARAM_LEN_ERROR = -10009;

    /**
     * -10010：芯片获取设备信息失败或芯片获取随机数失败
     */
    public final static int GET_SAFE_KEY_INFO_ERROR = -10010;

    /**
     * -10011：激活安全芯片失败
     */
    public final static int ACTIVATE_SAFE_KEY_FAIL = -10011;

    /**
     * -10012：激活安全芯片时，Json编码有误
     */
    public final static int ACTIVATE_ERROR_BY_JSON_ENCODE = -10012;

    /**
     * -10013：激活安全芯片时，云服务平台URL解析错误
     */
    public final static int ACTIVATE_ERROR_BY_URL = -10013;

    /**
     * -10014：激活安全芯片时，SSL相关错误
     */
    public final static int ACTIVATE_ERROR_BY_SSL = -10014;

    /**
     * -10015：激活安全芯片时，JSON解码失败
     */
    public final static int ACTIVATE_ERROR_BY_JSON_DECODE = -10015;

    /**
     * -10016：激活安全芯片时，传递的URL解析ip时为空
     */
    public final static int ACTIVATE_URL_ERROR = -10016;

    /**
     * -10017：调用方法时，安全芯片驱动服务 死亡;
     * 遇到此返回值,使用此接口的程序，可做如下处理：
     * 1.重新调用接口<br>
     * 2.重新调用init接口初始化
     * 3.重启程序<br>
     */
    public final static int SAFE_KEY_SERVICE_DIE = -10017;

    /**
     * -10018:服务器内部异常
     * 如：数据库异常、内存问题
     */
    public final static int ACTIVATE_ERROR_BY_SERVER = -10018;

    /**
     * -10019:请求参数错误
     * 请求的参数与服务器发布的不一致，如：参数数量、参数类型、参数长度等错误
     */
    public final static int ACTIVATE_ERROR_BY_PARAMETER = -10019;
    /**
     * -10020:没有权限
     */
    public final static int ACTIVATE_ERROR_BY_NO_PERMISSION = -10020;
    /**
     * -10021:调用卡库异常,卡库返回错误码
     */
    public final static int ACTIVATE_ERROR_BY_KAKU = -10021;
    /**
     * -10022:服务器没有提供此操作
     */
    public final static int NO_THIS_OPERATE_IN_SERVER = -10022;
    /**
     * -10023:服务器没有提供此操作
     */
    public final static int ACTIVATE_ERROR_BY_TIME = -10023;
    /**
     * -10024:服务器没有提供此操作
     */
    public final static int ACTIVATE_ERROR_BY_CONNECT_TIME_OUT = -10024;
    /**
     * -10025:芯片未出厂
     */
    public final static int ACTIVATE_ERROR_BY_NO_EX_FACTORY = -10025;
    /**
     * -10026:无可用License
     */
    public final static int ACTIVATE_ERROR_BY_NO_AVAILABLE_LICENSE = -10026;

    /**
     * -10027: 没有此方法<br>
     * RET_NOT_SUPPORT_METHOD 和 NO_SUCH_METHOD 要表达的意思不太一样。<br>
     * RET_NOT_SUPPORT_METHOD：表示调用的接口存在，但是此接口的功能不能实现，此返回值多表现在芯片类型不支持某些接口，
     * 比如：贴膜卡的一些接口就是没有实现芯片类型的某些接口；<br>
     * NO_SUCH_METHOD：表示调用的接口或者方法就没有，此返回值多表现在jar包调用了芯片管家的低版本，而低版本还没有实现此接口。
     */
    public final static int NO_SUCH_METHOD = -10027;

    /**
     * -1001： 不支持此方法<br>
     * RET_NOT_SUPPORT_METHOD 和 NO_SUCH_METHOD 要表达的意思不太一样。<br>
     * RET_NOT_SUPPORT_METHOD：表示调用的接口存在，但是此接口的功能不能实现，此返回值多表现在芯片类型不支持某些接口，
     * 比如：贴膜卡的一些接口就是没有实现芯片类型的某些接口；<br>
     * NO_SUCH_METHOD：表示调用的接口或者方法就没有，此返回值多表现在jar包调用了芯片管家的低版本，而低版本还没有实现此接口。
     */
    public final static int RET_NOT_SUPPORT_METHOD = -1001;

    /**
     * -10028: 没有权限
     */
    public final static int RET_NO_POWER = -10028;

    /**
     * -10029: 没有Android上的权限
     */
    public final static int RET_NO_PERMISSION = -10029;

    /**
     * 虚拟卡已存在
     */
    public final static int RET_VHSM_CHIP_EXIST = -10030;


    /**
     * -10031:（-205）订单类型为无需激活
     */
    public final static int ACTIVATE_ERROR_NO_NEED_ACTIVE = -10031;

    /**
     * -10032:（-206）芯片资产信息不存在
     */
    public final static int ACTIVATE_ERROR_CHIP_CERT_INFO_NOT_EXIST = -10032;
    /**
     * -10033:（-207）激活时间超过限制
     */
    public final static int ACTIVATE_ERROR_CHIP_ACTIVE_TIME_LIMITED = -10033;
    /**
     * -10034:（-208）芯片（所属厂商）存于黑名单
     */
    public final static int ACTIVATE_ERROR_CHIP_IN_BLACKLIST = -10034;


    public static String getErrorInfo(int errorCode) {
        return "[" + errorCode + "]" + ":" + getErrorInfo(errorCode);
    }

    /**
     * 得到错误信息提示
     *
     * @param errorCode [in]错误代码
     * @return
     */
    private static String getErrorInfo_pri(int errorCode) {
        String errorInfo = "";
        switch (errorCode) {
            case JNIAPI.XKR_OK:
                errorInfo = "成功";
                break;
            case XKR_PWD_1:
            case XKR_PWD_2:
            case XKR_PWD_3:
            case XKR_PWD_4:
            case XKR_PWD_5:
            case XKR_PWD_6:
            case XKR_PWD_7:
            case XKR_PWD_8:
            case XKR_PWD_9:
                errorInfo = "还有" + (errorCode - JNIAPI.XKR_BASE) + "次重试机会";
                break;

            case JNIAPI.XKR_NO_HANDLE:
                errorInfo = "指定的句柄不存在";
                break;
            case JNIAPI.XKR_IO_FAILED:
                errorInfo = "通过卡接口收发数据失败";
                break;
            case JNIAPI.XKR_BACK_LENGTH:
                errorInfo = "返回数据之长度错误";
                break;
            case JNIAPI.XKR_BACK_DATA:
                errorInfo = "返回数据错误";
                break;
            case JNIAPI.XKR_RESET_FAILED:
                errorInfo = "卡重置失败";
                break;
            case JNIAPI.XKR_NO_ROLE:
                errorInfo = "指定的角色不存在";
                break;
            case JNIAPI.XKR_DATAIN_SIZE:
                errorInfo = "输入数据的长度不合适";
                break;
            case JNIAPI.XKR_OUTBUF_SIZE:
                errorInfo = "指定的数据接收缓冲区大小不合适";
                break;
            case JNIAPI.XKR_INVALID_PARA:
                errorInfo = "接口参数错误";
                break;
            case JNIAPI.XKR_PASSWORD:
                errorInfo = "安全芯片PIN码错误";
                break;
            case JNIAPI.XKR_EEPROM_WRITE:
                errorInfo = "EEPROM写入错误";
                break;
            case JNIAPI.XKR_PARAMETER:
                errorInfo = "COS指令参数错误";
                break;
            case JNIAPI.XKR_CMD_NOTMATCH_LINE:
                errorInfo = "命令与线路保护不适应";
                break;
            case JNIAPI.XKR_CMD_NOTMATCH_FAT:
                errorInfo = "命令与文件结构不相容";
                break;
            case JNIAPI.XKR_NO_POWER:
                errorInfo = "权限不够";
                break;
            case JNIAPI.XKR_KEY_LOCKED:
                errorInfo = "密钥被锁死";
                break;
            case JNIAPI.XKR_DATA_PARAMETER:
                errorInfo = "数据域参数错误";
                break;
            case JNIAPI.XKR_APP_LOCKED:
                errorInfo = "应用锁定";
                break;
            case JNIAPI.XKR_FILE_NOT_EXIST:
                errorInfo = "文件不存在";
                break;
            case JNIAPI.XKR_NO_FILE_SPACE:
                errorInfo = "文件无足够空间";
                break;
            case JNIAPI.XKR_NOT_GET_RANDOM:
                errorInfo = "未取随机数";
                break;
            case JNIAPI.XKR_FILE_EXIST:
                errorInfo = "文件已存在";
                break;
            case JNIAPI.XKR_FILE_CONTENT:
                errorInfo = "文件内容错误";
                break;
            case JNIAPI.XKR_WRONG_STATE:
                errorInfo = "错误的状态";
                break;
            case JNIAPI.XKR_CARD_LOCKED:
                errorInfo = "卡锁定";
                break;
            case JNIAPI.XKR_WRONG_LE:
                errorInfo = "Le错误";
                break;
            case JNIAPI.XKR_NO_THIS_CMD:
                errorInfo = "命令不存在";
                break;
            case JNIAPI.XKR_INVALID_DATA:
                errorInfo = "数据无效";
                break;
            case JNIAPI.XKR_WRONG_MAC:
                errorInfo = "MAC错误";
                break;
            case JNIAPI.XKR_KEYFILE_NOT_EXIST:
                errorInfo = "密钥文件不存在";
                break;
            case JNIAPI.XKR_KEY_NOT_EXIST:
                errorInfo = "密钥不存在";
                break;
            case JNIAPI.XKR_WRONG_KEY_TYPE:
                errorInfo = "密钥类型不对";
                break;
            case JNIAPI.XKR_BAD_PUBKEY:
                errorInfo = "返回公钥内容格式不对";
                break;
            case JNIAPI.XKR_HASH_FAILED:
                errorInfo = "HASH运算失败";
                break;
            case JNIAPI.XKR_RSAPUBLIC_FAILED:
                errorInfo = "RSA 公钥运算失败";
                break;
            case JNIAPI.XKR_BAD_PRIKEY:
                errorInfo = "返回私钥内容格式不对";
                break;
            case JNIAPI.XKR_SIGN_CONFIRM:
                errorInfo = "等待用户签名确认";
                break;
            case JNIAPI.XKR_SIGN_CANCEL:
                errorInfo = "用户签名确认取消";
                break;
            case JNIAPI.XKR_CONDITION:
                errorInfo = "使用条件不满足";
                break;
            case JNIAPI.XKR_DECRYPT_FAIL:
                errorInfo = "解密失败";
                break;
            case JNIAPI.XKR_NOT_FIND_DATA:
                errorInfo = "文件偏移地址超出，即未找到数据";
                break;
            case JNIAPI.XKR_DGI_NOT_SUPPORT:
                errorInfo = "DGI不支持";
                break;
            case JNIAPI.XKR_DATA_NOCORRENT:
                errorInfo = "安全报文数据对象不正确";
                break;
            case JNIAPI.XKR_EXAUTH_FAIL:
                errorInfo = "外部认证失败";
                break;
            case JNIAPI.XKR_RSA_NOT_FIND:
                errorInfo = "RSA密钥未找到";
                break;
            case JNIAPI.XKR_TLOCK_FAILD:
                errorInfo = "创建事务锁失败";
                break;
            case JNIAPI.XKR_TLOCK_TIMEOUT:
                errorInfo = "事务锁超时";
                break;
            case JNIAPI.XKR_BAD_CERT:
                errorInfo = "证书内容错误";
                break;
            case JNIAPI.XKR_SIGN_VERIFY:
                errorInfo = "签名验证失败";
                break;
            case JNIAPI.XKR_GETMOUNTPATH_FAILD:
                errorInfo = "获取盘符/挂载路径失败";
                break;
            case JNIAPI.XKR_MALLOC_FALID:
                errorInfo = "内存申请失败";
                break;
            case JNIAPI.XKR_NO_KEY:
                errorInfo = "未插入安全卡";
                break;
            case JNIAPI.XKR_NOT_SUPPORT:
                errorInfo = "暂不支持";
                break;

            default:
                errorInfo = "错误[" + String.format("%d", errorCode) + "]";
                break;
        }

        return errorInfo;
    }
}