package com.xdja.multi.unitepin.jar;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Pair;
import android.widget.Toast;

import com.xdja.jar.forcallprovider.ForCallProvider;
import com.xdja.multichip.IMultiChipUnitePin;

/**
 * Created by xwy on 2017/6/21.
 */

public class MultiChipUnitePinManager {

    public final int OK = 0;
    /**
     * 失败
     */
    public final int FAIL = -60004;

    /**
     * 获取BUNDLE失败
     */
    public final int BUNDLE_ERROR = -60005;

    /**
     * 得到实例
     *
     * @return 返回实例
     */
    public static MultiChipUnitePinManager getInstance() {
        return Single.instance;
    }

    static class Single {
        private static MultiChipUnitePinManager instance = new MultiChipUnitePinManager();
    }

    /**
     * 得到安全口令。
     *
     * @param context 上下文
     * @param cardId  卡号
     * @param role    角色
     * @return Pair.first为错误码，当为0时second有效
     * Pair.second为安全口令
     */
    public Pair<Integer, String> getPin(Context context, String cardId, int role) {
        String pin = null;
        int ret = FAIL;
        try {
            Bundle bundle = getBinder(context).getPin(cardId, role);
            if (bundle == null) {
                return Pair.create(BUNDLE_ERROR, null);
            }
            ret = bundle.getInt("ret", -1);
            if (ret != OK) {
                return Pair.create(ret, null);
            }
            pin = bundle.getString("pin", null);
        } catch (Exception e) {
            ret = handleException(e);
        }
        return Pair.create(ret, pin);
    }

    /**
     * 发送验证PIN码的广播给芯片管家
     *
     * @param context
     * @param cardId
     * @param role
     */
    public void sendVerifyPinBroadcast(Context context, String cardId, int role) {
        Intent intent = new Intent();
        intent.setPackage("com.xdja.safekeyservice");
        intent.setAction("com.xdja.safekeyservice.soc_oper");
        intent.putExtra("method_name", "method_verify_pin");
        intent.putExtra("call_app_name", context.getPackageName());
        intent.putExtra("cardId", cardId);
        intent.putExtra("role", role);
        context.sendBroadcast(intent);
    }

    public void toast(Context context,String msg) {
        Message message = Message.obtain();
        message.what = CODE_SHOW_TOAST;
        message.obj = Pair.create(context,msg);
        getHandler().sendMessage(message);
    }

    private synchronized static Handler getHandler() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper()) {
                @Override
                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    if (msg.what == CODE_SHOW_TOAST) {
                        Pair<Context,String> pair = (Pair<Context, String>) msg.obj;
                        Toast.makeText(pair.first, pair.second, Toast.LENGTH_LONG).show();
                    }
                }
            };
        }
        return handler;
    }

    private static final int CODE_SHOW_TOAST = 1;
    private static Handler handler = null;

    private int handleException(Exception e) {
        e.printStackTrace();
        return FAIL;
    }

    /**
     * 解锁/重置PIN码业务，获取USN
     *
     * @param context 上下文环境
     * @param cardId  芯片id
     * @return Pair.first为错误码，当为0时second有效；Pair.second usn
     */
    public Pair<Integer, String> getUsn(Context context, String cardId) {
        String usn = "";
        int ret = FAIL;

        if (context != null && !TextUtils.isEmpty(cardId)) {
            try {
                Bundle bundle = getBinder(context).getUsn(cardId);
                if (bundle == null) {
                    return Pair.create(BUNDLE_ERROR, null);
                }

                ret = bundle.getInt("ret", FAIL);
                if (ret != OK) {
                    return Pair.create(ret, null);
                }

                usn = bundle.getString("usn", "");

            } catch (Exception e) {
                ret = handleException(e);
            }
        }

        return Pair.create(ret, usn);
    }


    IMultiChipUnitePin multiUnitePin = null;

    /**
     * 获取卡管理主进程Binder
     *
     * @param context
     * @return
     */
    private IMultiChipUnitePin getBinder(Context context) {
        if (multiUnitePin != null) {
            return multiUnitePin;
        }

        ContentResolver contentResolver = context.getContentResolver();
        Uri uri = getUri(context);
        if (uri == null) {
            return null;
        }
        String arg = "MultiChipUnitePinBinder";
        Bundle bundle = contentResolver.call(uri, "GetBinder", arg, null);
        if (bundle == null) {
            return null;
        }
        IBinder binder = bundle.getBinder("Binder");
        if (binder != null) {
            multiUnitePin = IMultiChipUnitePin.Stub.asInterface(binder);
            try {
                multiUnitePin.asBinder().linkToDeath(new IBinder.DeathRecipient() {
                    @Override
                    public void binderDied() {
                        multiUnitePin = null;
                    }
                }, Binder.FLAG_ONEWAY);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return multiUnitePin;
    }

    /**
     * 得到Uri
     *
     * @param context
     * @return
     */
    private Uri getUri(Context context) {
        return ForCallProvider.getGetProxyProviderUri(context);
    }

}
