/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multi.unitepin.jar;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Pair;
import android.widget.Toast;
import com.xdja.jar.forcallprovider.ForCallProvider;
import com.xdja.multichip.IMultiChipUnitePin;

public class MultiChipUnitePinManager {
    public final int OK = 0;
    public final int FAIL = -60004;
    public final int BUNDLE_ERROR = -60005;
    private static final int CODE_SHOW_TOAST = 1;
    private static Handler handler = null;
    IMultiChipUnitePin multiUnitePin = null;

    public static MultiChipUnitePinManager getInstance() {
        return Single.instance;
    }

    public Pair<Integer, String> getPin(Context context, String cardId, int role) {
        String pin = null;
        int ret = -60004;
        try {
            Bundle bundle = this.getBinder(context).getPin(cardId, role);
            if (bundle == null) {
                return Pair.create((Object)-60005, null);
            }
            ret = bundle.getInt("ret", -1);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pin = bundle.getString("pin", null);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pin);
    }

    public void sendVerifyPinBroadcast(Context context, String cardId, int role) {
        Intent intent = new Intent();
        intent.setPackage("com.xdja.safekeyservice");
        intent.setAction("com.xdja.safekeyservice.soc_oper");
        intent.putExtra("method_name", "method_verify_pin");
        intent.putExtra("call_app_name", context.getPackageName());
        intent.putExtra("cardId", cardId);
        intent.putExtra("role", role);
        context.sendBroadcast(intent);
    }

    public void toast(Context context, String msg) {
        Message message = Message.obtain();
        message.what = 1;
        message.obj = Pair.create((Object)context, (Object)msg);
        MultiChipUnitePinManager.getHandler().sendMessage(message);
    }

    private static synchronized Handler getHandler() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper()){

                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    if (msg.what == 1) {
                        Pair pair = (Pair)msg.obj;
                        Toast.makeText((Context)((Context)pair.first), (CharSequence)((CharSequence)pair.second), (int)1).show();
                    }
                }
            };
        }
        return handler;
    }

    private int handleException(Exception e) {
        e.printStackTrace();
        return -60004;
    }

    public Pair<Integer, String> getUsn(Context context, String cardId) {
        String usn = "";
        int ret = -60004;
        if (context != null && !TextUtils.isEmpty((CharSequence)cardId)) {
            try {
                Bundle bundle = this.getBinder(context).getUsn(cardId);
                if (bundle == null) {
                    return Pair.create((Object)-60005, null);
                }
                ret = bundle.getInt("ret", -60004);
                if (ret != 0) {
                    return Pair.create((Object)ret, null);
                }
                usn = bundle.getString("usn", "");
            }
            catch (Exception e) {
                ret = this.handleException(e);
            }
        }
        return Pair.create((Object)ret, (Object)usn);
    }

    private IMultiChipUnitePin getBinder(Context context) {
        if (this.multiUnitePin != null) {
            return this.multiUnitePin;
        }
        ContentResolver contentResolver = context.getContentResolver();
        Uri uri = this.getUri(context);
        if (uri == null) {
            return null;
        }
        String arg = "MultiChipUnitePinBinder";
        Bundle bundle = contentResolver.call(uri, "GetBinder", arg, null);
        if (bundle == null) {
            return null;
        }
        IBinder binder = bundle.getBinder("Binder");
        if (binder != null) {
            this.multiUnitePin = IMultiChipUnitePin.Stub.asInterface(binder);
            try {
                this.multiUnitePin.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                    public void binderDied() {
                        MultiChipUnitePinManager.this.multiUnitePin = null;
                    }
                }, 1);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return this.multiUnitePin;
    }

    private Uri getUri(Context context) {
        return ForCallProvider.getGetProxyProviderUri((Context)context);
    }

    static class Single {
        private static MultiChipUnitePinManager instance = new MultiChipUnitePinManager();

        Single() {
        }
    }
}

