package com.xdja.uniteauth.jar;

import android.os.Bundle;
import android.os.IBinder;
import android.text.TextUtils;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/7/31 <br/>
 */
class BundleHandle {


    /**
     * 组装向服务端传递的数据
     *
     * @param random
     * @param cardId
     * @param cardType
     * @param listener
     * @return
     */
    static Bundle getBundleForGetAuthCode(String random,
                                          String cardId,
                                          int cardType,
                                          ICallbackListener listener) {
        Bundle bundle = new Bundle();
        bundle.putString(ParamKeywords.KEY_METHOD, ParamKeywords.KEY_METHOD_getAuthCode);
        bundle.putString(ParamKeywords.KEY_String_random, random);
        if (!TextUtils.isEmpty(cardId)) {
            bundle.putString(ParamKeywords.KEY_String_cardId, cardId);
        }
        if (cardType > 0) {
            bundle.putInt(ParamKeywords.KEY_int_cardType, cardType);
        }

        IBinder callbackBinder = RealCallback.create(listener).getCallbackBinder();
        bundle.putBinder(ParamKeywords.KEY_Binder_callbackBinder, callbackBinder);
        return bundle;
    }

}
