package com.xdja.uniteauth.jar;

import android.net.Uri;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/7/31 <br/>
 */
public class ErrorCode {
    /**
     * 异常
     */
    public static final int RET_EXCEPTION = -1;

    /**
     * 不支持；<br>
     * 表示现在使用的jar包版本过低，统一认证Binder Server端不再支持。
     */
    public static final int RET_NOT_SUPPORT = -2;

    /**
     * 没有此方法；<br>
     * 表示jar调用的方法，在统一认证Binder Server端没有实现；
     * 通常是jar包版本和BinderServer端版本不匹配引起的错误。
     */
    public static final int RET_NO_SUCH_METHOD = -3;

    /**
     * 不能调用到统一认证Binder服务端所在的apk。<br>
     * 一般有几种情况：<br>
     * 1. 统一认证Binder服务端所在的apk没有安装；<br>
     * 2. apk安装了，但因为关联启动的问题，apk不能被调起；<br>
     * 3. apk安装了，但apk中没有统一认证的功能；
     * <p>
     * 注：统一认证Binder服务端在芯片管家中。
     * 但如果创建 {@link UniteAuth} 时调用了
     * {@link com.xdja.uniteauth.jar.UniteAuth.Builder#baseUri(Uri)} 方法，
     * 表明统一认证Binder服务端在Uri所指向的应用。
     */
    public static final int RET_CANNOT_CALL_SERVER = -4;

    /**
     * 没有权限调用。<br>
     * 一般是因为，调用统一认证服务端时，没有通过Jar包中封装的ContentProvider的方式，
     * 获取调用统一认证服务端的binder代理。
     */
    public static final int RET_NO_POWER = -5;

    /**
     * 验证Token文件失败。<br>
     * 一般有几种情况：
     * 1. 没有应用没有放Token文件，或者没有把Token文件放到指定位置（应该在apk的assets/token.pro）
     * 2. 应用放的Token文件跟应用在开放平台申请的Token文件不一致
     * 3. 应用放的Token文件被篡改了
     */
    public static final int RET_FAIL_VERIFY_TOKEN = -6;

    /**
     * 应用包名和Token文件中的包名不匹配
     */
    public static final int RET_FAIL_VERIFY_PKG_MISMATCH = -7;


    /**
     * 服务端验签失败。<br>
     * 应用未在开发平台注册
     */
    public static final int RET_FAIL_VERIFY_NO_SUCH_PKG = -8;


    /**
     * 服务端验签失败。<br>
     * 应用签名跟注册时不一致。
     */
    public static final int RET_FAIL_VERIFY_SIGN_MISMATCH = -9;

    /**
     * 网络异常
     */
    public static final int RET_EXCEPTION_NETWORK = -10;

    /**
     * 请求网络超时
     */
    public static final int RET_TIMEOUT_REQUEST_SERVER = -11;

    /**
     * 不支持的卡类型
     */
    public static final int RET_NOT_SUPPORT_CARDTYPE = -12;


//    统一认证界面错误码，从-100开始，绝对值递加
    /**
     * 获取统一认证码失败-通用错误<br>
     * 此错误码出现的原因可能有：
     * 1. 用户直接返回；
     * 2. 用户点击了界面上的 忘记PIN码
     */
    public static final int RET_GET_UAC_CODE_FAIL = -100;

    /**
     * 调用界面传入的关键参数为空;
     */
    public static final int RET_KEY_PARAM_NULL = -103;
    /**
     * 调用者app信息获取为空<br>
     */
    public static final int RET_CALL_APP_INFO_GET_NULL = -104;
    /**
     * 尝试打开芯片失败，可能没有芯片
     */
    public static final int RET_OPEN_SAFE_CHIP_FAIL = -105;
    /**
     * 获取芯片证书失败
     */
    public static final int RET_GET_CERT_SN_FAIL = -106;
    /**
     * 服务器返回错误
     */
    public static final int RET_SERVER_RETURN_ERR = -107;

    /**
     * 验证PIN码错误
     */
    public static final int RET_VERIFY_SAFE_PIN_ERR = -109;
    /**
     * 挑战值签名失败
     */
    public static final int RET_CHALLENGE_SIGN_FAIL = -110;
    /**
     * appid为空
     */
    public static final int RET_APP_ID_NULL = -111;
    /**
     * PIN码输入为空
     */
    public static final int RET_INPUT_PIN_NULL = -112;
    /**
     * 点击忘记PIN码
     */
    public static final int RET_CLICK_RESET_PIN = -113;
}
