package com.xdja.uniteauth.jar;

import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/7/31 <br/>
 * 真正跟Binder服务端交互的类
 */
class RealCallback extends IRealCallback.Stub {
    private ICallbackListener listener;


    RealCallback(ICallbackListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.listener = listener;
    }

    /**
     * 创建
     *
     * @param listener
     * @return
     */
    public static RealCallback create(ICallbackListener listener) {
        return new RealCallback(listener);
    }

    /**
     * 获取回调Binder
     *
     * @return
     */
    public IBinder getCallbackBinder() {
        return this.asBinder();
    }

    @Override
    public void callback(String randomStr, int ret, String authCode, String extra) throws RemoteException {
        Message msg = Message.obtain();
        ReplyBean bean = new ReplyBean();
        bean.random = randomStr;
        bean.ret = ret;
        bean.authCode = authCode;
        bean.extra = extra;
        msg.obj = bean;
        handler.sendMessage(msg);
    }

    private Handler handler = new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (listener != null) {
                ReplyBean bean = (ReplyBean) msg.obj;
                listener.callback(bean.random, bean.ret, bean.authCode, bean.extra);
            }
        }
    };

    class ReplyBean {
        String random;
        int ret;
        String authCode;
        String extra;
    }

}
