/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.crypto;

import android.text.TextUtils;
import android.util.Pair;
import com.xdja.xdjacrypto.SM2PrivateKey;
import com.xdja.xdjacrypto.SM2PublicKey;
import com.xdja.xdjacrypto.SM2Signature;
import com.xdja.xdjacrypto.XCT_CERT_INFO;
import com.xdja.xdjacrypto.XDJA_RSA_PRIKEY;
import com.xdja.xdjacrypto.XDJA_RSA_PUBKEY;
import com.xdja.xdjacrypto.XdjaCrypto;
import com.xdja.xdjacrypto.oct_string;
import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class XDJACrypto {
    private static XDJACrypto mInstance;
    private XdjaCrypto crypto = null;
    private long[] hHandle = new long[2];
    private final String version = "1.0.3100";
    public static final byte FLAG_PKCS1_PADDING_1 = 1;
    public static final byte FLAG_PKCS1_PADDING_2 = 2;

    public String getVersion() {
        return "1.0.3100";
    }

    private XDJACrypto() {
        this.crypto = new XdjaCrypto();
    }

    public XDJACrypto(String name) {
        this.crypto = new XdjaCrypto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XDJACrypto getInstance() {
        if (mInstance != null) return mInstance;
        Class<XDJACrypto> clazz = XDJACrypto.class;
        synchronized (XDJACrypto.class) {
            if (mInstance != null) return mInstance;
            mInstance = new XDJACrypto();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public int SM2Signature(SM2PublicKey pub, SM2PrivateKey priv, byte[] message, int mlen, SM2Signature value) {
        return this.crypto.SM2Signature(pub, priv, message, mlen, value);
    }

    public int SM2Verify(SM2PublicKey pub, byte[] message, int mlen, SM2Signature value) {
        return this.crypto.SM2Verify(pub, message, mlen, value);
    }

    public int SM2PublicEncrypt(SM2PublicKey pub, byte[] from, int flen, byte[] to, int[] tlen) {
        return this.crypto.SM2PublicEncrypt(pub, from, flen, to, tlen);
    }

    public int SM2PublicEncryptGM(SM2PublicKey pub, byte[] from, int flen, byte[] to, int[] tlen) {
        return this.crypto.SM2PublicEncryptGM(pub, from, flen, to, tlen);
    }

    public int SM2PrivateDecrypt(SM2PrivateKey priv, byte[] from, int flen, byte[] to, int[] tlen) {
        return this.crypto.SM2PrivateDecrypt(priv, from, flen, to, tlen);
    }

    public int SM2PrivateDecryptGM(SM2PrivateKey priv, byte[] from, int flen, byte[] to, int[] tlen) {
        return this.crypto.SM2PrivateDecryptGM(priv, from, flen, to, tlen);
    }

    public int SM2ExchangeRandom(SM2PublicKey tpub, SM2PrivateKey tpriv) {
        return this.crypto.SM2ExchangeRandom(tpub, tpriv);
    }

    public int SM2ExchangeCale(SM2PrivateKey mytpriv, SM2PublicKey mytpub, SM2PublicKey peertpub, SM2PublicKey mypub, SM2PrivateKey mypriv, SM2PublicKey peerpub, int keylen, int role, byte[] key, oct_string hash) {
        return this.crypto.SM2ExchangeCale(mytpriv, mytpub, peertpub, mypub, mypriv, peerpub, keylen, role, key, hash);
    }

    public boolean SM2ExchangeVerify(oct_string s1, oct_string s2) {
        return this.crypto.SM2ExchangeVerify(s1, s2);
    }

    public int SHA1Init(long[] hHandle) {
        return this.crypto.SHA1Init(hHandle);
    }

    public int SHA1Update(long handle, byte[] datain, int in_len) {
        return this.crypto.SHA1Update(handle, datain, in_len);
    }

    public int SHA1Final(long handle, byte[] dataout) {
        return this.crypto.SHA1Final(handle, dataout);
    }

    public int SM3Init() {
        if (this.hHandle == null) {
            this.hHandle = new long[2];
        }
        return this.crypto.SM3Init(this.hHandle);
    }

    public int SM3Update(byte[] datain, int in_len) {
        return this.crypto.SM3Update(this.hHandle[0], datain, in_len);
    }

    public int SM3Final(byte[] dataout) {
        int ret = this.crypto.SM3Final(this.hHandle[0], dataout);
        this.hHandle = null;
        return ret;
    }

    public int RSAPubKeyCalc(byte[] in, int inLen, XDJA_RSA_PUBKEY pubKey, byte[] out, int[] outLen) {
        return this.crypto.XCF_RSAPubKeyCalc(in, inLen, pubKey, out, outLen);
    }

    public int RSAPriKeyCalc(byte[] in, int inLen, XDJA_RSA_PRIKEY priKey, byte[] out, int[] outLen) {
        return this.crypto.XCF_RSAPriKeyCalc(in, inLen, priKey, out, outLen);
    }

    public int genRSAKeyPair(int bits, XDJA_RSA_PUBKEY pubKey, XDJA_RSA_PRIKEY priKey) {
        return this.crypto.XCF_GenRSAKeyPair(bits, pubKey, priKey);
    }

    public Pair<Integer, byte[]> RSASignWITHSHA1(XDJA_RSA_PRIKEY priKey, byte[] dataIn) {
        long[] handle = new long[1];
        int ret = this.SHA1Init(handle);
        if (ret != 0) {
            return Pair.create((Object)ret, null);
        }
        ret = this.SHA1Update(handle[0], dataIn, dataIn.length);
        if (ret != 0) {
            return Pair.create((Object)ret, null);
        }
        byte[] sha1Out = new byte[20];
        ret = this.SHA1Final(handle[0], sha1Out);
        if (ret != 0) {
            return Pair.create((Object)ret, null);
        }
        byte[] pcksOut = new byte[priKey.bits / 8];
        ret = this.PKCS1Padding(sha1Out, sha1Out.length, (byte)1, priKey.bits, pcksOut);
        if (ret != 0) {
            return Pair.create((Object)ret, null);
        }
        byte[] calcOut = new byte[pcksOut.length];
        int[] outLen = new int[1];
        ret = this.RSAPriKeyCalc(pcksOut, pcksOut.length, priKey, calcOut, outLen);
        return Pair.create((Object)ret, (Object)Arrays.copyOfRange(calcOut, 0, outLen[0]));
    }

    public int RSASignVerifyWITHSHA1(XDJA_RSA_PUBKEY pubKey, byte[] dataIn, byte[] signData) {
        byte[] calcOut = new byte[signData.length];
        int[] calcOutLen = new int[1];
        int ret = this.RSAPubKeyCalc(signData, signData.length, pubKey, calcOut, calcOutLen);
        if (ret != 0) {
            return ret;
        }
        long[] handle = new long[1];
        ret = this.SHA1Init(handle);
        if (ret != 0) {
            return ret;
        }
        ret = this.SHA1Update(handle[0], dataIn, dataIn.length);
        if (ret != 0) {
            return ret;
        }
        byte[] sha1Out = new byte[20];
        ret = this.SHA1Final(handle[0], sha1Out);
        if (ret != 0) {
            return ret;
        }
        byte[] pcksOut = new byte[pubKey.bits / 8];
        ret = this.PKCS1Padding(sha1Out, sha1Out.length, (byte)1, pubKey.bits, pcksOut);
        if (ret != 0) {
            return ret;
        }
        if (Arrays.equals(pcksOut, calcOut)) {
            return 0;
        }
        return -1;
    }

    public int AES(byte[] tmpkey, int tmpkey_len, int mode, byte[] in, int in_len, byte[] out, byte[] iv) {
        return this.crypto.AES(tmpkey, tmpkey_len, mode, in, in_len, out, iv);
    }

    public int SM4(byte[] tmpkey, int flag, byte[] datain, int inlen, byte[] dataout, byte[] iv) {
        return this.crypto.SM4(tmpkey, flag, datain, inlen, dataout, iv);
    }

    public int SM4New(byte[] tmpkey, int flag, byte[] datain, int inlen, byte[] dataout, byte[] iv) {
        return this.crypto.SM4New(tmpkey, flag, datain, inlen, dataout, iv);
    }

    public int GetCertInfo(byte[] cert, int cert_len, XCT_CERT_INFO cert_info) {
        return this.crypto.GetCertInfo(cert, cert_len, cert_info);
    }

    public int PKCS1Padding(byte[] in, int inLen, byte version, int bits, byte[] out) {
        return this.crypto.PKCS1Padding(in, inLen, version, bits, out);
    }

    public int PKCS1UnPadding(byte[] in, int inLen, byte[] out, int[] outLen) {
        return this.crypto.PKCS1UnPadding(in, inLen, out, outLen);
    }

    private int selfGetCertInfo(byte[] certByte, int cert_len, XCT_CERT_INFO cert_info) {
        try {
            Object tmpBytes;
            block6: {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certByte, 0, cert_len));
                String issuerDN = cert.getIssuerDN().toString();
                String subjectDN = cert.getSubjectDN().toString();
                tmpBytes = this.getStr(subjectDN, "CN").getBytes();
                System.arraycopy(tmpBytes, 0, cert_info.subjectCN, 0, ((byte[])tmpBytes).length);
                System.arraycopy(subjectDN.getBytes(), 0, cert_info.subjectDN, 0, subjectDN.length());
                tmpBytes = this.getStr(subjectDN, "O").getBytes();
                System.arraycopy(tmpBytes, 0, cert_info.subjectOrg, 0, ((byte[])tmpBytes).length);
                tmpBytes = this.getStr(issuerDN, "CN").getBytes();
                System.arraycopy(tmpBytes, 0, cert_info.issuerCN, 0, ((byte[])tmpBytes).length);
                tmpBytes = this.getStr(issuerDN, "O").getBytes();
                System.arraycopy(tmpBytes, 0, cert_info.issuerOrg, 0, ((byte[])tmpBytes).length);
                tmpBytes = cert.getSerialNumber().toString(16).getBytes();
                System.arraycopy(tmpBytes, 0, cert_info.SN, 0, ((byte[])tmpBytes).length);
                tmpBytes = (cert.getNotAfter().getTime() + "").getBytes();
                System.arraycopy(tmpBytes, 0, cert_info.before, 0, ((byte[])tmpBytes).length);
                tmpBytes = (cert.getNotBefore().getTime() + "").getBytes();
                System.arraycopy(tmpBytes, 0, cert_info.after, 0, ((byte[])tmpBytes).length);
                try {
                    PublicKey publicKey = cert.getPublicKey();
                    String alg = publicKey.getAlgorithm();
                    byte[] encoded = publicKey.getEncoded();
                    tmpBytes = alg.equals("RSA") ? Arrays.copyOfRange(encoded, 22, encoded.length) : (Object)(alg.equals("1.2.840.10045.2.1") ? Arrays.copyOfRange(encoded, 26, encoded.length) : null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    byte[] rsaHeader = new byte[]{48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0};
                    int start = XDJACrypto.indexOf(certByte, rsaHeader, 0);
                    if (start > 0) {
                        tmpBytes = Arrays.copyOfRange(certByte, start += rsaHeader.length, start + 140);
                    }
                    byte[] sm2Header = new byte[]{48, 89, 48, 19, 6, 7, 42, -122, 72, -50, 61, 2, 1, 6, 8, 42, -127, 28, -49, 85, 1, -126, 45, 3, 66, 0};
                    start = XDJACrypto.indexOf(certByte, sm2Header, 0);
                    if (start <= 0) break block6;
                    tmpBytes = Arrays.copyOfRange(certByte, start += sm2Header.length, start + 65);
                }
            }
            if (tmpBytes == null) {
                return -1;
            }
            System.arraycopy(tmpBytes, 0, cert_info.pubkey, 0, ((byte[])tmpBytes).length);
            cert_info.setPubkeyLen(((byte[])tmpBytes).length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private String getStr(String str, String key) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        str = str + ",";
        int start = str.indexOf(key + "=");
        int end = str.indexOf(",", start);
        String result = str.substring(start + key.length() + 1, end);
        return result;
    }

    private static int indexOf(byte[] origin, byte[] search, int start) {
        if (origin == null || origin.length == 0 || search == null || search.length == 0) {
            return -10;
        }
        int originLen = origin.length;
        int searchLen = search.length;
        if (originLen < searchLen) {
            return -1;
        }
        if (start + searchLen > originLen) {
            return -1;
        }
        int searchStart = start;
        int result = -1;
        for (int i = searchStart; i <= originLen - searchLen; ++i) {
            int j;
            for (j = 0; j < searchLen && origin[i + j] == search[j]; ++j) {
            }
            if (j != searchLen) continue;
            result = i;
            break;
        }
        return result;
    }

    public int XCF_RSAPubKeyCalc(byte[] input, int ilen, XDJA_RSA_PUBKEY pubkey, byte[] output, int[] olen) {
        return this.crypto.XCF_RSAPubKeyCalc(input, ilen, pubkey, output, olen);
    }

    public int XCF_RSAPriKeyCalc(byte[] input, int ilen, XDJA_RSA_PRIKEY prikey, byte[] output, int[] olen) {
        return this.crypto.XCF_RSAPriKeyCalc(input, ilen, prikey, output, olen);
    }

    public int CaVerifyUerCert(byte[] cabuf, int calen, byte[] certbuf, int certlen) {
        return this.crypto.CaVerifyUerCert(cabuf, calen, certbuf, certlen);
    }
}

