/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uaac.api;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.uaac.api.CredentialCallback;
import com.xdja.uaac.api.TokenCallback;
import com.xdja.uaac.data.bean.ThirdAppInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UaacApi {
    private static final String TAG = "UaacApi";
    private static String uaacPackageName;
    private static String uaacLoginActivityName;
    private static final String TOKEN_PROVIDER_AUTHORITIES = "com.xdja.app.pj";
    private static final String TOKEN_PROVIDER_URI = "content://com.xdja.app.pj/";
    private static final String CREDENTIAL_PROVIDER_AUTHORITIES = "com.ydjw.ua.getCredential";
    private static final String CREDENTIAL_PROVIDER_URI = "content://com.ydjw.ua.getCredential";
    private static final String ACTION_TRANSPARENT_ACTIVITY = "com.xdja.uaac.action.start";
    private static final int ANDROID_10 = 29;
    private static Map<String, String> packageActivityMap;

    private UaacApi() {
    }

    public static void getToken(@NonNull Context context, @NonNull TokenCallback callback) {
        UaacApi.getToken(context, "", callback);
    }

    public static void getToken(@NonNull Context context, String packageName, @NonNull TokenCallback callback) {
        Log.d((String)TAG, (String)"getToken()");
        if (!UaacApi.isTokenProviderExist(context)) {
            callback.onError("\u7edf\u4e00\u8ba4\u8bc1\u672a\u5b89\u88c5\u6216\u7248\u672c\u8fc7\u4f4e\uff01");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            packageName = context.getPackageName();
        }
        Uri uri = Uri.parse((String)(TOKEN_PROVIDER_URI + packageName));
        ContentResolver resolver = context.getContentResolver();
        Log.d((String)TAG, (String)"Query provider 1");
        Cursor cursor = resolver.query(uri, null, null, null, null);
        if (cursor == null) {
            try {
                Log.d((String)TAG, (String)"Start transparent activity!");
                Intent intent = new Intent(ACTION_TRANSPARENT_ACTIVITY);
                if (!(context instanceof Activity)) {
                    intent.setFlags(0x10000000);
                }
                context.startActivity(intent);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getMessage());
                Log.d((String)TAG, (String)"Start transparent activity failed!");
                callback.onError("\u7edf\u4e00\u8ba4\u8bc1\u5173\u8054\u542f\u52a8\u6743\u9650\u672a\u5f00\u542f\uff01");
                return;
            }
            for (int i = 0; i < 30; ++i) {
                Log.d((String)TAG, (String)("Query provider " + (i + 2)));
                cursor = resolver.query(uri, null, null, null, null);
                if (cursor != null) {
                    UaacApi.parseCursor(context, cursor, callback, packageName);
                    return;
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            callback.onError("\u7edf\u4e00\u8ba4\u8bc1\u5173\u8054\u542f\u52a8\u6743\u9650\u672a\u5f00\u542f\uff01");
        } else {
            UaacApi.parseCursor(context, cursor, callback, packageName);
        }
    }

    private static boolean isTokenProviderExist(Context context) {
        PackageManager packageManager = context.getPackageManager();
        ProviderInfo providerInfo = packageManager.resolveContentProvider(TOKEN_PROVIDER_AUTHORITIES, 128);
        if (providerInfo == null) {
            return false;
        }
        uaacPackageName = providerInfo.applicationInfo.packageName;
        uaacLoginActivityName = packageActivityMap.get(uaacPackageName);
        Log.d((String)TAG, (String)("uaacPackageName = " + uaacPackageName));
        Log.d((String)TAG, (String)("uaacLoginActivityName = " + uaacLoginActivityName));
        return true;
    }

    public static int logoutUaac(@NonNull Context context) {
        Uri uri = Uri.parse((String)(TOKEN_PROVIDER_URI + context.getPackageName()));
        ContentResolver contentResolver = context.getContentResolver();
        int result = 0;
        try {
            result = contentResolver.delete(uri, null, null);
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }

    public static void notifyLogout(@NonNull Context context) {
        Intent intent = new Intent("com.xdja.unifyauthorize.ACTION_THIRD_APP_LOGOUT");
        intent.putExtra("PACKAGE_NAME", context.getPackageName());
        context.sendBroadcast(intent);
    }

    private static void parseCursor(Context context, Cursor cursor, TokenCallback callback, String packageName) {
        cursor.moveToFirst();
        int resultCode = cursor.getInt(cursor.getColumnIndex("resultCode"));
        if (resultCode == 0) {
            int safeClientStatus;
            String token = cursor.getString(cursor.getColumnIndex("billStr"));
            try {
                safeClientStatus = cursor.getInt(cursor.getColumnIndex("safeClientStatus"));
            }
            catch (Exception e) {
                safeClientStatus = 1;
            }
            callback.onSuccess(token, safeClientStatus == 0);
        } else {
            String message = cursor.getString(cursor.getColumnIndex("message"));
            callback.onError(message);
            if (Build.VERSION.SDK_INT >= 29 && resultCode == -5 && !context.getPackageName().equals(uaacPackageName)) {
                Log.d((String)TAG, (String)"Android 10, start login activity");
                Intent intent = new Intent();
                intent.setClassName(uaacPackageName, uaacLoginActivityName);
                intent.putExtra("third_app_package_name", packageName);
                if (!(context instanceof Activity)) {
                    intent.addFlags(0x10000000);
                }
                try {
                    context.startActivity(intent);
                }
                catch (Exception e) {
                    Log.d((String)TAG, (String)"Android 10, start login activity failed!");
                    e.printStackTrace();
                    callback.onError("\u7edf\u4e00\u8ba4\u8bc1\u767b\u5f55\u754c\u9762\u542f\u52a8\u5931\u8d25\uff01");
                }
            }
        }
        cursor.close();
    }

    public static void getCredential(Context context, String messageId, String version, String appId, String orgId, String networkAreaCode, String packageName, CredentialCallback callback) {
        Log.d((String)TAG, (String)"getCredential()");
        if (!UaacApi.isCredentialProviderExist(context)) {
            callback.onResult(UaacApi.getErrorBundle(-7, messageId));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            packageName = context.getPackageName();
        }
        ThirdAppInfo thirdAppInfo = new ThirdAppInfo();
        thirdAppInfo.setMessageId(messageId);
        thirdAppInfo.setPackageName(packageName);
        thirdAppInfo.setAppId(appId);
        thirdAppInfo.setOrgId(orgId);
        thirdAppInfo.setNetworkAreaCode(networkAreaCode);
        thirdAppInfo.setVersion(version);
        Uri uri = Uri.parse((String)CREDENTIAL_PROVIDER_URI);
        ContentResolver resolver = context.getContentResolver();
        Bundle params = new Bundle();
        params.putString("messageId", messageId);
        params.putString("version", version);
        params.putString("appId", appId);
        params.putString("orgId", orgId);
        params.putString("networkAreaCode", networkAreaCode);
        params.putString("packageName", packageName);
        try {
            Log.d((String)TAG, (String)"Call provider");
            Bundle bundle = resolver.call(uri, "", null, params);
            callback.onResult(bundle);
            int resultCode = bundle.getInt("resultCode");
            if (Build.VERSION.SDK_INT >= 29 && resultCode == -5 && !context.getPackageName().equals(uaacPackageName)) {
                Log.d((String)TAG, (String)"Android 10, start login activity");
                Intent intent = new Intent();
                intent.setClassName(uaacPackageName, uaacLoginActivityName);
                intent.putExtra("third_app_info", (Serializable)thirdAppInfo);
                if (!(context instanceof Activity)) {
                    intent.addFlags(0x10000000);
                }
                context.startActivity(intent);
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.d((String)TAG, (String)"Android 10, start login activity failed!");
            callback.onResult(UaacApi.getErrorBundle(-7, messageId));
        }
        catch (Exception e) {
            callback.onResult(UaacApi.getErrorBundle(-8, messageId));
        }
    }

    private static boolean isCredentialProviderExist(Context context) {
        PackageManager packageManager = context.getPackageManager();
        ProviderInfo providerInfo = packageManager.resolveContentProvider(CREDENTIAL_PROVIDER_AUTHORITIES, 128);
        if (providerInfo == null) {
            return false;
        }
        uaacPackageName = providerInfo.applicationInfo.packageName;
        uaacLoginActivityName = packageActivityMap.get(uaacPackageName);
        Log.d((String)TAG, (String)("uaacPackageName = " + uaacPackageName));
        Log.d((String)TAG, (String)("uaacLoginActivityName = " + uaacLoginActivityName));
        return true;
    }

    private static Bundle getErrorBundle(int errorCode, String messageId) {
        Bundle bundle = new Bundle();
        bundle.putInt("resultCode", errorCode);
        if (errorCode == -7) {
            bundle.putString("message", "\u7edf\u4e00\u8ba4\u8bc1\u672a\u5b89\u88c5\u6216\u7248\u672c\u8fc7\u4f4e\uff01");
        } else if (errorCode == -8) {
            bundle.putString("message", "\u7edf\u4e00\u8ba4\u8bc1\u5173\u8054\u542f\u52a8\u6743\u9650\u672a\u5f00\u542f\uff01");
        }
        bundle.putString("messageId", messageId);
        bundle.putString("version", "1");
        return bundle;
    }

    static {
        packageActivityMap = new HashMap<String, String>();
        packageActivityMap.put("com.xdja.uaac", "com.xdja.uaac.ui.InitActivity");
        packageActivityMap.put("com.xdja.unifyauthorize", "com.xdja.unifyauthorize.activity.LoginActivity");
        packageActivityMap.put("com.xdja.safeclient", "com.xdja.safeclient.frame.SplashActivity");
        packageActivityMap.put("com.xdja.jxclient", "com.xdja.unifyauthorize.activity.LoginActivity");
    }
}

