/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.uas.common.util.Util;
import com.xdja.uas.roam.bean.AppResourceBean;
import com.xdja.uas.roam.bean.HeaderReqBean;
import com.xdja.uas.roam.controller.RoamCommonController;
import com.xdja.uas.roam.service.AppResourceService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/v1/appResource"})
public class AppResourceController
extends RoamCommonController {
    private static final Logger logger = LoggerFactory.getLogger(AppResourceController.class);
    @Autowired
    private AppResourceService appResourceService;

    @RequestMapping(value={"/importAppRes.do"}, method={RequestMethod.POST})
    public void importAppRes(HttpServletRequest request, @RequestBody AppResourceBean[] appResources, HttpServletResponse response) {
        List<Object> result = new ArrayList();
        HeaderReqBean headerReqBean = super.analysisRequestHeader(request);
        if (headerReqBean == null) {
            super.createFailResponse(response, "20004", "analysis request header error");
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u5bfc\u5165\u5e94\u7528&\u8d44\u6e90\u6743\u9650\u63a5\u53e3\u8bf7\u6c42\u5934\u4e2d\u53c2\u6570\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)headerReqBean));
        }
        try {
            if (StringUtils.isEmpty((CharSequence)headerReqBean.getAppCredential())) {
                super.createFailResponse(response, "20009", "app bill auth fail");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
                return;
            }
            if (StringUtils.isEmpty((CharSequence)headerReqBean.getMessageId())) {
                super.createFailResponse(response, "20006", "param error");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
                return;
            }
            List<AppResourceBean> appResourceBeans = Arrays.asList(appResources);
            for (AppResourceBean appResource : appResources) {
                if (!StringUtils.isEmpty((CharSequence)appResource.getAppId()) && !StringUtils.isEmpty((CharSequence)appResource.getAppRegionalismCode()) && !StringUtils.isEmpty((CharSequence)appResource.getResourceId()) && !StringUtils.isEmpty((CharSequence)appResource.getResourceRegionalismCode())) continue;
                super.createFailResponse(response, "20006", "param error");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
                return;
            }
            result = this.appResourceService.importAppRes(appResourceBeans);
            if (!CollectionUtils.isEmpty(result)) {
                super.createFailResponse(response, "20007", "part fail");
            } else {
                super.createSuccessResponse(response);
            }
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5e94\u7528&\u8d44\u6e90\u6743\u9650\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            super.createFailResponse(response, "20005", "system error");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/syncAppResource.do"}, method={RequestMethod.POST})
    public void syncAppResource(@RequestBody String param, HttpServletResponse response, HttpServletRequest request) {
        Map<Object, Object> result = new HashMap();
        HeaderReqBean headerReqBean = super.analysisRequestHeader(request);
        if (headerReqBean == null) {
            super.createFailResponse(response, "20004", "analysis request header error");
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
            return;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u5e94\u7528&\u8d44\u6e90\u6743\u9650\u63a5\u53e3\u8bf7\u6c42\u5934\u4e2d\u53c2\u6570\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)headerReqBean));
            }
            JSONObject jsonObject = JSONObject.parseObject((String)param);
            Long lastUpdateTime = jsonObject.getLong("lastUpdateTime");
            Integer pageNo = jsonObject.getInteger("pageNo");
            Integer pageSize = jsonObject.getInteger("pageSize");
            if (lastUpdateTime == null || pageNo == null || pageSize == null) {
                super.createFailResponse(response, "20006", "param error");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
                return;
            }
            result = this.appResourceService.syncAppResource(lastUpdateTime, pageNo, pageSize);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u6743\u9650\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)Util.toJsonStr(result));
            }
            super.createSuccessResponse(response);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528&\u8d44\u6e90\u6743\u9650\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            super.createFailResponse(response, "20005", "system error");
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }
}

