/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.agreement.config.SystemConfig;
import com.xdja.uas.common.bean.Result;
import com.xdja.uas.common.util.MessageManager;
import com.xdja.uas.common.util.Util;
import com.xdja.uas.roam.service.AppRoamService;
import com.xdja.uas.sso.bean.PersonAppPowerBean;
import com.xdja.uas.sso.entity.PersonAppPower;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AppRoamController {
    private static final Logger log = LoggerFactory.getLogger(AppRoamController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private AppRoamService appRoamService;

    @RequestMapping(value={"/empower/appRoamController/applyPower.do"})
    public void applyPower(@RequestBody PersonAppPowerBean bean, HttpServletResponse response) {
        log.debug("\u4f20\u9012\u8fc7\u6765\u7684\u6743\u9650\u7533\u8bf7\u53c2\u6570\uff1a{}", (Object)Util.toJsonStr((Object)bean));
        Result result = new Result();
        try {
            if (Util.varCheckEmp((String)bean.getAppDivisionCode()) || Util.varCheckEmp((String)bean.getAppDivisionName()) || Util.varCheckEmp((String)bean.getToken()) && Util.varCheckEmp((String)bean.getPersonId()) || Util.varCheckEmp((String)bean.getAppPackageName()) || Util.varCheckEmp((String)bean.getAppName()) || Util.varCheckEmp((String)bean.getAppId())) {
                result.setFlag("1");
                result.setMessage("\u53c2\u6570\u9519\u8bef");
            } else {
                result = this.appRoamService.applyPower(bean);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setFlag("4");
            result.setMessage(e.getMessage());
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)result));
    }

    @RequestMapping(value={"/empower/appRoamController/list.do"})
    public void list(HttpServletResponse response, PersonAppPowerBean personAppPowerBean) {
        Map<Object, Object> result = new HashMap<String, String>();
        try {
            if (personAppPowerBean.getPage() == null || personAppPowerBean.getRows() == null) {
                result.put("flag", "1");
                result.put("message", "\u53c2\u6570\u9519\u8bef");
            } else {
                result = this.appRoamService.list(personAppPowerBean);
                result.put("flag", "0");
                result.put("message", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
            }
        }
        catch (Exception e) {
            result.put("flag", "1");
            result.put("message", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/empower/appRoamController/getAppPowerByState.do"})
    public void getPassAppByAreaCode(@RequestBody String param, String personId, String appDivisionCode, String state, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (!Util.varCheckEmp((String)param)) {
                JSONObject jsonObject = JSON.parseObject((String)param);
                personId = jsonObject.getString("personId");
                appDivisionCode = jsonObject.getString("appDivisionCode");
                state = jsonObject.getString("state");
            }
            if (Util.varCheckEmp((String)appDivisionCode)) {
                result.put("flag", "1");
                result.put("message", "\u8bf7\u4f20\u5165\u5730\u533a\u7f16\u7801");
                Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
                return;
            }
            List<PersonAppPower> appsList = this.appRoamService.listPersonAppPower(personId, SystemConfig.getInstance().getString("application.roam.area.code"), appDivisionCode, state);
            if (appsList != null) {
                ArrayList apps = new ArrayList();
                for (PersonAppPower pap : appsList) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("appId", pap.getAppId());
                    map.put("state", pap.getState());
                    apps.add(map);
                }
                result.put("limits", apps);
                result.put("flag", "0");
            }
        }
        catch (Exception e) {
            result.put("flag", "1");
            result.put("message", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/empower/appRoamController/changePower.do"})
    public void changePower(@RequestBody String param, HttpServletResponse response) {
        Result result = new Result();
        try {
            if (Util.varCheckEmp((String)param)) {
                result.setFlag("0");
                result.setMessage("\u53c2\u6570\u5f02\u5e38");
                Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)result));
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)param);
            String appId = jsonObject.getString("appId");
            String personId = jsonObject.getString("personId");
            String personAreaCode = jsonObject.getString("personDivisionCode");
            String appAreaCode = jsonObject.getString("appDivisionCode");
            String type = jsonObject.getString("type");
            String sourceAreaCode = jsonObject.getString("sourceAreaCode");
            if (Util.varCheckEmp((String)appId) || Util.varCheckEmp((String)personId) || Util.varCheckEmp((String)personAreaCode) || Util.varCheckEmp((String)appAreaCode) || Util.varCheckEmp((String)type)) {
                result.setFlag("0");
                result.setMessage(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"app.roam.power.param.error"));
                Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)result));
                return;
            }
            result = this.appRoamService.changePower(personId, personAreaCode, appId, appAreaCode, type, sourceAreaCode);
            Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)result));
        }
        catch (Exception e) {
            result = new Result("1", e.getMessage(), null);
            Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)result));
        }
    }

    @RequestMapping(value={"/empower/appRoamController/applyPowerStatus.do"})
    public void applyPowerStatus(@RequestBody String param, HttpServletResponse response) {
        Result result = new Result();
        try {
            if (Util.varCheckEmp((String)param)) {
                result.setFlag("0");
                result.setMessage("\u53c2\u6570\u5f02\u5e38");
                Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)result));
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)param);
            String appId = jsonObject.getString("appId");
            String personId = jsonObject.getString("personId");
            String personAreaCode = jsonObject.getString("personDivisionCode");
            String appAreaCode = jsonObject.getString("appDivisionCode");
            String type = jsonObject.getString("type");
            String sourceAreaCode = jsonObject.getString("sourceAreaCode");
            if (Util.varCheckEmp((String)appId) || Util.varCheckEmp((String)personId) || Util.varCheckEmp((String)personAreaCode) || Util.varCheckEmp((String)appAreaCode) || Util.varCheckEmp((String)type)) {
                result.setFlag("0");
                result.setMessage(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"app.roam.power.param.error"));
                Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)result));
                return;
            }
            result = this.appRoamService.applyPowerStatus(personId, personAreaCode, appId, appAreaCode, type, sourceAreaCode);
            Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)result));
        }
        catch (Exception e) {
            result = new Result("1", e.getMessage(), null);
            Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)result));
        }
    }

    @RequestMapping(value={"/empower/appRoamController/getDivisionCode.do"})
    public void getDivisionCode(HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", SystemConfig.getInstance().getString("application.roam.area.code"));
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }
}

