/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.uas.common.util.Util;
import com.xdja.uas.roam.bean.AuthBean;
import com.xdja.uas.roam.bean.HeaderReqBean;
import com.xdja.uas.roam.bean.HeaderResBean;
import com.xdja.uas.roam.bean.UserAppPower;
import com.xdja.uas.roam.bean.UserListOfAppReqBean;
import com.xdja.uas.roam.bean.UserListOfAppResBean;
import com.xdja.uas.roam.entity.RoamAppUseArea;
import com.xdja.uas.roam.exception.RoamException;
import com.xdja.uas.roam.service.AuthUserAppService;
import com.xdja.uas.roam.service.RoamAppAuthService;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/v1/authUserAppController/"})
public class AuthUserAppController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthUserAppController.class);
    @Autowired
    private AuthUserAppService authUserAppService;
    @Autowired
    private RoamAppAuthService roamAppAuthService;

    @RequestMapping(value={"/authUserApp.do"}, method={RequestMethod.POST})
    public void authUserApp(@RequestBody AuthBean authBean, HttpServletRequest request, HttpServletResponse response) {
        HeaderReqBean headerReqBean = null;
        HeaderResBean headerResBean = new HeaderResBean();
        String code = "0";
        String message = "success";
        try {
            headerReqBean = HeaderReqBean.getBeanByRequest(request);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u83b7\u53d6header\u53c2\u6570\u9519\u8bef", (Throwable)e);
            code = "20008";
            message = "user bill auth fail";
            headerResBean.setCode(code);
            headerResBean.setMessage(message);
            HeaderResBean.setResponseByBean(response, headerResBean);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("authUserAPP()\uff0c headerReqBean\uff1a{}", (Object)JSON.toJSONString((Object)headerReqBean));
            LOGGER.debug("authUserAPP()\uff0c authBean\uff1a{}", (Object)JSON.toJSONString((Object)authBean));
        }
        String messageId = headerReqBean.getMessageId();
        headerResBean.setMessageId(messageId);
        try {
            String userCredential = headerReqBean.getUserCredential();
            if (null == userCredential || StringUtils.isEmpty((CharSequence)userCredential)) {
                code = "20008";
                message = "user bill auth fail";
                headerResBean.setCode(code);
                headerResBean.setMessage(message);
                HeaderResBean.setResponseByBean(response, headerResBean);
                Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
                return;
            }
            String personId = authBean.getPersonId();
            String personRegionalismCode = authBean.getPersonRegionalismCode();
            String appId = authBean.getAppId();
            String appRegionalismCode = authBean.getAppRegionalismCode();
            String appNetworkCode = authBean.getNetworkAreaCode();
            String appPackage = authBean.getAppPackage();
            if (StringUtils.isBlank((CharSequence)personId) || StringUtils.isBlank((CharSequence)personRegionalismCode) || StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)appRegionalismCode)) {
                code = "20006";
                message = "param error";
                headerResBean.setCode(code);
                headerResBean.setMessage(message);
                HeaderResBean.setResponseByBean(response, headerResBean);
                Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
                return;
            }
            boolean checkResult = this.authUserAppService.authPersonAppPower(personId, personRegionalismCode, appId, appRegionalismCode, appNetworkCode, appPackage, userCredential);
            if (checkResult) {
                headerResBean.setCode(code);
                headerResBean.setMessage(message);
                HeaderResBean.setResponseByBean(response, headerResBean);
            } else {
                code = "20001";
                message = "no power";
                headerResBean.setCode(code);
                headerResBean.setMessage(message);
                HeaderResBean.setResponseByBean(response, headerResBean);
            }
        }
        catch (RoamException e) {
            LOGGER.error(e.getMessage());
            code = "20004";
            message = "other error";
            headerResBean.setCode(code);
            headerResBean.setMessage(message);
            HeaderResBean.setResponseByBean(response, headerResBean);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            code = "20005";
            message = "system error";
            headerResBean.setCode(code);
            headerResBean.setMessage(message);
            HeaderResBean.setResponseByBean(response, headerResBean);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("authUserAPP()\uff0c headerResBean\uff1a{}", (Object)JSON.toJSONString((Object)headerResBean));
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
    }

    @RequestMapping(value={"/getUserListOfApp.do"}, method={RequestMethod.POST})
    public void getUserListOfApp(@RequestBody UserListOfAppReqBean userListOfAppReqBean, HttpServletRequest request, HttpServletResponse response) {
        MDC.put((String)"MSGID", (String)Util.getUUID());
        HeaderReqBean headerReqBean = null;
        HeaderResBean headerResBean = new HeaderResBean();
        String code = "0";
        String message = "success";
        try {
            headerReqBean = HeaderReqBean.getBeanByRequest(request);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u83b7\u53d6header\u53c2\u6570\u9519\u8bef", (Throwable)e);
            code = "20008";
            message = "user bill auth fail";
            headerResBean.setCode(code);
            headerResBean.setMessage(message);
            HeaderResBean.setResponseByBean(response, headerResBean);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getUserListOfApp()\uff0c headerReqBean\uff1a{}", (Object)JSON.toJSONString((Object)headerReqBean));
            LOGGER.debug("getUserListOfApp()\uff0c userListOfAppReqBean\uff1a{}", (Object)JSON.toJSONString((Object)userListOfAppReqBean));
        }
        String messageId = headerReqBean.getMessageId();
        headerResBean.setMessageId(messageId);
        UserListOfAppResBean userListOfAppResBean = new UserListOfAppResBean();
        try {
            String appCredential = headerReqBean.getAppCredential();
            if (null == appCredential || StringUtils.isEmpty((CharSequence)appCredential)) {
                code = "20009";
                message = "app bill auth fail";
                headerResBean.setCode(code);
                headerResBean.setMessage(message);
                HeaderResBean.setResponseByBean(response, headerResBean);
                Util.writeUtf8JSON((HttpServletResponse)response, (String)JSON.toJSONString((Object)userListOfAppResBean));
                return;
            }
            String appId = userListOfAppReqBean.getAppId();
            String appRegionalismCode = userListOfAppReqBean.getAppRegionalismCode();
            Integer pageNo = userListOfAppReqBean.getPageNo();
            Integer pageSize = userListOfAppReqBean.getPageSize();
            if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)appRegionalismCode)) {
                code = "20006";
                message = "param error";
                headerResBean.setCode(code);
                headerResBean.setMessage(message);
                HeaderResBean.setResponseByBean(response, headerResBean);
                Util.writeUtf8JSON((HttpServletResponse)response, (String)JSON.toJSONString((Object)userListOfAppResBean));
                return;
            }
            userListOfAppResBean = this.authUserAppService.queryPersonInfos(appId, appRegionalismCode, pageNo, pageSize);
            headerResBean.setCode(code);
            headerResBean.setMessage(message);
            HeaderResBean.setResponseByBean(response, headerResBean);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            code = "20005";
            message = "system error";
            headerResBean.setCode(code);
            headerResBean.setMessage(message);
            HeaderResBean.setResponseByBean(response, headerResBean);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getUserListOfApp()\uff0c headerResBean\uff1a{}", (Object)JSON.toJSONString((Object)headerResBean));
            LOGGER.debug("getUserListOfApp()\uff0c userListOfAppResBean\uff1a{}", (Object)JSON.toJSONString((Object)userListOfAppResBean));
        }
        MDC.remove((String)"MSGID");
        Util.writeUtf8JSON((HttpServletResponse)response, (String)JSON.toJSONString((Object)userListOfAppResBean));
    }

    @RequestMapping(value={"/applyUserPower.do"}, method={RequestMethod.POST})
    public void applyAppPower(@RequestBody String param, HttpServletResponse response, HttpServletRequest request) {
        HeaderReqBean headerReqBean = null;
        HeaderResBean headerResBean = new HeaderResBean();
        try {
            headerReqBean = HeaderReqBean.getBeanByRequest(request);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u83b7\u53d6header\u53c2\u6570\u9519\u8bef", (Throwable)e);
            headerResBean.setCode("20008");
            headerResBean.setMessage("user bill auth fail");
            HeaderResBean.setResponseByBean(response, headerResBean);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("------>\u5e94\u7528\u6743\u9650\u7533\u8bf7\u63a5\u53e3\u8bf7\u6c42header\u4e2d\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)headerReqBean));
            LOGGER.debug("------>\u5e94\u7528\u6743\u9650\u7533\u8bf7\u63a5\u53e3\u8bf7\u6c42body\u4e2d\u53c2\u6570\uff1a{}", (Object)param);
        }
        try {
            String messageId = headerReqBean.getMessageId();
            String appCredential = headerReqBean.getAppCredential();
            if (Util.varCheckEmp((String)appCredential)) {
                headerResBean.setCode("20009");
                headerResBean.setMessage("app bill auth fail");
                HeaderResBean.setResponseByBean(response, headerResBean);
                Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
                return;
            }
            if (Util.varCheckEmp((String)param) || Util.varCheckEmp((String)messageId)) {
                headerResBean.setCode("20006");
                headerResBean.setMessage("param error");
            } else {
                headerResBean.setMessageId(messageId);
                List appPowerList = JSON.parseArray((String)param, UserAppPower.class);
                this.authUserAppService.applyAppPower(appPowerList);
                headerResBean.setCode("0");
                headerResBean.setMessage("success");
            }
        }
        catch (RoamException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            headerResBean.setCode(e.getCode());
            headerResBean.setMessage(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            headerResBean.setCode("20005");
            headerResBean.setMessage("system error");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("<------\u5e94\u7528\u6743\u9650\u7533\u8bf7\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)headerResBean));
        }
        HeaderResBean.setResponseByBean(response, headerResBean);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
    }

    @RequestMapping(value={"/getUserAppPower.do"})
    public void getAppPowerOfPerson(@RequestBody String param, HttpServletResponse response, HttpServletRequest request) {
        MDC.put((String)"MSGID", (String)Util.getUUID());
        HeaderReqBean headerReqBean = null;
        HeaderResBean headerResBean = new HeaderResBean();
        try {
            headerReqBean = HeaderReqBean.getBeanByRequest(request);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u83b7\u53d6header\u53c2\u6570\u9519\u8bef", (Throwable)e);
            headerResBean.setCode("20004");
            headerResBean.setMessage("analysis request header error");
            HeaderResBean.setResponseByBean(response, headerResBean);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("------>\u83b7\u53d6\u7528\u6237\u7684\u5e94\u7528\u5217\u8868\u63a5\u53e3\u8bf7\u6c42header\u4e2d\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)headerReqBean));
            LOGGER.debug("------>\u83b7\u53d6\u7528\u6237\u7684\u5e94\u7528\u5217\u8868\u63a5\u53e3\u8bf7\u6c42body\u4e2d\u53c2\u6570\uff1a{}", (Object)param);
        }
        String messageId = headerReqBean.getMessageId();
        String appCredential = headerReqBean.getAppCredential();
        String userCredential = headerReqBean.getUserCredential();
        if (Util.varCheckEmp((String)appCredential)) {
            headerResBean.setCode("20009");
            headerResBean.setMessage("app bill auth fail");
            HeaderResBean.setResponseByBean(response, headerResBean);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
            return;
        }
        if (Util.varCheckEmp((String)userCredential)) {
            headerResBean.setCode("20008");
            headerResBean.setMessage("user bill auth fail");
            HeaderResBean.setResponseByBean(response, headerResBean);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
            return;
        }
        if (Util.varCheckEmp((String)param) || Util.varCheckEmp((String)messageId)) {
            headerResBean.setCode("20006");
            headerResBean.setMessage("param error");
            HeaderResBean.setResponseByBean(response, headerResBean);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
            return;
        }
        ArrayList apps = new ArrayList();
        try {
            JSONObject jsonObject = JSON.parseObject((String)param);
            String personId = jsonObject.getString("personId");
            if (Util.varCheckEmp((String)personId)) {
                headerResBean.setMessage("param error");
                headerResBean.setCode("20006");
                HeaderResBean.setResponseByBean(response, headerResBean);
                Util.writeUtf8JSON((HttpServletResponse)response, (String)"");
                return;
            }
            String appRegionalismCode = jsonObject.getString("appRegionalismCode");
            List<RoamAppUseArea> list = StringUtils.isNotBlank((CharSequence)appRegionalismCode) ? this.roamAppAuthService.getPersonAppIds(personId, appRegionalismCode) : this.roamAppAuthService.getPersonAllAppIds(personId);
            if (list != null) {
                Collections.sort(list, new Comparator<RoamAppUseArea>(){

                    @Override
                    public int compare(RoamAppUseArea o1, RoamAppUseArea o2) {
                        return AuthUserAppController.this.compareString(o1.getAppId(), o2.getAppId());
                    }
                });
                if (StringUtils.isNotBlank((CharSequence)appRegionalismCode)) {
                    for (RoamAppUseArea pap : list) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("appId", pap.getAppId());
                        map.put("appRegionalismCode", appRegionalismCode);
                        apps.add(map);
                    }
                } else {
                    for (RoamAppUseArea pap : list) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("appId", pap.getAppId());
                        map.put("appRegionalismCode", pap.getAppRegionalismCode());
                        apps.add(map);
                    }
                }
            }
            headerResBean.setCode("0");
            headerResBean.setMessage("success");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            headerResBean.setCode("20005");
            headerResBean.setMessage("system error");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("<------\u83b7\u53d6\u7528\u6237\u7684\u5e94\u7528\u5217\u8868\u63a5\u53e3\u54cd\u5e94\u5934\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)headerResBean));
            LOGGER.debug("<------\u83b7\u53d6\u7528\u6237\u7684\u5e94\u7528\u5217\u8868\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(apps));
        }
        HeaderResBean.setResponseByBean(response, headerResBean);
        MDC.remove((String)"MSGID");
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(apps));
    }

    private int compareString(String s1, String s2) {
        char[] chars2;
        int len2;
        char[] chars1 = s1.toCharArray();
        int len1 = chars1.length;
        int a = len1 - (len2 = (chars2 = s2.toCharArray()).length);
        if (a != 0) {
            return a;
        }
        for (int i = 0; i < len1; ++i) {
            int b = chars1[i] - chars2[i];
            if (b == 0) continue;
            return b;
        }
        return 0;
    }
}

