/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.controller;

import com.alibaba.fastjson.JSON;
import com.xdja.uas.roam.bean.HeaderCredential;
import com.xdja.uas.roam.bean.HeaderReqBean;
import com.xdja.uas.roam.bean.IdentifyAppInfo;
import com.xdja.uas.roam.bean.IdentifyPersonInfo;
import com.xdja.uas.roam.bean.PersonInfoBean;
import com.xdja.uas.roam.controller.RoamCommonController;
import com.xdja.uas.roam.exception.RoamException;
import com.xdja.uas.roam.service.IdentifyService;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/v1/identifyController"})
public class IdentifyController
extends RoamCommonController {
    @Autowired
    private IdentifyService identifyService;
    private static final Logger logger = LoggerFactory.getLogger(IdentifyController.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"/indentifyUserCredential.do"}, method={RequestMethod.POST})
    public IdentifyPersonInfo indentifyUserCredential(HttpServletRequest request, HttpServletResponse response, @RequestBody Map<String, String> param) {
        HeaderReqBean headerReqBean = null;
        try {
            headerReqBean = HeaderReqBean.getBeanByRequest(request);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u83b7\u53d6header\u53c2\u6570\u9519\u8bef", (Object)JSON.toJSONString((Object)headerReqBean));
            super.createFailResopnse(response, headerReqBean, "10006", "\u51ed\u8bc1\u683c\u5f0f\u9519\u8bef");
            return null;
        }
        logger.debug("indentifyUserCredential()\uff0c headerReqBean\uff1a{}", (Object)JSON.toJSONString((Object)headerReqBean));
        HeaderCredential headerCredential = (HeaderCredential)JSON.parseObject((String)headerReqBean.getUserCredential(), HeaderCredential.class);
        String backInfo = "0";
        if (param != null) {
            backInfo = param.get("backInfo");
        }
        if (!"0".equals(backInfo) && !"1".equals(backInfo)) {
            backInfo = "0";
        }
        IdentifyPersonInfo identifyPersonInfo = null;
        try {
            identifyPersonInfo = this.identifyService.indentifyUserCredential(headerCredential.getCredential(), backInfo);
            logger.debug("\u7528\u6237\u51ed\u8bc1\u9a8c\u8bc1\u901a\u8fc7\uff0c\u7528\u6237\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)identifyPersonInfo));
            super.createSuccessResopnse(response, headerReqBean);
        }
        catch (RoamException e) {
            logger.error("\u7528\u6237\u7968\u636e\u9a8c\u8bc1\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            super.createFailResopnse(response, headerReqBean, e.getCode(), e.getMessage());
        }
        finally {
            return identifyPersonInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"/indentifyAppCredential.do"}, method={RequestMethod.POST})
    public IdentifyAppInfo indentifyAppCredential(HttpServletRequest request, HttpServletResponse response, @RequestBody Map<String, String> param) {
        HeaderReqBean headerReqBean = null;
        try {
            headerReqBean = HeaderReqBean.getBeanByRequest(request);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u83b7\u53d6header\u53c2\u6570\u9519\u8bef", (Object)JSON.toJSONString((Object)headerReqBean));
            super.createFailResopnse(response, headerReqBean, "10006", "\u51ed\u8bc1\u683c\u5f0f\u9519\u8bef");
            return null;
        }
        logger.debug("indentifyAppCredential()\uff0c headerReqBean\uff1a{}", (Object)JSON.toJSONString((Object)headerReqBean));
        String backInfo = "0";
        if (param != null) {
            backInfo = param.get("backInfo");
        }
        if (!"0".equals(backInfo) && !"1".equals(backInfo)) {
            backInfo = "0";
        }
        HeaderCredential userHeaderCredential = (HeaderCredential)JSON.parseObject((String)headerReqBean.getUserCredential(), HeaderCredential.class);
        HeaderCredential appHeaderCredential = (HeaderCredential)JSON.parseObject((String)headerReqBean.getAppCredential(), HeaderCredential.class);
        IdentifyAppInfo identifyAppInfo = null;
        try {
            identifyAppInfo = this.identifyService.indentifyAppCredential(userHeaderCredential.getCredential(), appHeaderCredential.getCredential(), backInfo);
            logger.debug("\u5e94\u7528\u51ed\u8bc1\u9a8c\u8bc1\u901a\u8fc7\uff0c\u5e94\u7528\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString((Object)identifyAppInfo));
            super.createSuccessResopnse(response, headerReqBean);
        }
        catch (RoamException e) {
            logger.error("\u5e94\u7528\u7968\u636e\u9a8c\u8bc1\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            super.createFailResopnse(response, headerReqBean, e.getCode(), e.getMessage());
        }
        finally {
            return identifyAppInfo;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/getCertificate.do"}, method={RequestMethod.POST})
    public Map<String, String> getCertificate(HttpServletRequest request, HttpServletResponse response, @RequestBody Map<String, String> param) {
        HeaderReqBean headerReqBean = null;
        try {
            headerReqBean = HeaderReqBean.getBeanByRequest(request);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u83b7\u53d6header\u53c2\u6570\u9519\u8bef", (Object)JSON.toJSONString((Object)headerReqBean));
            super.createFailResopnse(response, headerReqBean, "10006", "\u51ed\u8bc1\u683c\u5f0f\u9519\u8bef");
            return null;
        }
        logger.debug("getCertificate()\uff0c param\uff1a{}", (Object)JSON.toJSONString(param));
        String fromRegionalismCode = param.get("fromRegionalismCode");
        if (param == null || StringUtils.isBlank((CharSequence)fromRegionalismCode)) {
            logger.error("\u7ec4\u7ec7\u673a\u6784\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            super.createFailResopnse(response, headerReqBean, "10006", "\u5e94\u7528\u51ed\u8bc1\u4e3a\u7a7a");
            return null;
        }
        String certificate = null;
        try {
            certificate = this.identifyService.getCertificate(fromRegionalismCode);
        }
        catch (RoamException e) {
            logger.error("\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            super.createFailResopnse(response, headerReqBean, e.getCode(), e.getMessage());
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("certificate", certificate);
        logger.debug("\u83b7\u53d6\u8bc1\u4e66\u7ed3\u679c\u4e3a,map:{}", (Object)JSON.toJSONString(map));
        super.createSuccessResopnse(response, headerReqBean);
        return map;
    }

    @ResponseBody
    @RequestMapping(value={"/getPersonInfo.do"}, method={RequestMethod.POST})
    public PersonInfoBean getPersonInfo(HttpServletRequest request, HttpServletResponse response, @RequestBody Map<String, String> param) {
        HeaderReqBean headerReqBean = null;
        try {
            headerReqBean = HeaderReqBean.getBeanByRequest(request);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u83b7\u53d6header\u53c2\u6570\u9519\u8bef", (Object)JSON.toJSONString((Object)headerReqBean));
            super.createFailResopnse(response, headerReqBean, "10006", "\u51ed\u8bc1\u683c\u5f0f\u9519\u8bef");
            return null;
        }
        logger.debug("getPersonInfo()\uff0c param\uff1a{}", (Object)JSON.toJSONString(param));
        String personId = param.get("personId");
        String personRegionalismCode = param.get("personRegionalismCode");
        if (headerReqBean.getAppCredential() == null || param == null || StringUtils.isBlank((CharSequence)personId) || StringUtils.isBlank((CharSequence)personRegionalismCode)) {
            logger.error("\u5165\u53c2\uff1a\u5e94\u7528\u51ed\u8bc1\u3001\u7528\u6237id\u548c\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
            super.createFailResopnse(response, headerReqBean, "10006", "\u5165\u53c2\u5e94\u7528\u51ed\u8bc1\u3001\u7528\u6237id\u548c\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        PersonInfoBean personInfoBean = null;
        try {
            personInfoBean = this.identifyService.getPersonInfo(headerReqBean.getAppCredential(), personRegionalismCode, personId);
        }
        catch (RoamException e) {
            logger.error("\u83b7\u53d6\u5e94\u7528\u8be6\u60c5\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            super.createFailResopnse(response, headerReqBean, e.getCode(), e.getMessage());
            return null;
        }
        super.createSuccessResopnse(response, headerReqBean);
        return personInfoBean;
    }
}

