/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.uas.common.bean.RestfulQuery;
import com.xdja.uas.common.bean.RestfulResult;
import com.xdja.uas.common.util.Util;
import com.xdja.uas.roam.bean.RoamAppAuthInfo;
import com.xdja.uas.roam.entity.RoamAppUseArea;
import com.xdja.uas.roam.service.RoamAppAuthService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class RoamAppAuthManagerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoamAppAuthManagerController.class);
    @Autowired
    private RoamAppAuthService roamAppAuthService;

    @RequestMapping(value={"/roamAppAuth/applyPower.do"})
    public void appAuthPowerApply(@RequestBody String param, HttpServletResponse response) {
        RestfulQuery query = RestfulQuery.getInstace((String)param, RoamAppAuthInfo.class);
        String version = query.getVersion();
        LOGGER.info("\u5e94\u7528\u6743\u9650\u53d8\u66f4\u7248\u672c:{}", (Object)version);
        RestfulResult restfulResult = new RestfulResult();
        restfulResult.setMessageId(query.getMessageId());
        restfulResult.setVersion(query.getVersion());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            RoamAppAuthInfo appAuthInfo = (RoamAppAuthInfo)query.getParameter();
            this.roamAppAuthService.appAuthChange(query.getVersion(), appAuthInfo);
            restfulResult.setCode("200");
            restfulResult.setMessage("\u64cd\u4f5c\u6210\u529f");
            map.put("code", "1");
            map.put("message", "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            map.put("code", "0");
            if (e instanceof IllegalArgumentException) {
                restfulResult.setCode("400");
            } else {
                restfulResult.setCode("500");
            }
            map.put("message", e.getMessage());
            restfulResult.setMessage("\u5e94\u7528\u6743\u9650\u53d8\u66f4\u5931\u8d25: " + e.getMessage());
            LOGGER.error("\u5e94\u7528\u6743\u9650\u53d8\u66f4\u5931\u8d25:{}", (Object)e.getMessage());
        }
        restfulResult.setData(map);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr((Object)restfulResult));
    }

    @RequestMapping(value={"/roamAppAuth/getAuthedPerson.do"})
    public void getAuthedPersonId(@RequestBody String param, HttpServletResponse response) {
        RestfulQuery query = RestfulQuery.getInstace((String)param, RoamAppAuthInfo.class);
        String version = query.getVersion();
        LOGGER.info("\u83b7\u53d6\u5df2\u6388\u6743\u4eba\u5458\u4fe1\u606f\u7248\u672c:{}", (Object)version);
        RestfulResult restfulResult = new RestfulResult();
        restfulResult.setMessageId(query.getMessageId());
        restfulResult.setVersion(query.getVersion());
        try {
            List<String> list = this.roamAppAuthService.getAuthedPerson(version, (RoamAppAuthInfo)query.getParameter());
            restfulResult.setCode("200");
            restfulResult.setMessage("\u64cd\u4f5c\u6210\u529f");
            restfulResult.setData(list);
        }
        catch (Exception e) {
            restfulResult.setCode("500");
            LOGGER.error("\u83b7\u53d6\u5df2\u6388\u6743\u4eba\u5458id\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr((Object)restfulResult));
    }

    @RequestMapping(value={"/roamAppAuth/getAppPowerByState.do"})
    public void getAppPowerOfPerson(@RequestBody String param, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Assert.hasText((String)param, (String)"\u53c2\u6570\u5f02\u5e38");
            JSONObject jsonObject = JSON.parseObject((String)param);
            String personId = jsonObject.getString("personId");
            String appDivisionCode = jsonObject.getString("appDivisionCode");
            String state = jsonObject.getString("state");
            if (Util.varCheckEmp((String)appDivisionCode)) {
                result.put("flag", "1");
                result.put("message", "\u8bf7\u4f20\u5165\u5730\u533a\u7f16\u7801");
                Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
                return;
            }
            List<RoamAppUseArea> list = this.roamAppAuthService.getPersonAppIds(personId, appDivisionCode);
            if (list != null) {
                Collections.sort(list, new Comparator<RoamAppUseArea>(){

                    @Override
                    public int compare(RoamAppUseArea o1, RoamAppUseArea o2) {
                        return RoamAppAuthManagerController.this.compareString(o1.getAppId(), o2.getAppId());
                    }
                });
                ArrayList apps = new ArrayList();
                for (RoamAppUseArea pap : list) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("appId", pap.getAppId());
                    map.put("state", "1");
                    apps.add(map);
                }
                result.put("limits", apps);
                result.put("flag", "0");
            }
        }
        catch (Exception e) {
            result.put("flag", "1");
            result.put("message", e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    private int compareString(String s1, String s2) {
        char[] chars2;
        int len2;
        char[] chars1 = s1.toCharArray();
        int len1 = chars1.length;
        int a = len1 - (len2 = (chars2 = s2.toCharArray()).length);
        if (a != 0) {
            return a;
        }
        for (int i = 0; i < len1; ++i) {
            int b = chars1[i] - chars2[i];
            if (b == 0) continue;
            return b;
        }
        return 0;
    }
}

