/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.controller;

import com.xdja.uas.roam.bean.HeaderReqBean;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RoamCommonController {
    private static final Logger logger = LoggerFactory.getLogger(RoamCommonController.class);

    public void createSuccessResopnse(HttpServletResponse response, HeaderReqBean headerReqBean) {
        response.setHeader("messageId", headerReqBean.getMessageId());
        response.setHeader("code", "0");
    }

    public void createSuccessResponse(HttpServletResponse response) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        if (request != null && response != null) {
            String messageId = request.getHeader("messageId");
            if (StringUtils.isNotBlank((CharSequence)messageId)) {
                response.setHeader("messageId", messageId);
            }
            response.setHeader("code", "0");
            response.setHeader("message", "success");
            logger.debug("\u54cd\u5e94\u5934\u5185\u5bb9--->messageId\uff1a{}\uff0ccode\uff1a{}", (Object)messageId, (Object)"0");
        }
    }

    public void createFailResopnse(HttpServletResponse response, HeaderReqBean headerReqBean, String code, String message) {
        response.setHeader("messageId", headerReqBean.getMessageId());
        response.setHeader("code", code);
        try {
            if (StringUtils.isNotBlank((CharSequence)message)) {
                message = URLEncoder.encode(message, "utf-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u5bf9\u9519\u8bef\u4fe1\u606f:{},encode\u7f16\u7801\u9519\u8bef{}", (Object)message, (Object)e.getMessage());
        }
        response.setHeader("message", message);
        logger.debug("\u54cd\u5e94\u5934\u5185\u5bb9--->messageId\uff1a{}\uff0ccode\uff1a{}\uff0cmessage\uff1a" + message, (Object)headerReqBean.getMessageId(), (Object)code);
    }

    public void createFailResponse(HttpServletResponse response, String code, String message) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        if (request != null && response != null) {
            String messageId = request.getHeader("messageId");
            if (StringUtils.isNotBlank((CharSequence)messageId)) {
                response.setHeader("messageId", messageId);
            }
            if (StringUtils.isNotBlank((CharSequence)message)) {
                response.setHeader("message", message);
            }
            response.setHeader("code", String.valueOf(code));
            logger.debug("\u54cd\u5e94\u5934\u5185\u5bb9--->messageId\uff1a{}\uff0ccode\uff1a{}\uff0cmessage\uff1a" + message, (Object)messageId, (Object)code);
        }
    }

    public HeaderReqBean analysisRequestHeader(HttpServletRequest request) {
        HeaderReqBean requestBean = null;
        try {
            requestBean = HeaderReqBean.getBeanByRequest(request);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u89e3\u6790\u8bf7\u6c42\u5934\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return requestBean;
    }
}

