/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.uas.common.bean.RestfulQuery;
import com.xdja.uas.common.bean.RestfulResult;
import com.xdja.uas.common.util.Util;
import com.xdja.uas.roam.bean.Credential;
import com.xdja.uas.roam.bean.CredentialBean;
import com.xdja.uas.roam.exception.RoamException;
import com.xdja.uas.roam.service.RoamService;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/roamController"})
public class RoamController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoamController.class);
    @Autowired
    private RoamService roamService;

    @RequestMapping(value={"/getUserCredential.do"}, method={RequestMethod.POST})
    public void createUserCredential(@RequestBody String param, HttpServletResponse response) {
        RestfulResult restfulResult;
        HashMap<String, Object> result = new HashMap<String, Object>();
        RestfulQuery restfulQuery = RestfulQuery.getInstace((String)param, CredentialBean.class);
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("----->\u521b\u5efa\u7528\u6237\u51ed\u8bc1\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)restfulQuery));
            }
            if ((restfulResult = this.checkParam(restfulQuery)) != null) {
                Util.writeUtf8JSON((HttpServletResponse)response, (String)JSON.toJSONString((Object)restfulResult));
                return;
            }
            String version = restfulQuery.getVersion();
            CredentialBean parameter = (CredentialBean)restfulQuery.getParameter();
            String code = parameter.getCode();
            String imei = parameter.getImei();
            String imsi = parameter.getImsi();
            String cardId = parameter.getCardId();
            if (StringUtils.isBlank((CharSequence)code)) {
                restfulResult = RestfulResult.failResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"500", (String)"error parameter");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)JSON.toJSONString((Object)restfulResult));
                return;
            }
            Credential credential = this.roamService.createUserCredential(code, imei, imsi, cardId, version);
            result.put("code", "0");
            result.put("message", "success");
            result.put("credential", credential);
            restfulResult = RestfulResult.successResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"success", result);
        }
        catch (RoamException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            result.put("code", e.getCode());
            result.put("message", e.getMessage());
            restfulResult = RestfulResult.failResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"500", (String)e.getMessage(), result);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            restfulResult = RestfulResult.failResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"500", (String)"\u7cfb\u7edf\u5f02\u5e38");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("<-----\u521b\u5efa\u7528\u6237\u51ed\u8bc1\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restfulResult));
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)JSON.toJSONString((Object)restfulResult));
    }

    @RequestMapping(value={"/getAppCredential.do"}, method={RequestMethod.POST})
    public void createAppCredential(@RequestBody String param, HttpServletResponse response) {
        RestfulResult restfulResult;
        HashMap<String, Object> result = new HashMap<String, Object>();
        RestfulQuery restfulQuery = (RestfulQuery)JSON.parseObject((String)param, RestfulQuery.class);
        try {
            JSONObject jsonObject = (JSONObject)restfulQuery.getParameter();
            String userCredential = String.valueOf(jsonObject.get((Object)"userCredential"));
            userCredential = URLDecoder.decode(userCredential, "utf-8");
            Credential credential = (Credential)JSON.parseObject((String)userCredential, Credential.class);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("----->\u521b\u5efa\u5e94\u7528\u51ed\u8bc1\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)restfulQuery));
            }
            if ((restfulResult = this.checkParam(restfulQuery)) != null) {
                Util.writeUtf8JSON((HttpServletResponse)response, (String)JSON.toJSONString((Object)restfulResult));
                return;
            }
            String version = restfulQuery.getVersion();
            String appRegionalismCode = jsonObject.getString("appRegionalismCode");
            String appId = jsonObject.getString("appId");
            String appNetworkCode = jsonObject.getString("appNetworkCode");
            String appPackage = jsonObject.getString("appPackage");
            if (userCredential == null || StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)appRegionalismCode) || StringUtils.isBlank((CharSequence)appNetworkCode)) {
                restfulResult = RestfulResult.failResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"500", (String)"error parameter");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)JSON.toJSONString((Object)restfulResult));
                return;
            }
            Credential appCredential = this.roamService.createAppCredential(credential, appId, appRegionalismCode, appNetworkCode, appPackage, version);
            result.put("message", "success");
            result.put("code", "0");
            result.put("credential", appCredential);
            restfulResult = RestfulResult.successResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"success", result);
        }
        catch (RoamException e) {
            LOGGER.error("\u83b7\u53d6\u5e94\u7528\u51ed\u8bc1\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            result.put("message", e.getMessage());
            result.put("code", e.getCode());
            restfulResult = RestfulResult.failResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"500", (String)e.getMessage(), result);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5e94\u7528\u51ed\u8bc1\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            restfulResult = RestfulResult.failResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"500", (String)"\u7cfb\u7edf\u5f02\u5e38");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("<-----\u521b\u5efa\u5e94\u7528\u51ed\u8bc1\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restfulResult));
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)JSON.toJSONString((Object)restfulResult));
    }

    @RequestMapping(value={"/authUserAPP.do"}, method={RequestMethod.POST})
    public void authUserApp(@RequestBody String param, HttpServletResponse response) {
        RestfulResult restfulResult;
        HashMap<String, String> result = new HashMap<String, String>();
        RestfulQuery restfulQuery = RestfulQuery.getInstace((String)param, JSONObject.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("----->\u7528\u6237\u5e94\u7528\u9274\u6743\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)restfulQuery));
        }
        try {
            restfulResult = this.checkParam(restfulQuery);
            if (restfulResult != null) {
                Util.writeUtf8JSON((HttpServletResponse)response, (String)JSON.toJSONString((Object)restfulResult));
                return;
            }
            String version = restfulQuery.getVersion();
            JSONObject parameter = (JSONObject)restfulQuery.getParameter();
            String personId = parameter.getString("personId");
            String personRegionalismCode = parameter.getString("personRegionalismCode");
            String appId = parameter.getString("appId");
            String appRegionalismCode = parameter.getString("appRegionalismCode");
            String appNetworkCode = parameter.getString("appNetworkCode");
            String appPackage = parameter.getString("appPackage");
            if (StringUtils.isBlank((CharSequence)personId) || StringUtils.isBlank((CharSequence)personRegionalismCode) || StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)appRegionalismCode) || StringUtils.isBlank((CharSequence)appNetworkCode) || StringUtils.isBlank((CharSequence)appPackage)) {
                restfulResult = RestfulResult.failResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"500", (String)"error parameter");
                Util.writeUtf8JSON((HttpServletResponse)response, (String)JSON.toJSONString((Object)restfulResult));
                return;
            }
            boolean checkResult = this.roamService.authPersonAppPower(personId, personRegionalismCode, appId, appRegionalismCode, appNetworkCode, appPackage, version);
            if (checkResult) {
                result.put("code", "0");
                result.put("message", "\u9274\u6743\u901a\u8fc7");
                restfulResult = RestfulResult.successResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"ok", result);
            } else {
                result.put("code", "1");
                result.put("message", "\u9274\u6743\u672a\u901a\u8fc7");
                restfulResult = RestfulResult.failResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"500", (String)"\u9274\u6743\u672a\u901a\u8fc7", result);
            }
        }
        catch (RoamException e) {
            result.put("code", e.getCode());
            result.put("message", e.getMessage());
            restfulResult = RestfulResult.failResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"500", (String)e.getMessage(), result);
        }
        catch (Exception e) {
            result.put("code", "2");
            result.put("message", "\u7cfb\u7edf\u5f02\u5e38");
            restfulResult = RestfulResult.failResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"500", (String)"\u7cfb\u7edf\u5f02\u5e38");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("<-----\u7528\u6237\u5e94\u7528\u9274\u6743\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restfulResult));
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)JSON.toJSONString((Object)restfulResult));
    }

    private RestfulResult checkParam(RestfulQuery restfulQuery) {
        if (restfulQuery == null) {
            return RestfulResult.failResult(null, null, (String)"500", (String)"error parameter");
        }
        if (restfulQuery.getParameter() == null) {
            return RestfulResult.failResult((String)restfulQuery.getMessageId(), (String)restfulQuery.getVersion(), (String)"500", (String)"error parameter");
        }
        return null;
    }
}

