/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.dao.impl;

import com.xdja.uas.common.basedao.BaseDao;
import com.xdja.uas.common.util.Page;
import com.xdja.uas.common.util.Util;
import com.xdja.uas.roam.dao.AppPowerApproveDao;
import com.xdja.uas.sso.bean.PersonAppPowerBean;
import com.xdja.uas.sso.entity.PersonAppPower;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class AppPowerApproveDaoImpl
implements AppPowerApproveDao {
    @Autowired
    private BaseDao baseDao;
    private static final Logger log = LoggerFactory.getLogger(AppPowerApproveDaoImpl.class);

    @Override
    public List<PersonAppPower> query(PersonAppPowerBean personAppPowerBean, Page page) {
        StringBuilder hql = new StringBuilder();
        hql.append("from PersonAppPower where state <>'3'");
        ArrayList<String> param = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)personAppPowerBean.getId())) {
            hql.append(" and id = ? ");
            param.add(personAppPowerBean.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)personAppPowerBean.getAppId())) {
            hql.append(" and appId = ? ");
            param.add(personAppPowerBean.getAppId());
        }
        if (StringUtils.isNotBlank((CharSequence)personAppPowerBean.getPersonId())) {
            hql.append(" and personId = ? ");
            param.add(personAppPowerBean.getPersonId());
        }
        if (StringUtils.isNotBlank((CharSequence)personAppPowerBean.getPersonDivisionCode())) {
            hql.append(" and personDivisionCode = ? ");
            param.add(personAppPowerBean.getPersonDivisionCode());
        }
        if (StringUtils.isNotBlank((CharSequence)personAppPowerBean.getAppDivisionCode())) {
            hql.append(" and appDivisionCode = ? ");
            param.add(personAppPowerBean.getAppDivisionCode());
        }
        if (StringUtils.isNotBlank((CharSequence)personAppPowerBean.getState())) {
            hql.append(" and state = ? ");
            param.add(personAppPowerBean.getState());
        }
        String orderBy = "order by createTime desc,id desc";
        return this.baseDao.getListByHQL("select count(*) " + hql, hql.toString() + orderBy, param.toArray(), page);
    }

    @Override
    public boolean checkAuth(String personId, String personAreaCode, String appFlag, String appAreaCode) {
        String hql = "from PersonAppPower where personId = ? and personDivisionCode = ? and appPackageName = ? and appDivisionCode  = ? and state = '1'";
        return this.baseDao.getObjectByHQL(hql, new Object[]{personId, personAreaCode, appFlag, appAreaCode}) != null;
    }

    @Override
    public List<PersonAppPower> list(String personId, String personAreaCode, String appAreaCode, String state) {
        if (Util.varCheckEmp((String)state)) {
            String hql = "from PersonAppPower where personId = ? and personDivisionCode = ? and appDivisionCode  = ?";
            return this.baseDao.getListByHQL(hql, new Object[]{personId, personAreaCode, appAreaCode});
        }
        String hql = "from PersonAppPower where personId = ? and personDivisionCode = ? and appDivisionCode  = ? and state = ?";
        return this.baseDao.getListByHQL(hql, new Object[]{personId, personAreaCode, appAreaCode, state});
    }

    @Override
    public void changePower(String personId, String personAreaCode, String appId, String appAreaCode, String state) {
        String sql = "update T_PERSON_APP_POWER set state = ? where app_id = ? and person_id = ? and app_division_code = ? and person_division_code = ? and state <> '3' and state <> '2' ";
        this.baseDao.updateBySql(sql, new Object[]{state, appId, personId, appAreaCode, personAreaCode});
    }

    @Override
    public boolean checkIsExist(PersonAppPower power) {
        String hql = "from PersonAppPower where personId = ? and personDivisionCode = ? and appId = ? and appDivisionCode  = ? and (state = '0' or state = '1') ";
        return this.baseDao.getObjectByHQL(hql, new Object[]{power.getPersonId(), power.getPersonDivisionCode(), power.getAppId(), power.getAppDivisionCode()}) != null;
    }

    @Override
    public boolean checkAuth(String personId, String personAreaCode, String packageName) {
        String hql = "from PersonAppPower where personId = ? and personDivisionCode = ? and appPackageName = ? and state = '1'";
        List personAppPowerList = this.baseDao.getListByHQL(hql, new Object[]{personId, personAreaCode, packageName});
        return !CollectionUtils.isEmpty((Collection)personAppPowerList);
    }

    @Override
    public List<String> queryAppFlag(String packageName) {
        String sql = "select app_flag from T_PERSON_APP_POWER where app_package_name = ? and state = '1' ";
        return this.baseDao.getListBySQL(sql, new Object[]{packageName}, null);
    }

    @Override
    public void deleteAppUseAreaNotExist(String localDivisionCode, String personId, String appId, String type) {
        String sql;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(localDivisionCode);
        paramList.add(localDivisionCode);
        if ("person".equals(type)) {
            sql = "update T_PERSON_APP_POWER set state = '3' where id in (select t.id from T_PERSON_APP_POWER t where t.app_division_code = ?  and t.person_division_code = ? and t.person_id = ? and t.state = '1' and  t.app_id not in(select a.app_id from t_app_use_area a where a.type = 'person' and a.area_id = ?))";
            paramList.add(personId);
            paramList.add(personId);
        } else {
            sql = "update t_person_app_power set state = '3' where  id in ( select t.id from t_person_app_power t where t.app_division_code = ?  and t.person_division_code = ? and t.state = '1'  and t.app_id = ?  and t.person_id not in (select a.area_id from t_app_use_area a where a.app_id = ? and a.type = 'person'))";
            paramList.add(appId);
            paramList.add(appId);
        }
        this.baseDao.updateBySql(sql, paramList.toArray());
    }

    @Override
    public void save(PersonAppPower appPower) {
        this.baseDao.create((Object)appPower);
    }
}

