/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.dao.impl;

import com.xdja.uas.common.basedao.BaseDao;
import com.xdja.uas.common.util.Page;
import com.xdja.uas.empower.entity.RoamTmpAppUseArea;
import com.xdja.uas.roam.dao.RoamAppAuthDao;
import com.xdja.uas.roam.entity.RoamAppUseArea;
import com.xdja.uas.syms.dao.SystemConfigDao;
import com.xdja.uas.syms.entity.SystemConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class RoamAppAuthDaoImpl
implements RoamAppAuthDao {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private SystemConfigDao systemConfigDao;

    @Override
    public void addRoamAppUserAreaEntity(RoamAppUseArea entity) {
        this.baseDao.create((Object)entity);
    }

    @Override
    public void deleteRoamAppUserArea(String appId, String appRegionalismCode, String appNetworkCode, String areaRegionalismCode, String areaType) {
        String sql = "delete from T_ROAM_APP_USE_AREA where APP_ID = ? and APP_REGIONALISM_CODE = ? and APP_NETWORK_CODE = ? and AREA_REGIONALISM_CODE = ? and TYPE = ?";
        this.baseDao.updateBySql(sql, new Object[]{appId, appRegionalismCode, appNetworkCode, areaRegionalismCode, areaType});
        this.baseDao.flushSession();
    }

    @Override
    public List<String> getAuthedPerson(String appId, String appRegionalismCode, String appNetWorkCode, String personRegionalismCode) {
        String sql = "select AREA_ID from T_ROAM_APP_USE_AREA where APP_ID = ? and APP_REGIONALISM_CODE = ?  and AREA_REGIONALISM_CODE = ? and TYPE = 'person'";
        return this.baseDao.getListBySQL(sql, new Object[]{appId, appRegionalismCode, personRegionalismCode}, null);
    }

    @Override
    public RoamAppUseArea checkAuth(String personId, String personRegionalismCode, String appId, String appRegionalismCode, String appNetworkCode) {
        String sql = " from RoamAppUseArea  where areaId = ? and areaRegionalismCode = ? and appId = ? and appRegionalismCode = ? and appNetworkCode = ? and type = 'person'";
        return (RoamAppUseArea)this.baseDao.getObjectByHQL(sql, (Object[])new String[]{personId, personRegionalismCode, appId, appRegionalismCode, appNetworkCode});
    }

    @Override
    public RoamAppUseArea checkAuth(String personId, String personRegionalismCode, String appId, String appRegionalismCode) {
        String sql = " from RoamAppUseArea  where areaId = ? and areaRegionalismCode = ? and appId = ? and appRegionalismCode = ? and type = 'person'";
        return (RoamAppUseArea)this.baseDao.getObjectByHQL(sql, (Object[])new String[]{personId, personRegionalismCode, appId, appRegionalismCode});
    }

    @Override
    public List<RoamAppUseArea> getPersonApp(String personId, String appRegionalism) {
        String hql = "from RoamAppUseArea where areaId = ? and appRegionalismCode = ? and type = 'person'";
        return this.baseDao.getListByHQL(hql, new Object[]{personId, appRegionalism});
    }

    @Override
    public RoamAppUseArea query(String appId, String appRegionalismCode, String personId, String personRegionalismCode) {
        String sql = " from RoamAppUseArea  where areaId = ? and areaRegionalismCode = ? and appId = ? and appRegionalismCode = ? and type = 'person'";
        return (RoamAppUseArea)this.baseDao.getObjectByHQL(sql, (Object[])new String[]{personId, personRegionalismCode, appId, appRegionalismCode});
    }

    @Override
    public void delete(RoamAppUseArea roamAppUseArea) {
        this.baseDao.delete((Object)roamAppUseArea);
    }

    @Override
    public List<RoamAppUseArea> getAppPersons(String appId, String appRegionalismCode) {
        String hql = "from RoamAppUseArea where appId = ? and appRegionalismCode = ? and type = 'person'";
        return this.baseDao.getListByHQL(hql, new Object[]{appId, appRegionalismCode});
    }

    @Override
    public List<RoamAppUseArea> getPersonAllApps(String personId) {
        String hql = "from RoamAppUseArea where areaId = ? and type = 'person'";
        return this.baseDao.getListByHQL(hql, new Object[]{personId});
    }

    @Override
    public List<RoamTmpAppUseArea> queryAppPersonList(String appId, String appRegionalismCode, String appNetworkCode, Page page) {
        Long currentTimestamp = System.currentTimeMillis();
        HashSet ids = new HashSet();
        String maxTimestampStr = this.baseDao.getSingleValue("select nvl(max(N_LAST_UPDATE_TIME) ,0)from T_ROAM_TMP_APP_USE_AREA where app_id='" + appId + "'");
        if (StringUtils.hasText((String)maxTimestampStr)) {
            Long maxTimestamp = Long.parseLong(maxTimestampStr);
            if (currentTimestamp - maxTimestamp >= 300000L) {
                String deleteSql = " delete from T_ROAM_TMP_APP_USE_AREA where app_id = ?";
                this.baseDao.updateBySql(deleteSql, new Object[]{appId});
                String personSql = "select t.area_id as person_id from t_app_use_area t where t.type='person' and t.app_id= ? ";
                List personIds = this.baseDao.getListBySQL(personSql, new Object[]{appId}, null);
                ids.addAll(personIds);
                personIds.clear();
                String depSql = "select id as person_id from t_person where dep_Id in ( select id from t_department dep connect by prior id = parent_id start with id in ( select d.area_id  from (select * from t_app_use_area where type = 'dep') d   left join   (select * from t_app_use_area where type <> 'dep' and type <> 'person') p   on d.app_id = p.app_id   where p.id is null and d.app_id = ? ) and dep.flag = '0' ) and flag='0' ";
                List depIds = this.baseDao.getListBySQL(depSql, new Object[]{appId}, null);
                ids.addAll(depIds);
                depIds.clear();
                String policeSql = "select id as person_id from t_person where flag='0' and dep_id in (  select id from t_department dep connect by prior id = parent_id start with id in (    SELECT distinct d.area_id as depId    FROM t_app_use_area d, t_app_use_area p    WHERE d.app_id = p.app_id    and d.type = 'dep'    and p.type = 'police'    and d.app_id=?  )  ) and police in (   SELECT distinct p.area_id as prop   FROM t_app_use_area d, t_app_use_area p  WHERE d.app_id = p.app_id    and d.type = 'dep'    and p.type = 'police'    and d.app_id=? )  ";
                List policeIds = this.baseDao.getListBySQL(policeSql, new Object[]{appId, appId}, null);
                ids.addAll(policeIds);
                policeIds.clear();
                String sexSql = "select id as person_id from t_person where flag='0' and dep_id in (  select id from t_department dep connect by prior id = parent_id start with id in (    SELECT distinct d.area_id as depId    FROM t_app_use_area d, t_app_use_area p    WHERE d.app_id = p.app_id    and d.type = 'dep'    and p.type = 'sex'    and d.app_id=?  )  ) and sex in (   SELECT distinct p.area_id as prop   FROM t_app_use_area d, t_app_use_area p  WHERE d.app_id = p.app_id    and d.type = 'dep'    and p.type = 'sex'    and d.app_id=? )  ";
                List sexIds = this.baseDao.getListBySQL(sexSql, new Object[]{appId, appId}, null);
                ids.addAll(sexIds);
                sexIds.clear();
                String personTypeSql = "select id as person_id from t_person where flag='0' and dep_id in (  select id from t_department dep connect by prior id = parent_id start with id in (    SELECT distinct d.area_id as depId    FROM t_app_use_area d, t_app_use_area p    WHERE d.app_id = p.app_id    and d.type = 'dep'     and p.type = 'PERSON_TYPE'    and d.app_id=?  )  ) and person_type in (   SELECT distinct p.area_id as prop   FROM t_app_use_area d, t_app_use_area p  WHERE d.app_id = p.app_id    and d.type = 'dep'    and p.type = 'PERSON_TYPE'    and d.app_id=? )  ";
                List personTypeIds = this.baseDao.getListBySQL(personTypeSql, new Object[]{appId, appId}, null);
                ids.addAll(personTypeIds);
                personTypeIds.clear();
                ArrayList<RoamTmpAppUseArea> list = new ArrayList<RoamTmpAppUseArea>();
                RoamTmpAppUseArea tmpAppUseArea = null;
                SystemConfig sys = this.systemConfigDao.getByCode("regionalismCode");
                String regCode = "";
                if (sys == null) {
                    throw new RuntimeException("\u672a\u914d\u7f6e\u884c\u653f\u533a\u5212");
                }
                regCode = sys.getValue();
                for (String id : ids) {
                    tmpAppUseArea = new RoamTmpAppUseArea();
                    tmpAppUseArea.setPersonId(id);
                    tmpAppUseArea.setAppId(appId);
                    tmpAppUseArea.setAppRegionalismCode(regCode);
                    tmpAppUseArea.setnLastUpdateTime(currentTimestamp);
                    tmpAppUseArea.setRegionalismCode(regCode);
                    list.add(tmpAppUseArea);
                }
                List<RoamAppUseArea> roamAppUseAreas = this.getAppPersons(appId, appRegionalismCode);
                if (!CollectionUtils.isEmpty(roamAppUseAreas)) {
                    for (RoamAppUseArea roamAppUseArea : roamAppUseAreas) {
                        tmpAppUseArea = new RoamTmpAppUseArea();
                        tmpAppUseArea.setPersonId(roamAppUseArea.getAreaId());
                        tmpAppUseArea.setAppId(roamAppUseArea.getAppId());
                        tmpAppUseArea.setAppRegionalismCode(roamAppUseArea.getAppRegionalismCode());
                        tmpAppUseArea.setRegionalismCode(roamAppUseArea.getAreaRegionalismCode());
                        tmpAppUseArea.setnLastUpdateTime(currentTimestamp);
                        list.add(tmpAppUseArea);
                    }
                }
                this.baseDao.createBatch(list);
            }
        }
        String selectSql = "select  *  from T_ROAM_TMP_APP_USE_AREA  where app_id= ? and app_regionalism_code = ? ";
        String countSql = "select count(1) from T_ROAM_TMP_APP_USE_AREA where app_id= ? and app_regionalism_code = ? ";
        List result = this.baseDao.getListBySQL(countSql, selectSql, new Object[]{appId, appRegionalismCode}, page, RoamTmpAppUseArea.class);
        return result;
    }
}

