/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.dao.impl;

import com.xdja.uas.common.basedao.BaseDao;
import com.xdja.uas.roam.dao.RoamPersonDao;
import com.xdja.uas.roam.entity.RoamPerson;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RoamPersonDaoImpl
implements RoamPersonDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public RoamPerson getByPersonIdAndRegionalismCode(String personId, String regionalismCode) {
        String hql = "from RoamPerson where personId = ? and regionalismCode = ?";
        return (RoamPerson)this.baseDao.getObjectByHQL(hql, new Object[]{personId, regionalismCode});
    }

    @Override
    public void saveRoamPerson(RoamPerson roamPerson) {
        if (org.springframework.util.StringUtils.hasText((String)roamPerson.getId())) {
            this.baseDao.update((Object)roamPerson);
        } else {
            this.baseDao.create((Object)roamPerson);
        }
    }

    @Override
    public List<RoamPerson> queryAppPersonList(String appId, String appRegionalismCode, String appNetworkCode) {
        StringBuilder sql = new StringBuilder("select * from t_roam_person p where 1=1 ");
        sql.append(" and p.person_id in(select area_id from t_roam_app_use_area where app_id = ? and APP_REGIONALISM_CODE = ? ");
        if (null != appNetworkCode && StringUtils.isNotEmpty((CharSequence)appNetworkCode)) {
            sql.append("and APP_NETWORK_CODE = ? ");
        }
        sql.append("and type = 'person') ");
        return this.baseDao.getListBySQL(sql.toString(), (Object[])new String[]{appId, appRegionalismCode, appNetworkCode}, RoamPerson.class);
    }
}

