/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.entity;

import com.xdja.uas.roam.bean.AppInfo;
import com.xdja.uas.roam.bean.Credential;
import com.xdja.uas.roam.bean.V1AppInfo;
import com.xdja.uas.roam.bean.V2AppInfo;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="T_ROAM_APP_CREDENTIAL")
public class AppCredential {
    private String tokenId;
    private String regionalismCode;
    private Long startTime;
    private Long endTime;
    private String appId;
    private String appRegionalismCode;
    private String appNetworkCode;
    private String alg;
    private String signature;
    private String sn;
    private String url;

    public AppCredential() {
    }

    public AppCredential(Credential credential) {
        this.alg = credential.getServerSign().getAlg();
        AppInfo appInfo = credential.getLoad().getAppInfo();
        this.appId = appInfo.getAppId();
        this.appRegionalismCode = appInfo.getOrgId();
        if (appInfo instanceof V1AppInfo) {
            V1AppInfo v1AppInfo = (V1AppInfo)appInfo;
            this.appNetworkCode = v1AppInfo.getAppNetworkCode();
        }
        if (appInfo instanceof V2AppInfo) {
            V2AppInfo v2AppInfo = (V2AppInfo)appInfo;
            this.appNetworkCode = v2AppInfo.getNetworkAreaCode();
        }
        this.regionalismCode = credential.getHead().getToken().getOrgId();
        this.signature = credential.getServerSign().getSignature();
        this.sn = credential.getServerSign().getSn();
        this.url = credential.getServerSign().getUrl();
        this.startTime = Long.valueOf(credential.getHead().getDuration().getStartTime());
        this.endTime = Long.valueOf(credential.getHead().getDuration().getEndTime());
        this.tokenId = credential.getHead().getToken().getTokenId();
    }

    public AppCredential(String tokenId, String regionalismCode, Long startTime, Long endTime, String appId, String appRegionalismCode, String appNetworkCode, String alg, String signature, String sn, String url) {
        this.tokenId = tokenId;
        this.regionalismCode = regionalismCode;
        this.startTime = startTime;
        this.endTime = endTime;
        this.appId = appId;
        this.appRegionalismCode = appRegionalismCode;
        this.appNetworkCode = appNetworkCode;
        this.alg = alg;
        this.signature = signature;
        this.sn = sn;
        this.url = url;
    }

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    @Column(name="TOKEN_ID")
    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    @Column(name="REGIONALISM_CODE")
    public String getRegionalismCode() {
        return this.regionalismCode;
    }

    public void setRegionalismCode(String regionalismCode) {
        this.regionalismCode = regionalismCode;
    }

    @Column(name="START_TIME")
    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    @Column(name="END_TIME")
    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    @Column(name="APP_ID")
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Column(name="APP_REGIONALISM_CODE")
    public String getAppRegionalismCode() {
        return this.appRegionalismCode;
    }

    public void setAppRegionalismCode(String appRegionalismCode) {
        this.appRegionalismCode = appRegionalismCode;
    }

    @Column(name="APP_NETWORK_CODE")
    public String getAppNetworkCode() {
        return this.appNetworkCode;
    }

    public void setAppNetworkCode(String appNetworkCode) {
        this.appNetworkCode = appNetworkCode;
    }

    @Column(name="ALG")
    public String getAlg() {
        return this.alg;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    @Column(name="SIGNATURE")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Column(name="SN")
    public String getSn() {
        return this.sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    @Column(name="URL")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

