/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.entity;

import com.xdja.uas.roam.bean.Credential;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="T_ROAM_PERSON_CREDENTIAL")
public class PersonCredential {
    private String tokenId;
    private String regionalismCode;
    private Long startTime;
    private Long endTime;
    private String userId;
    private String alg;
    private String signature;
    private String sn;
    private String url;

    public PersonCredential(Credential credential) {
        this.alg = credential.getServerSign().getAlg();
        this.userId = credential.getLoad().getUserInfo().getUserId();
        this.regionalismCode = credential.getHead().getToken().getOrgId();
        this.signature = credential.getServerSign().getSignature();
        this.sn = credential.getServerSign().getSn();
        this.url = credential.getServerSign().getUrl();
        this.startTime = Long.valueOf(credential.getHead().getDuration().getStartTime());
        this.endTime = Long.valueOf(credential.getHead().getDuration().getEndTime());
        this.tokenId = credential.getHead().getToken().getTokenId();
    }

    public PersonCredential() {
    }

    public PersonCredential(String tokenId, String regionalismCode, Long startTime, Long endTime, String userId, String alg, String signature, String sn, String url) {
        this.tokenId = tokenId;
        this.regionalismCode = regionalismCode;
        this.startTime = startTime;
        this.endTime = endTime;
        this.userId = userId;
        this.alg = alg;
        this.signature = signature;
        this.sn = sn;
        this.url = url;
    }

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    @Column(name="TOKEN_ID")
    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    @Column(name="REGIONALISM_CODE")
    public String getRegionalismCode() {
        return this.regionalismCode;
    }

    public void setRegionalismCode(String regionalismCode) {
        this.regionalismCode = regionalismCode;
    }

    @Column(name="START_TIME")
    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    @Column(name="END_TIME")
    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    @Column(name="USER_ID")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Column(name="ALG")
    public String getAlg() {
        return this.alg;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    @Column(name="SIGNATURE")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Column(name="SN")
    public String getSn() {
        return this.sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    @Column(name="URL")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

