/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.service.impl;

import com.xdja.uas.common.util.Page;
import com.xdja.uas.common.util.Util;
import com.xdja.uas.roam.bean.AppResourceBean;
import com.xdja.uas.roam.dao.AppResourceDao;
import com.xdja.uas.roam.entity.AppResource;
import com.xdja.uas.roam.service.AppResourceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppResourceServiceImpl
implements AppResourceService {
    private static final Logger logger = LoggerFactory.getLogger(AppResourceServiceImpl.class);
    @Autowired
    private AppResourceDao appResourceDao;

    @Override
    @Transactional
    public List<AppResourceBean> importAppRes(List<AppResourceBean> appResourceBeans) {
        try {
            ArrayList<AppResource> appResources = new ArrayList<AppResource>();
            for (AppResourceBean appResourceBean : appResourceBeans) {
                AppResource query = this.appResourceDao.query(appResourceBean);
                if (query != null) {
                    if (query.getStatus() == 0) {
                        query.setStatus(1);
                        query.setLastUpdateTime(System.currentTimeMillis());
                        this.appResourceDao.update(query);
                        continue;
                    }
                    logger.warn("\u8be5\u5e94\u7528\u8d44\u6e90\u6743\u9650\u4fe1\u606f\u5df2\u5b58\u5728\uff1a{}", (Object)Util.toJsonStr((Object)appResourceBean));
                    continue;
                }
                AppResource appResource = new AppResource();
                BeanUtils.copyProperties((Object)appResourceBean, (Object)appResource);
                appResource.setCreateTime(System.currentTimeMillis());
                appResource.setLastUpdateTime(System.currentTimeMillis());
                appResource.setStatus(1);
                appResources.add(appResource);
            }
            this.appResourceDao.createBatch(appResources);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5e94\u7528\u8d44\u6e90\u6743\u9650\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return appResourceBeans;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> syncAppResource(Long lastUpdateTime, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = new Page(pageNo.intValue(), pageSize.intValue());
        List<AppResource> appResources = this.appResourceDao.queryByTimestamp(lastUpdateTime, page);
        result.put("data", appResources);
        result.put("total", page.getTotal());
        return result;
    }
}

