/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uas.roam.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.xdja.agreement.config.SystemConfig;
import com.xdja.uas.bims.entity.Person;
import com.xdja.uas.bims.service.UserManageService;
import com.xdja.uas.common.bean.RestfulQuery;
import com.xdja.uas.common.bean.RestfulResult;
import com.xdja.uas.common.bean.Result;
import com.xdja.uas.common.util.HttpRequestUtil;
import com.xdja.uas.common.util.MessageManager;
import com.xdja.uas.common.util.Page;
import com.xdja.uas.common.util.Util;
import com.xdja.uas.empower.dao.EmpowerDao;
import com.xdja.uas.empower.entity.AppUseArea;
import com.xdja.uas.empower.service.AppPlatformService;
import com.xdja.uas.roam.bean.RmcInterface;
import com.xdja.uas.roam.bean.RmcResultData;
import com.xdja.uas.roam.dao.AppPowerApproveDao;
import com.xdja.uas.roam.service.AppRoamService;
import com.xdja.uas.sso.bean.PersonAppPowerBean;
import com.xdja.uas.sso.bean.V2UserInfo;
import com.xdja.uas.sso.entity.PersonAppPower;
import com.xdja.uas.sso.service.SingleSignOnService;
import com.xdja.uas.syms.service.SystemConfigService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class AppRoamServiceImpl
implements AppRoamService {
    private static final Logger log = LoggerFactory.getLogger(AppRoamServiceImpl.class);
    @Autowired
    private AppPowerApproveDao appPowerApproveDao;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private AppPlatformService appPlatFormService;
    @Autowired
    private SingleSignOnService singleSignOnService;
    @Autowired
    private EmpowerDao empowerDao;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public Map<String, Object> list(PersonAppPowerBean personAppPowerBean) {
        Page page = new Page();
        page.setPage(personAppPowerBean.getPage().intValue());
        page.setRp(personAppPowerBean.getRows().intValue());
        List<PersonAppPower> personAppPowers = this.appPowerApproveDao.query(personAppPowerBean, page);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String uasCode = SystemConfig.getInstance().getString("application.roam.area.code");
        map.put("uasCode", uasCode);
        map.put("total", page.getTotal());
        map.put("pageNo", page.getPage());
        map.put("rows", personAppPowers);
        return map;
    }

    @Override
    public boolean checkAuth(String personId, String personAreaCode, String appFlag, String appAreaCode) {
        return this.appPowerApproveDao.checkAuth(personId, personAreaCode, appFlag, appAreaCode);
    }

    @Override
    public boolean checkAuth(String personId, String personAreaCode, String packageName) {
        return this.appPowerApproveDao.checkAuth(personId, personAreaCode, packageName);
    }

    @Override
    public List<PersonAppPower> listPersonAppPower(String personId, String personAreaCode, String appAreaCode, String state) {
        List<PersonAppPower> list = this.appPowerApproveDao.list(personId, personAreaCode, appAreaCode, state);
        ArrayList<PersonAppPower> result = new ArrayList<PersonAppPower>();
        for (PersonAppPower personAppPower : list) {
            String s = personAppPower.getState();
            if (!"0".equals(s) && !"1".equals(s)) continue;
            result.add(personAppPower);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result changePower(String personId, String personAreaCode, String appId, String appAreaCode, String state, String sourceAreaCode) throws Exception {
        Result result = new Result("0", null, null);
        try {
            String localCode = SystemConfig.getInstance().getString("application.roam.area.code");
            boolean isLocalPerson = personAreaCode.equals(localCode);
            boolean isLocalApp = appAreaCode.equals(localCode);
            if (isLocalPerson && isLocalApp) {
                AppUseArea appUseArea;
                if (("2".equals(state) || "3".equals(state)) && (appUseArea = this.empowerDao.queryAppUseByPersonIdAndAppId(appId, personId)) != null) {
                    this.empowerDao.deleteAppUseArea(appUseArea);
                }
                if ("1".equals(state)) {
                    appUseArea = this.empowerDao.queryAppUseByPersonIdAndAppId(appId, personId);
                    if (appUseArea == null) {
                        appUseArea = new AppUseArea();
                        appUseArea.setAppId(appId);
                        appUseArea.setAreaId(personId);
                        appUseArea.setType("person");
                        this.empowerDao.saveAppUseArea(appUseArea);
                    } else {
                        log.debug("\u8be5\u4eba\u5458\u5df2\u6709\u8be5\u5e94\u7528\u6743\u9650");
                    }
                }
            }
            this.appPowerApproveDao.changePower(personId, personAreaCode, appId, appAreaCode, state);
            if (!isLocalApp && localCode.equalsIgnoreCase(sourceAreaCode)) {
                result = this.remoteChangePower(personId, personAreaCode, appId, appAreaCode, state, appAreaCode, sourceAreaCode);
            }
            if (!isLocalPerson && localCode.equalsIgnoreCase(sourceAreaCode)) {
                result = this.remoteChangePower(personId, personAreaCode, appId, appAreaCode, state, personAreaCode, sourceAreaCode);
            }
            if (result == null || !"0".equals(result.getFlag())) {
                throw new Exception("\u5f02\u5730\u6821\u9a8c\u53d8\u66f4\u5931\u8d25");
            }
        }
        catch (Exception e) {
            String smg = MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"app.roam.power.opt.error") + e.getMessage();
            throw new Exception(smg);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result applyPowerStatus(String personId, String personAreaCode, String appId, String appAreaCode, String state, String sourceAreaCode) throws Exception {
        Result result = new Result("0", null, null);
        try {
            String localCode = SystemConfig.getInstance().getString("application.roam.area.code");
            boolean isLocalPerson = personAreaCode.equals(localCode);
            boolean isLocalApp = appAreaCode.equals(localCode);
            if (isLocalPerson && isLocalApp) {
                AppUseArea appUseArea;
                if (("2".equals(state) || "3".equals(state)) && (appUseArea = this.empowerDao.queryAppUseByPersonIdAndAppId(appId, personId)) != null) {
                    this.empowerDao.deleteAppUseArea(appUseArea);
                }
                if ("1".equals(state)) {
                    appUseArea = this.empowerDao.queryAppUseByPersonIdAndAppId(appId, personId);
                    if (appUseArea == null) {
                        appUseArea = new AppUseArea();
                        appUseArea.setAppId(appId);
                        appUseArea.setAreaId(personId);
                        appUseArea.setType("person");
                        this.empowerDao.saveAppUseArea(appUseArea);
                    } else {
                        log.debug("\u8be5\u4eba\u5458\u5df2\u6709\u8be5\u5e94\u7528\u6743\u9650");
                    }
                }
            }
            this.appPowerApproveDao.changePower(personId, personAreaCode, appId, appAreaCode, state);
            if (!isLocalApp && localCode.equalsIgnoreCase(sourceAreaCode)) {
                result = this.remoteApplyPower(personId, personAreaCode, appId, appAreaCode, state, appAreaCode, sourceAreaCode);
            }
            if (!isLocalPerson && localCode.equalsIgnoreCase(sourceAreaCode)) {
                result = this.remoteApplyPower(personId, personAreaCode, appId, appAreaCode, state, personAreaCode, sourceAreaCode);
            }
            if (result == null || !"0".equals(result.getFlag())) {
                throw new Exception("\u5f02\u5730\u6821\u9a8c\u53d8\u66f4\u5931\u8d25");
            }
        }
        catch (Exception e) {
            String smg = MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"app.roam.power.opt.error") + e.getMessage();
            throw new Exception(smg);
        }
        return result;
    }

    private Result remoteApplyPower(String personId, String personAreaCode, String appId, String appAreaCode, String state, String targetArea, String sourceAreaCode) {
        String url = "";
        try {
            url = this.getAddressFromRoamCenter(targetArea, "APP_POWER_STATUS");
        }
        catch (RuntimeException e) {
            return new Result("4", e.getMessage());
        }
        HttpRequestUtil util = new HttpRequestUtil();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appId", appId);
        param.put("personId", personId);
        param.put("personDivisionCode", personAreaCode);
        param.put("appDivisionCode", appAreaCode);
        param.put("type", state);
        param.put("sourceAreaCode", sourceAreaCode);
        try {
            String rs = util.postBody(url, param);
            return (Result)JSON.parseObject((String)rs, Result.class);
        }
        catch (Exception e) {
            throw new RuntimeException(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"app.roam.power.ramote.error"));
        }
    }

    private Result remoteChangePower(String personId, String personAreaCode, String appId, String appAreaCode, String state, String targetArea, String sourceAreaCode) {
        String url;
        try {
            url = this.getAddressFromRoamCenter(targetArea, "APP_POWER_CHANGE");
        }
        catch (RuntimeException e) {
            return new Result("4", e.getMessage());
        }
        HttpRequestUtil util = new HttpRequestUtil();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appId", appId);
        param.put("personId", personId);
        param.put("personDivisionCode", personAreaCode);
        param.put("appDivisionCode", appAreaCode);
        param.put("type", state);
        param.put("sourceAreaCode", sourceAreaCode);
        try {
            String rs = util.postBody(url, param);
            return (Result)JSON.parseObject((String)rs, Result.class);
        }
        catch (Exception e) {
            throw new RuntimeException(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"app.roam.power.ramote.error"));
        }
    }

    @Override
    @Transactional
    public Result applyPower(PersonAppPowerBean bean) throws RuntimeException {
        Result result;
        String personId = bean.getPersonId();
        if (!Strings.isNullOrEmpty((String)personId)) {
            PersonAppPower appPower = this.assembleEntity(bean);
            if (this.checkAppPower(appPower)) {
                return new Result("4", "\u8be5\u4eba\u5458\u5df2\u7533\u8bf7\u8fc7\u8be5\u5e94\u7528\uff0c\u65e0\u9700\u91cd\u590d\u7533\u8bf7");
            }
            this.appPowerApproveDao.save(appPower);
            result = new Result("0", "[\u672c\u5730]\u6743\u9650\u7533\u8bf7\u6210\u529f", null);
        } else {
            String[] billArr = bean.getToken().split("\\|");
            if (billArr.length < 3) {
                return new Result("4", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"sso.signlesignonservice.error.receivebillerror"), null);
            }
            result = this.singleSignOnService.checkBill(billArr[0] + "|" + billArr[1]);
            log.debug("\u7968\u636e\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)Util.toJsonStr((Object)result));
            if ("0".equals(result.getFlag())) {
                PersonAppPower appPower = this.assembleEntity(bean);
                if (this.checkAppPower(appPower)) {
                    return new Result("4", "\u8be5\u4eba\u5458\u5df2\u7533\u8bf7\u8fc7\u8be5\u5e94\u7528\uff0c\u65e0\u9700\u91cd\u590d\u7533\u8bf7");
                }
                this.appPowerApproveDao.save(appPower);
                result.setMessage("[\u672c\u5730]\u6743\u9650\u7533\u8bf7\u6210\u529f");
                if (!SystemConfig.getInstance().getString("application.roam.area.code").equalsIgnoreCase(bean.getAppDivisionCode())) {
                    String address;
                    HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
                    try {
                        address = this.getAddressFromRoamCenter(bean.getAppDivisionCode(), "APP_APPLY_REQUEST");
                    }
                    catch (RuntimeException e) {
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        return new Result("4", e.getMessage());
                    }
                    String resultJson = httpRequestUtil.httpPostJson(address, Util.toJsonStr((Object)bean));
                    log.debug("\u524d\u5f80\u5f02\u5730uas\u6743\u9650\u7533\u8bf7\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)resultJson);
                    Result remoteResult = (Result)JSON.parseObject((String)resultJson, Result.class);
                    if (!"0".equalsIgnoreCase(remoteResult.getFlag())) {
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    } else {
                        remoteResult.setMessage("[\u5f02\u5730]\u6743\u9650\u7533\u8bf7\u6210\u529f");
                    }
                    return remoteResult;
                }
            }
        }
        return result;
    }

    @Override
    public String getAddressFromRoamCenter(String divisionCode, String interfaceCode) {
        log.debug("\u524d\u5f80\u6f2b\u6e38\u4e2d\u5fc3\u83b7\u53d6\u63a5\u53e3\u5730\u5740\uff0cdivisionCode\uff1a{}\uff0cinterfaceCode\uff1a{}", (Object)divisionCode, (Object)interfaceCode);
        String roamCenterAddress = this.systemConfigService.getValueByCode("APP_ROAM_CENTER_URL");
        roamCenterAddress = roamCenterAddress + "/api/interface/list";
        HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
        String param = "divisionCode=" + divisionCode + "&interfaceCode=" + interfaceCode;
        String result = httpRequestUtil.get(roamCenterAddress, param);
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new RuntimeException("\u524d\u5f80\u6f2b\u6e38\u4e2d\u5fc3\u83b7\u53d6\u63a5\u53e3\u5730\u5740\u51fa\u9519\uff1a\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if ((Integer)jsonObject.get((Object)"flag") == 0) {
            log.error("\u524d\u5f80\u6f2b\u6e38\u4e2d\u5fc3\u83b7\u53d6\u63a5\u53e3\u5730\u5740\u51fa\u9519\uff1a{}", jsonObject.get((Object)"message"));
            throw new RuntimeException((String)jsonObject.get((Object)"message"));
        }
        JSONArray dataArray = jsonObject.getJSONArray("data");
        if (CollectionUtils.isEmpty((Collection)dataArray)) {
            throw new RuntimeException("\u524d\u5f80\u6f2b\u6e38\u4e2d\u5fc3\u83b7\u53d6\u63a5\u53e3\u5730\u5740\u51fa\u9519\uff1adata\u4e2d\u5185\u5bb9\u4e3a\u7a7a");
        }
        JSONArray jsonArray = dataArray.getJSONObject(0).getJSONArray("areaList");
        if (jsonArray.size() > 1) {
            throw new RuntimeException("\u524d\u5f80\u6f2b\u6e38\u4e2d\u5fc3\u83b7\u53d6\u63a5\u53e3\u5730\u5740\u51fa\u9519\uff1a\u8fd4\u56de\u533a\u57df\u4e3a\u591a\u4e2a");
        }
        return (String)jsonArray.getJSONObject(0).getJSONArray("interfaceList").getJSONObject(0).get((Object)"interfaceAddress");
    }

    private boolean checkAppPower(PersonAppPower power) {
        return this.appPowerApproveDao.checkIsExist(power);
    }

    private PersonAppPower assembleEntity(PersonAppPowerBean bean) {
        PersonAppPower appPower = new PersonAppPower();
        if (!Strings.isNullOrEmpty((String)bean.getPersonId())) {
            Person person = this.userManageService.queryPersonById(bean.getPersonId());
            BeanUtils.copyProperties((Object)bean, (Object)appPower);
            appPower.setLastUpdateTime(Long.valueOf(System.currentTimeMillis()));
            appPower.setCreateTime(Long.valueOf(System.currentTimeMillis()));
            appPower.setState("0");
            appPower.setCode(person.getCode());
            appPower.setDepCode(person.getDepartment().getCode());
            appPower.setDepName(person.getDepartment().getName());
            appPower.setSex(person.getSex());
            appPower.setPersonType(person.getPersonType());
            appPower.setPersonId(person.getId());
            appPower.setPersonDivisionCode(SystemConfig.getInstance().getString("application.roam.area.code"));
            appPower.setName(person.getName());
            appPower.setMobile(person.getMobile());
            appPower.setIdentifier(person.getIdentifier());
        } else {
            String billStr = bean.getToken();
            String[] billArr = billStr.split("\\|");
            String personDivisionCode = "";
            if (billArr.length >= 2 && !Util.varCheckEmp((String)billArr[1])) {
                personDivisionCode = billArr[1];
            }
            V2UserInfo userInfo = this.singleSignOnService.getUserInfoFromV2BillJson(billArr[0]);
            BeanUtils.copyProperties((Object)bean, (Object)appPower);
            appPower.setLastUpdateTime(Long.valueOf(System.currentTimeMillis()));
            appPower.setCreateTime(Long.valueOf(System.currentTimeMillis()));
            appPower.setState("0");
            appPower.setCode(userInfo.getCode());
            appPower.setDepCode(userInfo.getDepcode());
            appPower.setDepName(userInfo.getDepname());
            appPower.setSex(userInfo.getSex());
            appPower.setPersonType(userInfo.getPersonType());
            appPower.setPersonId(userInfo.getId());
            appPower.setPersonDivisionCode(personDivisionCode);
            appPower.setName(userInfo.getName());
            appPower.setMobile(userInfo.getMobile());
            appPower.setIdentifier(userInfo.getIdentifier());
        }
        return appPower;
    }

    @Override
    public RmcInterface getInterface(String regionalismCode, String netWorkCode, String interfaceCode) {
        try {
            HttpRequestUtil httpRequestUtil = new HttpRequestUtil();
            String roamCenterAddress = this.systemConfigService.getValueByCode("sodUrl");
            roamCenterAddress = this.spellUrl(roamCenterAddress, "/services/queryInterfaceList");
            RestfulQuery restfulQuery = new RestfulQuery();
            String messageID = UUID.randomUUID().toString().replace("-", "");
            log.info("\u83b7\u53d6\u5f02\u5730uas\u7f51\u7edc\u5730\u5740\u7684messageId:{}", (Object)messageID);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("regionalismCode", regionalismCode);
            param.put("interfaceCode", interfaceCode);
            param.put("networkCode", netWorkCode);
            restfulQuery.setMessageId(messageID);
            restfulQuery.setParameter(param);
            restfulQuery.setVersion("1.0");
            String result = httpRequestUtil.httpPostJson(roamCenterAddress, JSON.toJSONString((Object)restfulQuery));
            RestfulResult restfulResult = RestfulResult.getInstanceListDate((String)result, RmcResultData.class);
            Assert.notNull((Object)restfulResult, (String)"rmc\u8fd4\u56de\u6570\u636e\u5f02\u5e38");
            String returnMessageId = restfulResult.getMessageId();
            Assert.state((boolean)messageID.equals(returnMessageId), (String)"\u83b7\u53d6\u5f02\u5730\u5e94\u7528\u5730\u5740\u8fd4\u56demessageID\u9519\u8bef");
            String code = restfulResult.getCode();
            Assert.state((boolean)"200".equals(code), (String)("rmc\u8fd4\u56de\u7ed3\u679c: " + restfulResult.getMessage()));
            List rmcResultData = (List)restfulResult.getData();
            return ((RmcResultData)rmcResultData.get(0)).getAreaList().get(0).getInterfaceList().get(0);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f02\u5730uas\u5730\u5740\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    private String spellUrl(String part1, String part2) {
        StringBuilder sb = new StringBuilder();
        if (part1.endsWith("/")) {
            sb.append(part1.substring(0, part1.lastIndexOf("/")));
        } else {
            sb.append(part1);
        }
        if (part2.startsWith("/")) {
            sb.append(part2);
        } else {
            sb.append("/").append(part2);
        }
        return sb.toString();
    }
}

